package com.instabug.library.model.session;

import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import java.util.Collections;
import java.util.List;
import java.util.Map;

@Keep
public class SessionsBatchDTO {

    @Nullable
    private String productionUsage;
    @NonNull
    private final Map<String, Object> commonKeys;
    @NonNull
    private final List<SessionRemoteEntity> sessions;

    public SessionsBatchDTO(@NonNull Map<String, Object> commonKeys, @NonNull List<SessionRemoteEntity> sessions) {
        this.commonKeys = commonKeys;
        this.sessions = sessions;
    }

    @NonNull
    public Map<String, Object> getCommonKeys() {
        return Collections.unmodifiableMap(commonKeys);
    }

    @NonNull
    public List<SessionRemoteEntity> getSessions() {
        return Collections.unmodifiableList(sessions);
    }

    public void setProductionUsage(@Nullable String productionUsage) {
        this.productionUsage = productionUsage;
    }

    @Nullable
    public String getProductionUsage() {
        return productionUsage;
    }
}
