package com.instabug.library.model.session;

import androidx.annotation.Keep;
import androidx.annotation.NonNull;

import java.util.Collections;
import java.util.Map;

@Keep
public class SessionRemoteEntity {

    private final String id;
    @NonNull
    private final Map<String, Object> map;

    SessionRemoteEntity(String id, @NonNull Map<String, Object> map) {
        this.id = id;
        this.map = map;
    }

    @NonNull
    public String getId() {
        return id;
    }

    @NonNull
    public Map<String, Object> getMap() {
        return Collections.unmodifiableMap(map);
    }
}
