package com.instabug.library.migration;

import android.annotation.SuppressLint;
import android.content.Context;

import com.instabug.library.BuildConfig;
import com.instabug.library.internal.storage.cache.CacheManager;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.StringUtility;

import androidx.annotation.NonNull;
import io.reactivexport.Observable;
import io.reactivexport.ObservableEmitter;
import io.reactivexport.ObservableOnSubscribe;

public class SDKForwardMigration extends AbstractMigration {

    private static final String SDK_FORWARD_MIGRATION = "sdk_forward_migration";

    SDKForwardMigration() {
        super(SDK_FORWARD_MIGRATION);
    }

    @Override
    public int getMigrationVersion() {
        return 4;
    }

    @Override
    public void initialize(@NonNull Context context) {

    }

    @SuppressLint("NULL_DEREFERENCE")
    @Override
    public boolean shouldMigrate() {
        // return true if the current SDK version greater than the last SDK version
        String lastSDKVersion = SettingsManager.getInstance().getLastSDKVersion();
        if (BuildConfig.SDK_VERSION.contains("-") || lastSDKVersion.contains("-")) {
            return StringUtility.compareVersion(String.valueOf(BuildConfig.SDK_VERSION.charAt(0)),
                    String.valueOf(lastSDKVersion.charAt(0))) == 1
                    || !SettingsManager.getInstance().isSDKVersionSet();
        } else {
            return StringUtility.compareVersion(BuildConfig.SDK_VERSION, lastSDKVersion) == 1
                    || !SettingsManager.getInstance().isSDKVersionSet();
        }
    }

    @Override
    public Observable<AbstractMigration> migrate() {
        return Observable.create(new ObservableOnSubscribe<AbstractMigration>() {
            @Override
            public void subscribe(ObservableEmitter<AbstractMigration> emitter) {
                CacheManager.getInstance().invalidateAllCaches();
                emitter.onNext(SDKForwardMigration.this);
                emitter.onComplete();
            }
        });
    }

    @Override
    public void doPreMigration() {

    }

    @Override
    public void doAfterMigration() {
        SettingsManager.getInstance().setCurrentSDKVersion(BuildConfig.SDK_VERSION);
    }
}
