package com.instabug.library.migration;

import android.content.Context;
import android.content.Intent;

import com.instabug.library.settings.SettingsManager;

import androidx.annotation.NonNull;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import io.reactivexport.Observable;
import io.reactivexport.ObservableEmitter;
import io.reactivexport.ObservableOnSubscribe;

/**
 * Created by mesbah on 12/24/2015.
 */
public class LastContactedAtMigration extends AbstractMigration {

    private static String LAST_CONTACTED_AT_MIGRATION_ID = "last_contacted_at_migration";

    public LastContactedAtMigration() {
        super(LAST_CONTACTED_AT_MIGRATION_ID);
    }

    @Override
    public String getMigrationId() {
        return LAST_CONTACTED_AT_MIGRATION_ID;
    }

    @Override
    public int getMigrationVersion() {
        return 1;
    }

    @Override
    public void initialize(@NonNull Context context) {
    }

    @Override
    public boolean shouldMigrate() {
        return getMigrationVersion() > SettingsManager.getInstance().getLastMigrationVersion()
                && SettingsManager.getInstance().isDeviceRegistered()
                && (SettingsManager.getInstance().getLastContactedAt() == 0L);
    }

    @Override
    public Observable<AbstractMigration> migrate() {

        return Observable.create(new ObservableOnSubscribe<AbstractMigration>() {
            @Override
            public void subscribe(ObservableEmitter<AbstractMigration> emitter) {
            }
        });
    }

    @Override
    public void doPreMigration() {

    }

    @Override
    public void doAfterMigration() {

    }
}
