package com.instabug.library.internal.storage.executor;

import android.content.Context;
import android.net.Uri;

import com.instabug.library.internal.storage.operation.DiskOperation;
import com.instabug.library.internal.storage.operation.DiskOperationCallback;

import java.io.IOException;

import androidx.annotation.NonNull;

public class WriteOperationExecutor {

    private final Context context;
    private final DiskOperation<Uri, Context> operation;

    public WriteOperationExecutor(@NonNull Context context, DiskOperation<Uri, Context> operation) {
        this.context = context;
        this.operation = operation;
    }

    public Uri execute() throws IOException {
        return operation.execute(context);
    }

    public void executeAsync(DiskOperationCallback<Uri> callback) {
        operation.executeAsync(context, callback);
    }
}
