package com.instabug.library.internal.storage.cache.dbv2;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.Build;

import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;

import com.instabug.library.internal.storage.cache.dbv2.migration.MigrationEngine;

public class IBGDBHelper extends SQLiteOpenHelper {

    private static final String DATABASE_NAME = "instabug_encrypted.db";


    public IBGDBHelper(@Nullable Context context) {
        super(context, DATABASE_NAME, null, IBGEncryptedDbVersions.CURRENT_VERSION);
    }

    @Override
    public void onCreate(SQLiteDatabase db) {
        MigrationEngine.onCreate(db);
    }

    @WorkerThread
    @Override
    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        MigrationEngine.onUpgrade(db, oldVersion);
    }

    @Override
    public void onConfigure(SQLiteDatabase db) {
        super.onConfigure(db);
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN) {
            db.setForeignKeyConstraintsEnabled(true);
        }
    }

    @Override
    public void onOpen(SQLiteDatabase db) {
        super.onOpen(db);
        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.JELLY_BEAN) {
            db.execSQL("PRAGMA foreign_keys=ON;");
        }
    }

    @WorkerThread
    @Override
    public void onDowngrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        MigrationEngine.onDowngrade(db);
    }
}
