package com.instabug.library.internal.storage.cache.db;

import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.UserAttributesEntry;
import static com.instabug.library.internal.storage.cache.db.InstabugDbContract.UserInteractions;

import android.database.sqlite.SQLiteDatabase;
/**
 * Created by Barakat on 03/09/2019
 */

/**
 * Starting from SDK ver. 8.4.0 (DB ver. 12), UserInteractions on surveys was introduced
 * Any further update in Instabug DB schema should migrate and keep all data related to surveys and interactions
 * In previous versions we drop/recreate tables
 * This class was created to keep track of instabug versioning, and provide a quick doc for each version changes.
 * {@since 8.6.0}
 */

public class InstabugDBVersions {

    /**
     * Added {@link UserInteractions} for surveys interactions archiving
     *
     * @since 8.4.0
     */
    // Introducing User Interaction Archiving starting from SDK version 8.4.0
    static final int DATABASE_VERSION_12 = 12;
    /**
     * Added {@link UserAttributesEntry} for user attributes archiving
     *
     * @since 8.5.0
     */
    static final int DATABASE_VERSION_14 = 14;
    /**
     * Altered {@link UserAttributesEntry}
     */
    static final int DATABASE_VERSION_15 = 15;
    /**
     * - Altered Announcement table to add new field of [shownAt] used in frequency calculations
     * - Added database migration support
     */
    static final int DATABASE_VERSION_16 = 16;

    static final int DATABASE_VERSION_17 = 17;
    /**
     * - Altered Sessions table to add new field "sync_status" used sessions batching
     * - Deprecated DATABASE_VERSION_16 migration method
     * - Added {@link MigrationEngine}
     */
    static final int DATABASE_VERSION_18 = 18;

    /**
     * Altered Crashes table to add new field "retry_count" used for Crashes buffering
     */

    static final int DATABASE_VERSION_19 = 19;
    /**
     * Add APM tables
     * Altered {@link InstabugDbContract.SessionEntry#COLUMN_ID} type from integer to string
     */
    static final int DATABASE_VERSION_20 = 20;

    /**
     * No DB Real changes, it is only to clean all attachment files, crash & bugs db records to fix an issue
     * Ticket: https://instabug.atlassian.net/browse/INSD-4634
     */
    static final int DATABASE_VERSION_21 = 21;
    /**
     * Add ANR table
     */
    static final int DATABASE_VERSION_22 = 22;
    /**
     * Alter survey table to add a new flag to define if it is an In-App native (GooglePlay) app rating type.
     */
    static final int DATABASE_VERSION_23 = 23;
    /**
     * Add experiments table
     */
    static final int DATABASE_VERSION_24 = 24;

    /**
     * Add long_message column in ANR table for tracking
     * Sdd production usage to core sessions table
     */
    static final int DATABASE_VERSION_25 = 25;

    /**
     * Add ndk_crashes_table
     */
    static final int DATABASE_VERSION_26 = 26;

    /**
     * Add threads_details column to crashes table
     */
    static final int DATABASE_VERSION_27 = 27;

    /**
     * Add apm_network_trace_attributes table
     */
    static final int DATABASE_VERSION_28 = 28;

    /**
     * Add isDismissible column to surveys table
     */
    static final int DATABASE_VERSION_29 = 29;

    /**
     * fake version update to manually drop crashes/NDK crashes/bugs/ANRs
     * and all related files
     */
    static final int DATABASE_VERSION_30 = 30;

    /**
     * Add stitched_session_lead column to session table
     * & add UiLoading metrics
     * & APM NetworkLogs GraphQL columns
     */
    static final int DATABASE_VERSION_31 = 31;

    /**
     * Fake version update to add production_usage column to sessions table
     */
    static final int DATABASE_VERSION_32 = 32;

    /**
     * APM network log GRPC
     */
    static final int DATABASE_VERSION_33 = 33;

    /**
     * Drop bugs table if exists
     */
    static final int DATABASE_VERSION_34 = 34;

    /**
     * Drop sdk analytics tables if exists
     * APM Experiments
     */
    static final int DATABASE_VERSION_35 = 35;

    /**
     * Adds fingerprint to crashes table
     */
    static final int DATABASE_VERSION_36 = 36;

    /**
     * Adds level column to crashes table
     */
    static final int DATABASE_VERSION_37 = 37;

    /**
     * Adds core session version to apm session
     * Adds UUID field to ANRs, crashes and ndk crashes tables
     */
    static final int DATABASE_VERSION_38 = 38;

    /**
     * Adds apm_fragment and apm_fragment_events tables
     * Adds fragments_count and fragments_dropped_count columns to apm session metadata table
     */
    static final int DATABASE_VERSION_39 = 39;

    /**
     * Adds apm_fragment and apm_fragment_events tables
     * Adds fragments_count and fragments_dropped_count columns to apm session metadata table
     */
    static final int DATABASE_VERSION_40 = 40;

    /**
     * Adds user_modified flag to apm network logs and dangling apm network logs
     */
    static final int DATABASE_VERSION_41 = 41;

    /**
     * Adds network_latency_spans field to apm network logs and dangling apm network logs
     */
    static final int DATABASE_VERSION_42 = 42;

    /**
     * Adds compose spans in APM
     */
    static final int DATABASE_VERSION_43 = 43;

    /**
     * Adds external_trace_id field to live and dangling APM Network Log tables
     * Adds external_trace_start_time field to live and dangling APM Network Log tables
     */
    static final int DATABASE_VERSION_44 = 44;
    /**
     * Adds session_id field to surveys table
     */
    static final int DATABASE_VERSION_45 = 45;

    /**
     * Drop network & IBG logs
     */
    static final int DATABASE_VERSION_46 = 46;

    /**
     * Adds apm_web_view_trace table
     * Adds WebView trace field to apm_session_meta_data table
     */
    static final int DATABASE_VERSION_47 = 47;

    /**
     * adds session v2 sent to session_table
     */
    static final int DATABASE_VERSION_48 = 48;
    /**
     * adds anr version and is early anr to anr_table
     */
    static final int DATABASE_VERSION_49 = 49;

    /**
     * Adds APM app flows
     */
    static final int DATABASE_VERSION_50 = 50;
    /**
     * Adds APM's Network logs W3C external trace id columns
     */
    static final int DATABASE_VERSION_51 = 51;

    /**
     * Adds app_launch_id column to apm_fragment_spans
     */
    static final int DATABASE_VERSION_52 = 52;

    /**
     * TODO bump up the database version with any schema changes
     * TODO add new constant for every database version
     * TODO add data migration to {@link MigrationEngine#onUpgrade(SQLiteDatabase, int, int)}
     */
    static final int CURRENT_VERSION = DATABASE_VERSION_52;
}
