package com.instabug.library.internal.sharedpreferences

import android.content.SharedPreferences
import com.instabug.library.Instabug
import com.instabug.library.internal.servicelocator.CoreServiceLocator
import com.instabug.library.percentagefeatures.PercentageFeature
import com.instabug.library.percentagefeatures.PercentageFeatureReadWriteStrategy
import com.instabug.library.util.nullRetryLazy
import kotlin.properties.ReadWriteProperty

const val IBG_CORE_PREF_FILE = "instabug"

val corePreferences by nullRetryLazy {
    Instabug.getApplicationContext()?.let { ctx ->
        CoreServiceLocator.getInstabugSharedPreferences(ctx, IBG_CORE_PREF_FILE)
    }
}

fun <T> corePref(key: String, defaultValue: T): ReadWriteProperty<Any?, T> =
    object : PreferencesProperty<T>(key, defaultValue) {
        override val pref: SharedPreferences?
            get() = corePreferences
    }

fun <T> corePref(keyValue: Pair<String, T>) = corePref(keyValue.first, keyValue.second)

private fun <T> coreReadWriteStrategyPreferencesProperty(
    key: String,
    defaultValue: T,
    strategy: ReadWriteStrategyPreferenceProperty.ReadWriteStrategy<T> = DefaultReadWriteStrategy()
): PreferencesProperty<T> =
    object : ReadWriteStrategyPreferenceProperty<T>(key, defaultValue, strategy) {
        override val pref: SharedPreferences?
            get() = corePreferences
    }

fun corePrefFactory(): PreferencePropertyFactory =
    object : PreferencePropertyFactory {
        override fun <T> create(key: String, defaultValue: T): PreferencesProperty<T> =
            when (defaultValue) {
                is PercentageFeature? ->
                    coreReadWriteStrategyPreferencesProperty(
                        key,
                        defaultValue,
                        PercentageFeatureReadWriteStrategy()
                    ) as PreferencesProperty<T>

                else -> coreReadWriteStrategyPreferencesProperty(key, defaultValue)
            }
    }