package com.instabug.library.featuresflags.model

import com.instabug.library.Constants
import com.instabug.library.featuresflags.constants.Constants.KEY
import com.instabug.library.featuresflags.constants.Constants.VALUE
import org.json.JSONException
import org.json.JSONObject
import java.io.Serializable

data class IBGFeatureFlag(val key:String, val value :String? = null) : Serializable{

    companion object {
        @JvmStatic
        @Throws(JSONException::class)
        fun fromJson(jsonObject: JSONObject): IBGFeatureFlag {
            val key = jsonObject.getString(KEY)
            val value = jsonObject.optString(VALUE, null)
            return IBGFeatureFlag(key, value)
        }
    }
}


