package com.instabug.library.encryption.iv

import android.os.Build
import androidx.annotation.VisibleForTesting

object IVManager {

    @VisibleForTesting
    lateinit var iv: ByteArray

    @JvmStatic
    fun getIV(): ByteArray {
        if (!this::iv.isInitialized) {
            iv = if (Build.VERSION.SDK_INT < Build.VERSION_CODES.JELLY_BEAN_MR2) {
                StaticIVProvider.getStaticIV()
            } else {
                Post18IVGenerator.getIV()
                    ?: StaticIVProvider.getStaticIV()
            }
        }

        return iv
    }
}