package com.instabug.library.encryption

import com.instabug.library.core.InstabugCore

object FilesMigrationEngine {

    @JvmStatic
    fun runMigration() {
        when(InstabugCore.getEncryptorVersion()) {
            EncryptorVersions.ENCRYPTOR_V1 -> {
                MigrationV1_V2.run()
            }

        }
    }
}

object EncryptorVersions {

    //Encrypt first 256 bytes only of file
    const val ENCRYPTOR_V1 = 1

    //Used dynamic key, changed AES mode, encrypted last 256 bytes of files
    const val ENCRYPTOR_V2 = 2
}