package com.instabug.library.diagnostics.sdkEvents.mappers

import com.instabug.library.diagnostics.sdkEvents.models.SDKEvent
import org.json.JSONArray
import org.json.JSONObject

private const val EVENT_KEY_KEY: String = "key"
private const val EVENT_COUNT_KEY: String = "count"

internal fun sdkEventsToJsonArray(events: List<SDKEvent>) = JSONArray().apply {
    events.forEach {
        val eventObject = eventToJsonObject(it)
        put(eventObject)
    }
}

private fun eventToJsonObject(event: SDKEvent) = JSONObject().apply {
    put(EVENT_KEY_KEY, event.key)
    put(EVENT_COUNT_KEY, event.count)
}

internal fun sdkEventsFromJsonArray(eventsArray: JSONArray?) = mutableListOf<SDKEvent>().apply {
    eventsArray?.let {
        for (i in 0 until it.length()) eventFromJson(it.getJSONObject(i))?.let(::add)
    }
}

private fun eventFromJson(eventJsonObject: JSONObject?): SDKEvent? = eventJsonObject?.run {
    SDKEvent(optString(EVENT_KEY_KEY, ""), optInt(EVENT_COUNT_KEY, 0))
}?.takeIf { it.key.isNotBlank() && it.count > 0 }