package com.instabug.library.diagnostics.sdkEvents.cache

import com.instabug.library.Constants
import com.instabug.library.diagnostics.sdkEvents.SDKEventsValidator
import com.instabug.library.diagnostics.sdkEvents.models.SDKEvent
import com.instabug.library.util.InstabugSDKLogger

internal class SDKEventsCachingManagerImpl(
    private val dbHelper: SDKEventsDbHelper,
    private val validator: SDKEventsValidator
) : SDKEventsCachingManager {

    override fun saveEvent(event: SDKEvent) =
        if (validator.run { isValidEvent(event) && isValidEventKey(event.key) }) {
            dbHelper.insertOrUpdateEvent(event)
        } else InstabugSDKLogger.d(Constants.LOG_TAG, "Event: $event is invalid")

    override fun getAllEvents(): List<SDKEvent>? = dbHelper.queryAllEvents()

    override fun deleteManyEvents(keys: Collection<String>?) = dbHelper.deleteManyEvents(keys)

    override fun clearCache() = dbHelper.deleteAllEvents()

    override fun updateSyncedRecords(sdkEvents: List<SDKEvent>) {
        sdkEvents
            .takeIf { it.all { event -> validator.isValidEventKey(event.key) } }
            ?.also(dbHelper::updateSyncedRecords)
    }

    override fun deleteZeroCountedEvents() = dbHelper.deleteZeroCountedEvents()
}