package com.instabug.library.diagnostics

object DiagnosticsConstants {

    const val NON_FATALS = "non_fatalsv3"
    const val CUSTOM_TRACES = "custom_traces"
    const val RECORD_LAUNCH_TRACE = "record_sdk_launch_trace"
    const val RECORD_FEATURE_TRACE = "record_sdk_feature_trace"
    const val DIAGNOSTICS = "diagnostics"

    const val ENABLED = "enabled"
    const val SYNC_INTERVAL = "sync_interval"
    const val MAX_COUNT = "max_count"

    const val TRACE_NAME_LENGTH = 150
    const val TRACE_ATTRIBUTES_SIZE = 5
    const val TRACE_ATTRIBUTES_KEY_LENGTH = 30
    const val TRACE_ATTRIBUTES_VALUE_LENGTH = 60

    //Launch traces
    const val BUILDER_MAIN = "builder-main"
    const val BUILDER_BG = "builder-bg"

    //FEATURE_TRACES
    const val CORE_PROVIDER = "core-cp-init"
    const val CRASH_PROVIDER = "cr-cp-init"
    const val APM_PROVIDER = "apm-cp-init"

    val LAUNCH_TRACES = arrayOf(BUILDER_MAIN, BUILDER_BG)
    val FEATURE_TRACES = arrayOf(CORE_PROVIDER, CRASH_PROVIDER, APM_PROVIDER)
}