package com.instabug.library.core.plugin;

import java.util.ArrayList;

import androidx.annotation.Nullable;

import com.instabug.library.Constants;
import com.instabug.library.util.InstabugSDKLogger;


/**
 * A class to manage the prompt options
 * DEPENDENCIES
 * ************
 * 1- {@link PluginsManager#getPluginsPromptOptions()} to provide the available plugins
 * to retrieve the requested option given its {@link com.instabug.library.core.plugin.PluginPromptOption.PromptOptionIdentifier}
 */
public class PromptOptionManager {

    /**
     * A method to get the prompt option given its identifier
     *
     * @param identifier unique identifier for each prompt option {@link PluginPromptOption.PromptOptionIdentifier}
     * @param ignoreBaseFeatureAvailbility
     * @return the plugin prompt option if found.
     */
    @Nullable
    public static PluginPromptOption getPluginByIdentifier(@PluginPromptOption.PromptOptionIdentifier int
                                                                       identifier, boolean ignoreBaseFeatureAvailbility) {
        InstabugSDKLogger.d(Constants.LOG_TAG, "[PromptOptionManager#getPluginByIdentifier] Getting a plugin by identifier: " + identifier);
        ArrayList<PluginPromptOption> pluginsPromptOptions = PluginsManager
                .getPluginOptions(ignoreBaseFeatureAvailbility);
        for (PluginPromptOption pluginsPromptOption : pluginsPromptOptions) {
            if (pluginsPromptOption.getPromptOptionIdentifier() == identifier) {
                InstabugSDKLogger.d(Constants.LOG_TAG, "[PromptOptionManager#getPluginByIdentifier] Found a matching option");
                return pluginsPromptOption;
            }
        }
        InstabugSDKLogger.d(Constants.LOG_TAG, "[PromptOptionManager#getPluginByIdentifier] No matching options, returning null");
        return null;
    }


}
