/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.model.session;

import android.annotation.SuppressLint;
import android.content.ContentValues;
import android.database.Cursor;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.library.d;
import com.instabug.library.internal.utils.stability.handler.exception.ExceptionHandler;
import com.instabug.library.model.session.CoreSession;
import com.instabug.library.model.session.SessionLocalEntity;
import com.instabug.library.model.session.SessionRemoteEntity;
import com.instabug.library.model.session.SessionsBatchDTO;
import com.instabug.library.networkv2.request.Request;
import com.instabug.library.networkv2.request.RequestParameter;
import com.instabug.library.util.InstabugSDKLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Keep
public class SessionMapper {
    private static final Object TAG = "SessionMapper";

    private SessionMapper() {
    }

    @NonNull
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public static SessionRemoteEntity toRemoteEntity(@NonNull CoreSession session) {
        CoreSession coreSession;
        HashMap<String, Object> hashMap;
        HashMap<String, Object> hashMap2 = hashMap;
        hashMap2();
        hashMap2.put("os", coreSession.getOs());
        hashMap2.put("device", coreSession.getDevice());
        hashMap2.put("duration", coreSession.getDuration());
        hashMap2.put("started_at", coreSession.getStartTimestampMicros());
        hashMap2.put("name", coreSession.getUserName());
        hashMap2.put("email", coreSession.getUserEmail());
        hashMap2.put("sdk_version", coreSession.getSdkVersion());
        hashMap.put("app_version", coreSession.getAppVersion());
        String string2 = session.isUsersPageEnabled() ? "user_events" : "user_event_keys";
        hashMap2.put(string2, coreSession.getUserEvents());
        string2 = coreSession.isUsersPageEnabled() ? "custom_attributes" : "custom_attribute_keys";
        hashMap2.put(string2, coreSession.getCustomAttributes());
        hashMap2.put("crash_reporting_enabled", coreSession.isCrashReportingEnabled());
        hashMap2.put("uuid", coreSession.getUuid());
        hashMap2.put("application_token", coreSession.getAppToken());
        hashMap2.put("stitched_session_lead", coreSession.isStitchedSessionLead());
        return SessionMapper.toRemoteEntity(coreSession.getId(), hashMap2);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static SessionRemoteEntity toRemoteEntity(String id2, @NonNull Map<String, Object> map) {
        void var1_1;
        String string2;
        return new SessionRemoteEntity(string2, (Map<String, Object>)var1_1);
    }

    @NonNull
    public static SessionsBatchDTO toDTO(@NonNull SessionRemoteEntity session) {
        SessionRemoteEntity sessionRemoteEntity;
        return SessionMapper.toDTO(Collections.emptyMap(), Collections.singletonList(sessionRemoteEntity));
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static SessionsBatchDTO toDTO(@NonNull Map<String, Object> commonKeys, @NonNull List<SessionRemoteEntity> sessions) {
        void var1_1;
        Map<String, Object> map;
        return new SessionsBatchDTO(map, (List<SessionRemoteEntity>)var1_1);
    }

    @NonNull
    public static CoreSession toModel(@NonNull SessionLocalEntity entity) {
        SessionLocalEntity sessionLocalEntity;
        SessionLocalEntity sessionLocalEntity2 = sessionLocalEntity;
        Object object = sessionLocalEntity2.getId();
        String string2 = sessionLocalEntity2.getUuid();
        String string3 = sessionLocalEntity2.getOs();
        object = new CoreSession.Builder((String)object, string2, string3).setDevice(sessionLocalEntity.getDevice()).setDuration(sessionLocalEntity.getDuration()).setStartTimestampMicros(sessionLocalEntity.getStartTimestampMicros()).setUserName(sessionLocalEntity.getUserName()).setUserEmail(sessionLocalEntity.getUserEmail()).setSdkVersion(sessionLocalEntity.getSdkVersion()).setAppVersion(sessionLocalEntity.getAppVersion());
        string2 = entity.isUsersPageEnabled() ? sessionLocalEntity.getUserEvents() : sessionLocalEntity.getUserEventsKeys();
        object = ((CoreSession.Builder)object).setUserEvents(string2);
        string2 = sessionLocalEntity.isUsersPageEnabled() ? sessionLocalEntity.getCustomAttributes() : sessionLocalEntity.getCustomAttributesKeys();
        return ((CoreSession.Builder)object).setCustomAttributes(string2).setCrashReportingEnabled(sessionLocalEntity.isCrashReportingEnabled()).setSyncStatus(sessionLocalEntity.getSyncStatus()).setAppToken(sessionLocalEntity.getAppToken()).setUsersPageEnabled(sessionLocalEntity.isUsersPageEnabled()).setProductionUsage(sessionLocalEntity.getProductionUsage()).setIsStitchedSessionLead(sessionLocalEntity.isStitchedSessionLead()).build();
    }

    @NonNull
    public static List<CoreSession> toModels(@NonNull List<SessionLocalEntity> entities) {
        ArrayList<CoreSession> arrayList;
        ArrayList<CoreSession> arrayList2 = arrayList;
        arrayList = new ArrayList<CoreSession>();
        Iterator<SessionLocalEntity> iterator = entities.iterator();
        while (iterator.hasNext()) {
            arrayList2.add(SessionMapper.toModel(iterator.next()));
        }
        return arrayList2;
    }

    @NonNull
    public static ContentValues toContentValues(SessionLocalEntity entity) {
        String string2;
        ContentValues contentValues;
        ContentValues contentValues2;
        ContentValues contentValues3 = contentValues2 = contentValues;
        contentValues2();
        contentValues2.put("session_id", ((SessionLocalEntity)((Object)string2)).getId());
        contentValues2.put("started_at", Long.valueOf(((SessionLocalEntity)((Object)string2)).getStartTimestampMicros()));
        contentValues2.put("duration", Long.valueOf(((SessionLocalEntity)((Object)string2)).getDuration()));
        contentValues2.put("user_attributes", ((SessionLocalEntity)((Object)string2)).getUserEvents());
        contentValues2.put("user_events", ((SessionLocalEntity)((Object)string2)).getCustomAttributes());
        contentValues2.put("user_attributes_keys", ((SessionLocalEntity)((Object)string2)).getUserEventsKeys());
        contentValues2.put("user_events_keys", ((SessionLocalEntity)((Object)string2)).getCustomAttributesKeys());
        contentValues2.put("user_email", ((SessionLocalEntity)((Object)string2)).getUserEmail());
        contentValues2.put("user_name", ((SessionLocalEntity)((Object)string2)).getUserName());
        contentValues2.put("uuid", ((SessionLocalEntity)((Object)string2)).getUuid());
        contentValues2.put("app_token", ((SessionLocalEntity)((Object)string2)).getAppToken());
        contentValues2.put("os", ((SessionLocalEntity)((Object)string2)).getOs());
        contentValues2.put("device", ((SessionLocalEntity)((Object)string2)).getDevice());
        contentValues2.put("sdk_version", ((SessionLocalEntity)((Object)string2)).getSdkVersion());
        contentValues3.put("app_version", ((SessionLocalEntity)((Object)string2)).getAppVersion());
        contentValues3.put("crash_reporting_enabled", Integer.valueOf(((SessionLocalEntity)((Object)string2)).isCrashReportingEnabled() ? 1 : 0));
        contentValues3.put("users_page_enabled", Integer.valueOf(((SessionLocalEntity)((Object)string2)).isUsersPageEnabled() ? 1 : 0));
        contentValues.put("sync_status", Integer.valueOf(((SessionLocalEntity)((Object)string2)).getSyncStatus()));
        contentValues.put("stitched_session_lead", Integer.valueOf(((SessionLocalEntity)((Object)string2)).isStitchedSessionLead() ? 1 : 0));
        contentValues.put("v2_session_sent", Integer.valueOf(((SessionLocalEntity)((Object)string2)).isSessionV2Sent() ? 1 : 0));
        string2 = entity.getProductionUsage();
        if (string2 != null) {
            contentValues2.put("production_usage", string2);
        }
        return contentValues2;
    }

    @NonNull
    @SuppressLint(value={"ERADICATE_RETURN_NOT_NULLABLE"})
    public static JSONObject toJson(@NonNull SessionRemoteEntity entity) {
        SessionRemoteEntity sessionRemoteEntity;
        return new ExceptionHandler().withPenaltyLog().executeAndGet(() -> {
            JSONObject jSONObject;
            SessionRemoteEntity sessionRemoteEntity = jSONObject;
            jSONObject = new JSONObject();
            for (Map.Entry<String, Object> entry : sessionRemoteEntity.getMap().entrySet()) {
                if (!d.c().h() && entry.getKey() != null && entry.getKey().equals("stitched_session_lead")) continue;
                sessionRemoteEntity.put(entry.getKey(), SessionMapper.extractJsonValue(entry.getValue()));
            }
            return sessionRemoteEntity;
        }, new JSONObject());
    }

    @NonNull
    @SuppressLint(value={"ERADICATE_RETURN_NOT_NULLABLE"})
    public static JSONObject toJson(@NonNull SessionsBatchDTO batch) {
        SessionsBatchDTO sessionsBatchDTO;
        return new ExceptionHandler().withPenaltyLog().executeAndGet(() -> {
            JSONArray jSONArray;
            SessionsBatchDTO sessionsBatchDTO;
            JSONObject jSONObject;
            JSONObject jSONObject2 = jSONObject;
            jSONObject = new JSONObject();
            Object object = sessionsBatchDTO.getProductionUsage();
            if (object != null && !((String)object).isEmpty()) {
                JSONObject jSONObject3;
                JSONObject jSONObject4 = jSONObject2;
                String object2 = "production_usage";
                JSONObject jSONObject5 = jSONObject3;
                try {
                    jSONObject3 = new JSONObject((String)object);
                    jSONObject4.put(object2, (Object)jSONObject5);
                }
                catch (JSONException jSONException) {
                    InstabugSDKLogger.e("IBG-Core", ((Object)((Object)jSONException)).getClass().getSimpleName(), jSONException);
                }
            }
            for (Map.Entry entry : sessionsBatchDTO.getCommonKeys().entrySet()) {
                jSONObject2.put((String)entry.getKey(), SessionMapper.extractJsonValue(entry.getValue()));
            }
            SessionsBatchDTO sessionsBatchDTO2 = sessionsBatchDTO;
            sessionsBatchDTO = jSONArray;
            jSONArray = new JSONArray();
            object = sessionsBatchDTO2.getSessions().iterator();
            while (object.hasNext()) {
                sessionsBatchDTO.put(SessionMapper.toJson(object.next()));
            }
            JSONObject jSONObject6 = jSONObject2;
            jSONObject6.put("sessions", (Object)sessionsBatchDTO);
            return jSONObject6;
        }, new JSONObject());
    }

    @NonNull
    @SuppressLint(value={"ERADICATE_RETURN_NOT_NULLABLE"})
    public static Request toRequest(@NonNull JSONObject batch) {
        Object object;
        Request.Builder builder = new Request.Builder().endpoint("/sessions/v2").method("POST");
        object = () -> SessionMapper.lambda$toRequest$2((JSONObject)object, builder);
        return new ExceptionHandler().withPenaltyLog().executeAndGet(object, builder.build());
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static SessionLocalEntity toLocalEntity(@NonNull Cursor cursor) {
        void var21_29;
        void var20_25;
        void var18_20;
        SessionLocalEntity sessionLocalEntity;
        Cursor cursor2;
        Cursor cursor3 = cursor;
        String string2 = cursor3.getString(cursor3.getColumnIndexOrThrow("session_id"));
        long l5 = cursor3.getLong(cursor3.getColumnIndexOrThrow("started_at"));
        long l6 = cursor3.getLong(cursor3.getColumnIndexOrThrow("duration"));
        String string3 = cursor3.getString(cursor3.getColumnIndexOrThrow("user_attributes"));
        String string4 = cursor3.getString(cursor3.getColumnIndexOrThrow("user_events"));
        String string5 = cursor3.getString(cursor3.getColumnIndexOrThrow("user_attributes_keys"));
        String string6 = cursor3.getString(cursor3.getColumnIndexOrThrow("user_events_keys"));
        String string7 = cursor3.getString(cursor3.getColumnIndexOrThrow("user_email"));
        String string8 = cursor3.getString(cursor3.getColumnIndexOrThrow("user_name"));
        String string9 = cursor3.getString(cursor3.getColumnIndexOrThrow("uuid"));
        String string10 = cursor3.getString(cursor3.getColumnIndexOrThrow("app_token"));
        String string11 = cursor3.getString(cursor3.getColumnIndexOrThrow("os"));
        String string12 = cursor3.getString(cursor3.getColumnIndexOrThrow("device"));
        String string13 = cursor3.getString(cursor3.getColumnIndexOrThrow("sdk_version"));
        String string14 = cursor3.getString(cursor3.getColumnIndexOrThrow("app_version"));
        Cursor cursor4 = cursor2;
        int n5 = cursor4.getInt(cursor4.getColumnIndexOrThrow("sync_status"));
        int bl = cursor4.getInt(cursor4.getColumnIndexOrThrow("users_page_enabled"));
        String string15 = cursor4.getString(cursor4.getColumnIndexOrThrow("production_usage"));
        int n6 = cursor4.getInt(cursor4.getColumnIndexOrThrow("stitched_session_lead"));
        int n7 = cursor4.getInt(cursor4.getColumnIndexOrThrow("v2_session_sent"));
        boolean bl2 = cursor3.getInt(cursor3.getColumnIndexOrThrow("crash_reporting_enabled")) == 1;
        if (bl == 1) {
            boolean bl3 = true;
        } else {
            boolean bl4 = false;
        }
        if (n6 == 1) {
            boolean bl5 = true;
        } else {
            boolean bl6 = false;
        }
        if (n7 == 1) {
            boolean bl7 = true;
        } else {
            boolean bl8 = false;
        }
        SessionLocalEntity sessionLocalEntity2 = sessionLocalEntity;
        sessionLocalEntity2(string2, string11, string12, l6, l5, string8, string7, string13, string14, string3, string4, string5, string6, bl2, n5, string9, string10, (boolean)var18_20, string15, (boolean)var20_25, (boolean)var21_29);
        return sessionLocalEntity2;
    }

    @NonNull
    public static List<String> toIDs(@NonNull SessionsBatchDTO batch) {
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        Iterator<SessionRemoteEntity> iterator = batch.getSessions().iterator();
        while (iterator.hasNext()) {
            arrayList2.add(iterator.next().getId());
        }
        return arrayList2;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static CoreSession toSession(@NonNull String id2, @NonNull String os, @NonNull String uuid, @Nullable String appVersion, long startTimestampMicros, long startNanoTime, boolean isStitchedSessionLead) {
        void var8_6;
        void var6_5;
        void var4_4;
        void var3_3;
        void var1_1;
        void var2_2;
        String string2;
        return new CoreSession.Builder(string2, (String)var2_2, (String)var1_1).setAppVersion((String)var3_3).setStartTimestampMicros((long)var4_4).setStartNanoTime((long)var6_5).setIsStitchedSessionLead((boolean)var8_6).build();
    }

    private static Object extractJsonValue(Object value) {
        Object object;
        if (value != null && (object.toString().contains("{") || object.toString().contains("["))) {
            try {
                return new JSONObject(object.toString());
            }
            catch (JSONException jSONException) {
                try {
                    return new JSONArray(object.toString());
                }
                catch (JSONException jSONException2) {}
            }
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ Request lambda$toRequest$2(JSONObject batch, Request.Builder requestBuilder) throws Exception {
        void var1_1;
        Iterator iterator = batch.keys();
        while (iterator.hasNext()) {
            JSONObject jSONObject;
            String string2 = (String)iterator.next();
            var1_1.addParameter(new RequestParameter<Object>(string2, jSONObject.get(string2)));
        }
        return var1_1.build();
    }
}

