/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.widget.TextView;
import com.instabug.library.util.DrawingUtility;

public class BubbleTextView
extends TextView {
    private static final float ARROW_LENGTH_DP = 7.0f;
    private RectF rectF;
    private Paint paint;
    private float arrowLengthPx;
    private PointF arrowSidePoint;
    private PointF arrowTopPoint;
    private PointF arrowBottomPoint;
    private Path arrowPath;
    private float cornerRadius;

    /*
     * WARNING - void declaration
     */
    public BubbleTextView(Context context) {
        void var1_1;
        BubbleTextView bubbleTextView = this;
        super((Context)var1_1);
        bubbleTextView.init();
    }

    /*
     * WARNING - void declaration
     */
    public BubbleTextView(Context context, AttributeSet attrs) {
        void var2_2;
        void var1_1;
        BubbleTextView bubbleTextView = this;
        super((Context)var1_1, (AttributeSet)var2_2);
        bubbleTextView.init();
    }

    /*
     * WARNING - void declaration
     */
    public BubbleTextView(Context context, AttributeSet attrs, int defStyle) {
        void var3_3;
        void var2_2;
        void var1_1;
        BubbleTextView bubbleTextView = this;
        super((Context)var1_1, (AttributeSet)var2_2, (int)var3_3);
        bubbleTextView.init();
    }

    private void init() {
        float f5;
        BubbleTextView bubbleTextView = this;
        bubbleTextView.setTextColor(-1);
        bubbleTextView.rectF = new RectF();
        this.paint = new Paint(1);
        this.paint.setColor(-12303292);
        bubbleTextView.paint.setStyle(Paint.Style.FILL);
        DisplayMetrics displayMetrics = bubbleTextView.getContext().getResources().getDisplayMetrics();
        this.arrowLengthPx = f5 = TypedValue.applyDimension((int)1, (float)7.0f, (DisplayMetrics)displayMetrics);
        this.cornerRadius = f5 / 2.0f;
        int n5 = (int)f5;
        bubbleTextView.setPadding((int)((double)f5 * 1.5), n5, (int)((double)f5 * 1.5 + (double)f5), n5);
        bubbleTextView.arrowSidePoint = new PointF();
        bubbleTextView.arrowTopPoint = new PointF();
        bubbleTextView.arrowBottomPoint = new PointF();
        bubbleTextView.arrowPath = new Path();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int n5;
        int n6;
        BubbleTextView bubbleTextView = this;
        super.onMeasure(n6, n5);
        n6 = bubbleTextView.getMeasuredHeight();
        n5 = bubbleTextView.getMeasuredWidth();
        bubbleTextView.setMeasuredDimension(n5, n6);
        RectF rectF = bubbleTextView.rectF;
        float f5 = n5;
        rectF.right = f5 - this.arrowLengthPx;
        bubbleTextView.rectF.bottom = n6;
        PointF pointF = bubbleTextView.arrowSidePoint;
        pointF.x = f5;
        pointF.y = rectF.centerY();
        f5 = (float)((double)bubbleTextView.arrowLengthPx / Math.cos(45.0));
        BubbleTextView bubbleTextView2 = this;
        BubbleTextView bubbleTextView3 = this;
        PointF pointF2 = bubbleTextView3.arrowSidePoint;
        PointF pointF3 = bubbleTextView3.arrowTopPoint;
        DrawingUtility.pointOnCircle(f5, 225.0f, pointF2, pointF3);
        pointF2 = bubbleTextView2.arrowSidePoint;
        pointF3 = bubbleTextView2.arrowBottomPoint;
        DrawingUtility.pointOnCircle(f5, 135.0f, pointF2, pointF3);
        PointF pointF4 = this.arrowTopPoint;
        float f6 = pointF4.x;
        bubbleTextView.arrowPath.moveTo(f6, pointF4.y);
        PointF pointF5 = this.arrowSidePoint;
        f6 = pointF5.x;
        bubbleTextView.arrowPath.lineTo(f6, pointF5.y);
        PointF pointF6 = this.arrowBottomPoint;
        float f7 = pointF6.x;
        bubbleTextView.arrowPath.lineTo(f7, pointF6.y);
        bubbleTextView.arrowPath.close();
    }

    /*
     * WARNING - void declaration
     */
    protected void onDraw(Canvas canvas) {
        void var1_1;
        BubbleTextView bubbleTextView = this_;
        BubbleTextView bubbleTextView2 = this_;
        BubbleTextView bubbleTextView3 = this_;
        BubbleTextView this_ = bubbleTextView3.rectF;
        float f5 = bubbleTextView3.cornerRadius;
        Paint paint = bubbleTextView3.paint;
        float f6 = f5;
        var1_1.drawRoundRect((RectF)this_, f6, f6, paint);
        this_ = bubbleTextView2.arrowPath;
        var1_1.drawPath((Path)this_, bubbleTextView2.paint);
        super.onDraw((Canvas)var1_1);
    }
}

