/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.storage.cache;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Environment;
import androidx.annotation.Nullable;
import com.instabug.library.internal.storage.cache.Cache;
import com.instabug.library.internal.storage.cache.CacheManager;
import com.instabug.library.internal.storage.cache.InMemoryCache;
import com.instabug.library.internal.storage.cache.a;
import com.instabug.library.model.AssetEntity;
import com.instabug.library.networkv2.request.Request;
import com.instabug.library.util.FileUtils;
import com.instabug.library.util.InstabugSDKLogger;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@SuppressLint(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
public class AssetsCacheManager {
    private static final String ASSETS_MEMORY_CACHE_KEY = "assets_memory_cache";
    private static final Map<String, b> currentDownloadingFiles = new ConcurrentHashMap<String, b>();

    @Nullable
    public static a getCache() {
        if (!CacheManager.getInstance().cacheExists(ASSETS_MEMORY_CACHE_KEY)) {
            InstabugSDKLogger.v("IBG-Core", "In-memory assets cache not found, create it");
            CacheManager.getInstance().addCache(new a(ASSETS_MEMORY_CACHE_KEY));
            InstabugSDKLogger.v("IBG-Core", "In-memory assets created successfully");
        }
        InstabugSDKLogger.v("IBG-Core", "In-memory assets cache found");
        return (a)CacheManager.getInstance().getCache(ASSETS_MEMORY_CACHE_KEY);
    }

    /*
     * WARNING - void declaration
     */
    public static AssetEntity createEmptyEntity(Context context, String fileUrl, AssetEntity.AssetType assetType) {
        void var2_2;
        void var1_1;
        Context context2;
        File file;
        File file2 = file;
        file = new File(AssetsCacheManager.getCacheDirectory(context2), String.valueOf(var1_1.hashCode()));
        return new AssetEntity(String.valueOf(var1_1.hashCode()), (AssetEntity.AssetType)var2_2, (String)var1_1, file2);
    }

    /*
     * WARNING - void declaration
     */
    public static void getAssetEntity(AssetEntity assetEntity, OnDownloadFinished onDownloadFinished) {
        void var1_1;
        AssetEntity assetEntity2;
        Object object = AssetsCacheManager.getCache();
        object = object != null ? (AssetEntity)((InMemoryCache)object).get(assetEntity2.getKey()) : null;
        if (object != null && ((AssetEntity)object).getFile() != null && ((AssetEntity)object).getFile().exists()) {
            InstabugSDKLogger.v("IBG-Core", "Get file from cache");
            var1_1.onSuccess((AssetEntity)object);
        } else if (AssetsCacheManager.isDownloading(assetEntity2.getKey())) {
            InstabugSDKLogger.v("IBG-Core", "File currently downloading, wait download to finish");
            AssetsCacheManager.waitDownloadToFinish(assetEntity2, (OnDownloadFinished)var1_1);
        } else {
            InstabugSDKLogger.v("IBG-Core", "File not exist download it");
            AssetsCacheManager.downloadAssetEntity(assetEntity2, (OnDownloadFinished)var1_1);
        }
    }

    public static void downloadAssetEntity(AssetEntity assetEntity, OnDownloadFinished onDownloadFinished) {
        Object object;
        if (assetEntity != null && object != null) {
            Request.Callbacks callbacks;
            WeakReference<void> weakReference;
            AssetEntity assetEntity2;
            b b5;
            b b6 = b5;
            new b().a(assetEntity2);
            List list = b6.b();
            WeakReference<void> weakReference2 = weakReference;
            weakReference = new WeakReference<void>((void)object);
            list.add(weakReference2);
            b6.a(list);
            object = b6.a();
            if (object != null) {
                currentDownloadingFiles.put(((AssetEntity)object).getKey(), b6);
            }
            object = callbacks;
            callbacks = new Request.Callbacks(){

                /*
                 * WARNING - void declaration
                 */
                public void a(AssetEntity responseAssetEntity) {
                    if (responseAssetEntity != null) {
                        void var1_1;
                        void v02 = var1_1;
                        AssetsCacheManager.addAssetEntity((AssetEntity)v02);
                        AssetsCacheManager.notifyDownloadFinishedSuccessfully((AssetEntity)v02);
                    }
                }

                /*
                 * WARNING - void declaration
                 */
                public void a(Throwable error) {
                    void var1_1;
                    InstabugSDKLogger.e("IBG-Core", "downloading asset entity got error: ", (Throwable)var1_1);
                    AssetsCacheManager.notifyDownloadFailed(assetEntity2, (Throwable)var1_1);
                }
            };
            com.instabug.library.networkv2.service.b.a().a(assetEntity2, (Request.Callbacks)object);
        }
    }

    public static void addAssetEntity(@Nullable AssetEntity assetEntity) {
        AssetEntity assetEntity2;
        a a5 = AssetsCacheManager.getCache();
        if (a5 != null && assetEntity2 != null) {
            a5.put(assetEntity2.getKey(), assetEntity2);
        }
    }

    public static boolean isDownloading(String key) {
        String string2;
        return currentDownloadingFiles.get(string2) != null;
    }

    /*
     * WARNING - void declaration
     */
    public static void waitDownloadToFinish(AssetEntity assetEntity, OnDownloadFinished onDownloadFinished) {
        Object object;
        if ((object = currentDownloadingFiles.get(((AssetEntity)object).getKey())) != null) {
            void var1_1;
            WeakReference<void> weakReference;
            Object object2 = object;
            object = ((b)object2).b();
            WeakReference<void> weakReference2 = weakReference;
            weakReference = new WeakReference<void>(var1_1);
            object.add(weakReference2);
            ((b)object2).a((List)object);
        }
    }

    public static void notifyDownloadFinishedSuccessfully(@Nullable AssetEntity assetEntity) {
        AssetEntity assetEntity2;
        Object object;
        if (assetEntity != null && (object = currentDownloadingFiles.get(assetEntity2.getKey())) != null) {
            for (Object object2 : ((b)object).b()) {
                if (object2 == null || (object2 = (OnDownloadFinished)((Reference)object2).get()) == null) continue;
                object2.onSuccess(assetEntity2);
                currentDownloadingFiles.remove(assetEntity2.getKey());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void notifyDownloadFailed(AssetEntity assetEntity, Throwable error) {
        AssetEntity assetEntity2;
        b b5 = currentDownloadingFiles.get(assetEntity2.getKey());
        if (b5 != null) {
            for (Object object : b5.b()) {
                void var1_1;
                if (object == null || (object = (OnDownloadFinished)((Reference)object).get()) == null) continue;
                object.onFailed((Throwable)var1_1);
                currentDownloadingFiles.remove(assetEntity2.getKey());
            }
        }
    }

    public static void clearRedundantFiles(Context context) {
        File[] fileArray;
        block5: {
            fileArray = AssetsCacheManager.getCacheDirectory(context).listFiles();
            if (fileArray != null) break block5;
            return;
        }
        int n5 = fileArray.length;
        for (int i5 = 0; i5 < n5; ++i5) {
            try {
                fileArray[i5].delete();
            }
            catch (Exception exception) {
                InstabugSDKLogger.e("IBG-Core", "Error while cleaning up cache directory", exception);
                break;
            }
            continue;
        }
    }

    public static void cleanUpCache(Context context) {
        Context context2;
        Cache cache;
        if (CacheManager.getInstance().cacheExists(ASSETS_MEMORY_CACHE_KEY) && (cache = CacheManager.getInstance().getCache(ASSETS_MEMORY_CACHE_KEY)) != null) {
            cache.invalidate();
        }
        AssetsCacheManager.clearRedundantFiles(context2);
    }

    public static File getCacheDirectory(Context context) {
        File file;
        Object object;
        object = object.getCacheDir().getAbsolutePath() + "/instabug/assetCache";
        File file2 = file;
        if (!new File((String)object).exists()) {
            file2.mkdirs();
            try {
                new File(file2, ".nomedia").createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return file2;
    }

    public static void clearExternalCacheDir(Context context) {
        Object object;
        if (context != null && Environment.getExternalStorageState().equals("mounted") && object.getExternalCacheDir() != null) {
            File file;
            object = object.getExternalCacheDir().getPath() + "/instabug";
            File file2 = file;
            if (new File((String)object).exists()) {
                FileUtils.deleteDirectory(file2);
            }
        }
    }

    public static interface OnDownloadFinished {
        public void onSuccess(AssetEntity var1);

        public void onFailed(Throwable var1);
    }

    public static class b {
        public AssetEntity a;
        public List b;

        public b() {
            ArrayList arrayList;
            ArrayList this_ = arrayList;
            arrayList = new ArrayList();
            v1.b = this_;
        }

        /*
         * WARNING - void declaration
         */
        public b a(AssetEntity assetEntity) {
            void var1_1;
            this.a = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public b a(List waitingList) {
            void var1_1;
            this.b = var1_1;
            return this;
        }

        public AssetEntity a() {
            return this.a;
        }

        public List b() {
            return this.b;
        }
    }
}

