/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.contentprovider;

import android.app.Application;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.library.Feature;
import com.instabug.library.Instabug;
import com.instabug.library.diagnostics.customtraces.IBGPendingTraceHandler;
import com.instabug.library.internal.contentprovider.InstabugApplicationProvider;
import com.instabug.library.internal.stub.a;
import com.instabug.library.tracking.InstabugInternalTrackingDelegate;
import com.instabug.library.util.InstabugSDKLogger;

@Keep
public class InstabugContentProvider
extends a {
    private void initialize(Context context) throws PackageManager.NameNotFoundException {
        Context context2;
        IBGPendingTraceHandler.setCoreCPStartTime(System.currentTimeMillis());
        if (context == null) {
            return;
        }
        Application application = null;
        if (context2 instanceof Application) {
            application = (Application)context2;
        } else if ((context2 = context2.getApplicationContext()) instanceof Application) {
            application = (Application)context2;
        }
        this.initSDK(application);
        this.initTrackingDelegate(application);
        this.initApplicationProvider(application);
        IBGPendingTraceHandler.setCoreCPEndTime(System.currentTimeMillis());
    }

    /*
     * WARNING - void declaration
     */
    private void initSDK(@Nullable Application appContext) throws PackageManager.NameNotFoundException {
        if (appContext != null) {
            void var1_1;
            new Instabug.Builder((Application)var1_1, this.getInstabugToken((Application)var1_1)).build(Feature.State.DISABLED);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void initApplicationProvider(@Nullable Application applicationContext) {
        void var1_1;
        if (applicationContext == null) {
            return;
        }
        InstabugApplicationProvider.init((Application)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void initTrackingDelegate(@Nullable Application applicationContext) {
        void var1_1;
        if (applicationContext == null) {
            return;
        }
        InstabugInternalTrackingDelegate.init((Application)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void attachInfo(Context context, ProviderInfo info) {
        void var2_3;
        void var1_2;
        InstabugContentProvider instabugContentProvider = this;
        super.attachInfo((Context)var1_2, (ProviderInfo)var2_3);
        try {
            instabugContentProvider.initialize((Context)var1_2);
        }
        catch (Exception exception) {
            InstabugSDKLogger.e("IBG-CORE", "Error in content provider: " + exception.getMessage(), exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    String getInstabugToken(Application context) throws PackageManager.NameNotFoundException {
        void var1_1;
        if (context == null) {
            return "";
        }
        Object object = var1_1.getPackageManager().getApplicationInfo((String)var1_1.getPackageName(), (int)128).metaData;
        if (object != null) {
            if ((object = object.getString("com.instabug.APP_TOKEN")) == null) {
                object = "";
            }
            return object;
        }
        return "";
    }
}

