/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.storage.cache.dbv2;

import android.provider.BaseColumns;

public class IBGDbContract {
    public static final String TEXT_TYPE = " TEXT";
    public static final String INTEGER_TYPE = " INTEGER";
    public static final String BOOLEAN_TYPE = " BOOLEAN";
    public static final String COMMA_SEP = ",";
    public static final String DEFAULT = " DEFAULT ";
    private static final String CONSTRAINT = " CONSTRAINT ";
    private static final String FOREIGN_KEY = " FOREIGN KEY ";
    public static final String BLOB_TYPE = " BLOB";
    public static final String UNIQUE = " UNIQUE ";
    public static final String CREATE_TABLE_STATEMENT = "CREATE TABLE IF NOT EXISTS ";
    public static final String PRIMARY_KEY = " PRIMARY KEY ";
    public static final String AUTO_INCREMENT = " AUTOINCREMENT ";
    public static final String NOT_NULL = " NOT NULL";
    public static final String NULL = " NULL ";
    public static final String DELETE_STATEMENT = "DELETE FROM ";
    public static final String DROP_STATEMENT = "DROP TABLE IF EXISTS ";

    private IBGDbContract() {
    }

    public static class FeaturesFlagsEntry
    implements BaseColumns {
        public static final String TABLE_NAME = "features_flags";
        public static final String COLUMN_ID = "features_flags_id";
        public static final String FEATURES_FLAGS_COLUMN_KEY = "features_flags_key";
        public static final String FEATURES_FLAGS_COLUMN_VALUE = "features_flags_value";
        public static final String CREATE_TABLE_QUERY = "CREATE TABLE IF NOT EXISTS features_flags ( features_flags_id INTEGER PRIMARY KEY  AUTOINCREMENT ,features_flags_key TEXT NOT NULL,features_flags_value TEXT NULL , UNIQUE (features_flags_key) ON CONFLICT IGNORE);";
        public static final String DROP_TABLE_QUERY = "DROP TABLE IF EXISTS features_flags";
        public static final String DELETE_ALL = "DELETE FROM features_flags";
    }

    public static class SessionReplayMetadataEntry {
        public static final String TABLE_NAME = "session_replay_metadata";
        public static final String COLUMN_ID = "suuid";
        public static final String COLUMN_START_TIME = "start_time";
        public static final String COLUMN_PARTIAL_ID = "partial_id";
        public static final String COLUMN_STATUS = "status";
        public static final String CREATE_TABLE = "CREATE TABLE IF NOT EXISTS session_replay_metadata ( suuid TEXT,start_time INTEGER,partial_id INTEGER,status TEXT )";
        public static final String DROP_TABLE = "DROP TABLE IF EXISTS session_replay_metadata";
        public static final String DELETE_ALL = "DELETE FROM session_replay_metadata";
    }

    public static class SessionIncidentEntry {
        public static final String TABLE_NAME = "session_incident";
        public static final String COLUMN_ID = "id";
        public static final String COLUMN_SESSION_ID = "session_id";
        public static final String COLUMN_INCIDENT_ID = "incident_id";
        public static final String COLUMN_INCIDENT_TYPE = "incident_type";
        public static final String COLUMN_VALIDATION_STATUS = "validation_status";
        public static final String CREATE_TABLE = "CREATE TABLE IF NOT EXISTS session_incident ( id INTEGER,session_id TEXT,incident_id TEXT,incident_type TEXT,validation_status INTEGER DEFAULT 0 )";
        public static final String DROP_TABLE = "DROP TABLE IF EXISTS session_incident";
        public static final String TRIM_WHERE_CLAUSE = "id IN ( SELECT id FROM session_incident WHERE session_id = ? AND incident_type = ? ORDER BY id DESC limit ? OFFSET ? )";
    }

    public static class SessionFeaturesFlagsEntry {
        public static final String TABLE_NAME = "session_features_flags_table";
        public static final String COLUMN_ID = "id";
        public static final String COLUMN_SESSION_SERIAL = "session_serial";
        public static final String COLUMN_FEATURES_FLAGS_ARRAY = "features_flags_array";
        public static final String SESSION_SERIAL_FOREIGN_KEY_CONSTRAINT_NAME = "session_serial_foreign_key";
        public static final String CREATE_TABLE = "CREATE TABLE IF NOT EXISTS session_features_flags_table ( id INTEGER PRIMARY KEY  AUTOINCREMENT ,session_serial INTEGER UNIQUE ,features_flags_array TEXT, CONSTRAINT session_serial_foreign_key FOREIGN KEY (session_serial) REFERENCES session_table(session_serial) ON DELETE CASCADE);";
        public static final String DROP_TABLE_QUERY = "DROP TABLE IF EXISTS session_features_flags_table";
    }

    public static class SessionExperimentEntry {
        public static final String TABLE_NAME = "session_experiment_table";
        public static final String COLUMN_ID = "id";
        public static final String COLUMN_EXPERIMENT_ARRAY = "experiment_array";
        public static final String COLUMN_DROPPED_COUNT = "experiments_dropped_count";
        public static final String COLUMN_SESSION_SERIAL = "session_serial";
        public static final String SESSION_SERIAL_FOREIGN_KEY_CONSTRAINT_NAME = "session_serial_foreign_key";
        public static final String CREATE_TABLE = "CREATE TABLE IF NOT EXISTS session_experiment_table ( id INTEGER PRIMARY KEY AUTOINCREMENT,experiment_array TEXT,session_serial INTEGER UNIQUE ,experiments_dropped_count INTEGER, CONSTRAINT session_serial_foreign_key FOREIGN KEY (session_serial) REFERENCES session_table(session_serial) ON DELETE CASCADE )";
        public static final String DROP_TABLE_QUERY = "DROP TABLE IF EXISTSon session_experiment_table";
    }

    public static class SessionEntry
    implements BaseColumns {
        public static final String TABLE_NAME = "session_table";
        public static final String COLUMN_SERIAL = "session_serial";
        public static final String COLUMN_ID = "session_id";
        public static final String COLUMN_FOREGROUND_START_TIME = "foreground_start_time";
        public static final String COLUMN_NANO_START_TIME = "nano_start_time";
        public static final String COLUMN_BACKGROUND_START_TIME = "background_start_time";
        public static final String COLUMN_DURATION = "duration";
        public static final String COLUMN_USER_EVENTS = "user_events";
        public static final String COLUMN_USER_ATTRIBUTES = "user_attributes";
        public static final String COLUMN_USER_EMAIL = "user_email";
        public static final String COLUMN_USER_NAME = "user_name";
        public static final String COLUMN_UUID = "uuid";
        public static final String COLUMN_APP_TOKEN = "app_token";
        public static final String COLUMN_OS = "os";
        public static final String COLUMN_DEVICE = "device";
        public static final String COLUMN_SDK_VERSION = "sdk_version";
        public static final String COLUMN_APP_VERSION = "app_version";
        public static final String COLUMN_SYNC_STATUS = "sync_status";
        public static final String COLUMN_USERS_PAGE_ENABLED = "users_page_enabled";
        public static final String COLUMN_V2_SESSION_SENT = "v2_session_sent";
        public static final String COLUMN_PRODUCTION_USAGE = "production_usage";
        public static final String COLUMN_SESSION_STITCHING_STATE = "stitching_state";
        public static final String COLUMN_SESSION_RANDOM_ID = "session_random_id";
        public static final String COLUMN_LOCALE = "locale";
        public static final String COLUMN_SCREEN_SIZE = "screen_size";
        public static final String COLUMN_RATING_DIALOG_DETECTION = "rating_dialog_detection";
        public static final String COLUMN_SR_ENABLED = "sr_enabled";
        public static final String CREATE_TABLE = "CREATE TABLE IF NOT EXISTS session_table ( session_serial INTEGER PRIMARY KEY AUTOINCREMENT,session_id TEXT,foreground_start_time INTEGER,background_start_time INTEGER,nano_start_time INTEGER,duration INTEGER,user_attributes TEXT,user_events TEXT,user_email TEXT,uuid TEXT,user_name TEXT,os TEXT,app_token TEXT,device TEXT,sdk_version TEXT,app_version TEXT,users_page_enabled INTEGER,v2_session_sent INTEGER,sync_status TEXT,production_usage TEXT,session_random_id INTEGER,locale TEXT,screen_size TEXT,stitching_state TEXT,rating_dialog_detection TEXT,sr_enabled INTEGER DEFAULT  0 )";
        public static final String DROP_TABLE = "DROP TABLE IF EXISTS session_table";
        public static final String DELETE_ALL = "DELETE FROM session_table";
        public static final String TRIM_WHERE_CLAUSE = "session_serial IN ( SELECT session_serial FROM session_table ORDER BY session_serial DESC limit ? OFFSET ? )";
    }

    public static class AppTerminationEntry
    implements BaseColumns {
        public static final String TABLE_NAME = "terminations_table";
        public static final String COLUMN_ID = "id";
        public static final String COLUMN_TEMPORARY_SERVER_TOKEN = "temporary_server_token";
        public static final String COLUMN_STATE = "state";
        public static final String COLUMN_TERMINATION_STATE = "termination_state";
        public static final String COLUMN_LAST_ACTIVITY = "last_activity";
        public static final String COLUMN_UUID = "uuid";
        public static final String CREATE_TABLE = "CREATE TABLE IF NOT EXISTS terminations_table ( id INTEGER,temporary_server_token TEXT,termination_state TEXT,state TEXT,uuid TEXT DEFAULT NULL)";
        public static final String DROP_TABLE = "DROP TABLE IF EXISTS terminations_table";
        public static final String DELETE_ALL = "DELETE FROM terminations_table";
    }

    public static class FatalHangEntry
    implements BaseColumns {
        public static final String TABLE_NAME = "fatal_hangs_table";
        public static final String COLUMN_ID = "id";
        public static final String COLUMN_TEMPORARY_SERVER_TOKEN = "temporary_server_token";
        public static final String COLUMN_MESSAGE = "message";
        public static final String COLUMN_STATE = "state";
        public static final String COLUMN_FATAL_HANG_STATE = "fatal_hang_state";
        public static final String COLUMN_MAIN_THREAD_DETAIL = "main_thread_details";
        public static final String COLUMN_THREADS_DETAILS = "threads_details";
        public static final String COLUMN_LAST_ACTIVITY = "last_activity";
        public static final String COLUMN_UUID = "uuid";
        public static final String CREATE_TABLE = "CREATE TABLE IF NOT EXISTS fatal_hangs_table ( id TEXT,temporary_server_token TEXT,message TEXT,fatal_hang_state TEXT,state TEXT,main_thread_details TEXT,threads_details TEXT,last_activity TEXT,uuid TEXT DEFAULT NULL)";
        public static final String DROP_TABLE = "DROP TABLE IF EXISTS fatal_hangs_table";
        public static final String DELETE_ALL = "DELETE FROM fatal_hangs_table";
    }

    public static class BugEntry
    implements BaseColumns {
        public static final String TABLE_NAME = "bugs_table";
        public static final String COLUMN_ID = "id";
        public static final String COLUMN_TEMPORARY_SERVER_TOKEN = "temporary_server_token";
        public static final String COLUMN_TYPE = "type";
        public static final String COLUMN_MESSAGE = "message";
        public static final String COLUMN_STATE = "state";
        public static final String COLUMN_BUG_STATE = "bug_state";
        public static final String COLUMN_VIEW_HIERARCHY = "view_hierarchy";
        public static final String COLUMN_CATEGORIES_LIST = "categories_list";
        public static final String COLUMN_CONNECTION_ERROR = "connection_error";
        public static final String COLUMN_ACTIONABLE_CONSENT = "actionable_consent";
        public static final String COLUMN_FRUSTRATING_EXPERIENCE_INTERNAL_ID = "initial_frustrating_experience_id";
        public static final String COLUMN_FRUSTRATING_EXPERIENCE_EXTERNAL_ID = "backend_frustrating_experience_id";
        public static final String CREATE_TABLE = "CREATE TABLE IF NOT EXISTS bugs_table ( id TEXT PRIMARY KEY,temporary_server_token TEXT,type TEXT,message TEXT,state TEXT,bug_state TEXT,view_hierarchy TEXT,categories_list TEXT,connection_error TEXT DEFAULT NULL,actionable_consent TEXT DEFAULT NULL,initial_frustrating_experience_id INTEGER,backend_frustrating_experience_id TEXT DEFAULT NULL )";
        public static final String DROP_TABLE = "DROP TABLE IF EXISTS bugs_table";
        public static final String DELETE_ALL = "DELETE FROM bugs_table";
    }
}

