/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.provider.MediaStore;
import android.widget.ImageView;
import androidx.annotation.DrawableRes;
import androidx.annotation.IntRange;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.instabug.library.Instabug;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.diagnostics.IBGDiagnostics;
import com.instabug.library.internal.servicelocator.CoreServiceLocator;
import com.instabug.library.internal.storage.DiskUtils;
import com.instabug.library.internal.storage.ProcessedBytes;
import com.instabug.library.internal.storage.cache.AssetsCacheManager;
import com.instabug.library.model.AssetEntity;
import com.instabug.library.util.BitmapWorkerTask;
import com.instabug.library.util.DisplayUtils;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.d;
import com.instabug.library.util.threading.PoolProvider;
import com.instabug.library.util.threading.ThreadUtils;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;

public class BitmapUtils {
    private static final String ICON_FILE_PREFIX = "icon";

    @Nullable
    public static Bitmap getBitmapFromUri(@NonNull Uri uri) {
        Uri uri2;
        block3: {
            uri2 = null;
            if (Instabug.getApplicationContext() == null) break block3;
            try {
                Uri uri3;
                uri2 = uri3 = MediaStore.Images.Media.getBitmap((ContentResolver)Instabug.getApplicationContext().getContentResolver(), (Uri)uri3);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                InstabugSDKLogger.e("IBG-Core", "getBitmapFromFilePath returns null because of " + iOException.getMessage());
            }
        }
        return uri2;
    }

    /*
     * WARNING - void declaration
     */
    public static void compressBitmapAndSave(@NonNull Context context, @NonNull File originalImageFile) {
        void var1_1;
        if (context != null && var1_1 != null) {
            try {
                BitmapUtils.compressBitmapAndSave((File)var1_1);
            }
            catch (Throwable throwable) {
                IBGDiagnostics.reportNonFatalAndLog(throwable, "Error occur while compress images" + throwable.getMessage(), "IBG-Core");
            }
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    private static void compressBitmapAndSave(File originalImageFile) {
        var1_2 = v0;
        new BitmapFactory.Options().inJustDecodeBounds = true;
        v1 = new FileInputStream(var0);
        v2 = v1;
        BitmapFactory.decodeStream((InputStream)v1, null, (BitmapFactory.Options)var1_2);
        v2.close();
        var2_3 = 1;
        while (true) {
            if (var1_2.outWidth / var2_3 / 2 < 900) break;
            if (var1_2.outHeight / var2_3 / 2 < 900) break;
            var2_3 *= 2;
            continue;
            break;
        }
        var1_2 = v3;
        new BitmapFactory.Options().inSampleSize = var2_3;
        var2_4 = v4;
        var1_2 = BitmapFactory.decodeStream((InputStream)new FileInputStream(var0), null, (BitmapFactory.Options)var1_2);
        var3_5 = v5;
        v5 = new FileOutputStream(var0);
        if (var1_2 == null) ** GOTO lbl35
        v6 = var1_2;
        v7 = v6;
        v6.compress(BitmapUtils.getImageMimeType(var0), 100, (OutputStream)var3_5);
        try {
            v7.recycle();
lbl35:
            // 2 sources

            var3_5.close();
            var2_4.close();
        }
        catch (Exception var0_1) {
            var0_1.printStackTrace();
            InstabugSDKLogger.e("IBG-Core", "bitmap doesn't compressed correctly " + var0_1.getMessage());
        }
    }

    private static Bitmap.CompressFormat getImageMimeType(File file) {
        if (file.getName().contains("png")) {
            return Bitmap.CompressFormat.PNG;
        }
        return Bitmap.CompressFormat.JPEG;
    }

    public static void loadBitmap(String localPath, ImageView imageView) {
        String string2;
        Object[] objectArray;
        BitmapWorkerTask bitmapWorkerTask = new BitmapWorkerTask((ImageView)objectArray);
        Object[] objectArray2 = new String[1];
        objectArray = objectArray2;
        objectArray2[0] = string2;
        bitmapWorkerTask.execute(objectArray);
    }

    /*
     * WARNING - void declaration
     */
    public static void loadBitmapWithFallback(String localPath, ImageView imageView, @DrawableRes int fallbackDrawable) {
        String string2;
        void var2_2;
        Object[] objectArray;
        BitmapWorkerTask bitmapWorkerTask = new BitmapWorkerTask((ImageView)objectArray, (int)var2_2);
        Object[] objectArray2 = new String[1];
        objectArray = objectArray2;
        objectArray2[0] = string2;
        bitmapWorkerTask.execute(objectArray);
    }

    /*
     * WARNING - void declaration
     */
    public static void loadBitmap(String localPath, ImageView imageView, float targetWidth, float targetHeight) {
        String string2;
        void var3_3;
        void var2_2;
        Object[] objectArray;
        BitmapWorkerTask bitmapWorkerTask = new BitmapWorkerTask((ImageView)objectArray, (float)var2_2, (float)var3_3);
        Object[] objectArray2 = new String[1];
        objectArray = objectArray2;
        objectArray2[0] = string2;
        bitmapWorkerTask.execute(objectArray);
    }

    /*
     * WARNING - void declaration
     */
    public static void loadBitmap(@NonNull String localPath, ImageView imageView, BitmapWorkerTask.OnImageLoadedListener onImageLoadedListener) {
        String string2;
        void var2_2;
        Object[] objectArray;
        BitmapWorkerTask bitmapWorkerTask = new BitmapWorkerTask((ImageView)objectArray, (BitmapWorkerTask.OnImageLoadedListener)var2_2);
        Object[] objectArray2 = new String[1];
        objectArray = objectArray2;
        objectArray2[0] = string2;
        bitmapWorkerTask.execute(objectArray);
    }

    /*
     * WARNING - void declaration
     */
    public static void loadBitmap(String localPath, ImageView imageView, float targetWidth, float targetHeight, BitmapWorkerTask.OnImageLoadedListener onImageLoadedListener) {
        String string2;
        void var4_4;
        void var3_3;
        void var2_2;
        Object[] objectArray;
        BitmapWorkerTask bitmapWorkerTask = new BitmapWorkerTask((ImageView)objectArray, (float)var2_2, (float)var3_3, (BitmapWorkerTask.OnImageLoadedListener)var4_4);
        Object[] objectArray2 = new String[1];
        objectArray = objectArray2;
        objectArray2[0] = string2;
        bitmapWorkerTask.execute(objectArray);
    }

    public static Bitmap decodeSampledBitmapFromLocalPath(String imageFilePath) {
        String string2;
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)string2, (BitmapFactory.Options)options);
        options.inSampleSize = BitmapUtils.calculateInSampleSize(options);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeFile((String)imageFilePath, (BitmapFactory.Options)options);
    }

    public static int calculateInSampleSize(BitmapFactory.Options options) {
        BitmapFactory.Options options2;
        int n5 = options.outHeight;
        int n6 = options2.outWidth;
        int n7 = 1;
        int n8 = 500;
        int n9 = 500;
        if (n5 > n8 || n6 > n9) {
            int n10 = n6;
            n6 = n5 / 2;
            n5 = n10 / 2;
            while (n6 / n7 >= n8 && n5 / n7 >= n9) {
                n7 *= 2;
            }
        }
        return n7;
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    public static Uri saveBitmapAsPNG(Bitmap bitmap, int quality, File directory, String fileNamePrefix) throws IOException {
        void var1_1;
        d d5;
        BufferedOutputStream bufferedOutputStream;
        void var3_4;
        BufferedOutputStream bufferedOutputStream2;
        File file;
        File file2 = file;
        file = new File((File)((Object)bufferedOutputStream2), (String)var3_4 + "_" + System.currentTimeMillis() + ".png");
        bufferedOutputStream2 = bufferedOutputStream;
        bufferedOutputStream2(new FileOutputStream(file2));
        d5 = BitmapUtils.compressQuietlyBitmap((Bitmap)d5, Bitmap.CompressFormat.PNG, (int)var1_1, bufferedOutputStream2);
        ((OutputStream)bufferedOutputStream).close();
        Uri uri = Uri.fromFile((File)file);
        if (!d5.a()) {
            if ((d5.b() || d5.a()) && uri != null) {
                return uri;
            }
            throw new IOException("uri is null");
        }
        throw new OutOfMemoryError();
    }

    /*
     * WARNING - void declaration
     */
    public static long getCompressedBitmapSize(Bitmap bitmap, int quality) {
        void var1_1;
        ByteArrayOutputStream byteArrayOutputStream;
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
        byteArrayOutputStream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, (int)var1_1, (OutputStream)byteArrayOutputStream2);
        return byteArrayOutputStream2.size();
    }

    /*
     * WARNING - void declaration
     */
    public static void saveBitmapAsPNG(Bitmap bitmap, int quality, File directory, String fileNamePrefix, OnSaveBitmapCallback callback) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        PoolProvider.postIOTask(() -> BitmapUtils.lambda$saveBitmapAsPNG$0(bitmap, (int)var1_1, (File)var2_2, (String)var3_3, (OnSaveBitmapCallback)var4_4));
    }

    /*
     * WARNING - void declaration
     */
    public static void saveBitmap(Bitmap bitmap, Context context, OnSaveBitmapCallback callback) {
        void var2_2;
        Bitmap bitmap2;
        PoolProvider.postIOTask(() -> BitmapUtils.lambda$saveBitmap$1(context, bitmap2, (OnSaveBitmapCallback)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    @WorkerThread
    public static Uri saveDrawableBitmap(Drawable drawable2, long currentTime) throws ExecutionException, InterruptedException {
        void var1_1;
        Drawable drawable3;
        if (drawable2 == null) {
            return null;
        }
        return BitmapUtils.saveDrawableIntoFile(drawable3, (long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private static Uri saveDrawableIntoFile(Drawable drawable2, long currentTime) throws ExecutionException, InterruptedException {
        void var1_1;
        File file;
        Drawable drawable3 = BitmapUtils.getBitmapFromDrawable(drawable2);
        if (drawable3 != null && BitmapUtils.saveBitmap(file = BitmapUtils.getIconTargetDirectory((long)var1_1), (Bitmap)drawable3)) {
            return Uri.fromFile((File)file);
        }
        return null;
    }

    @Nullable
    private static Bitmap getBitmapFromDrawable(Drawable drawable2) throws ExecutionException, InterruptedException {
        Future<Bitmap> future = BitmapUtils.drawableToResizedBitmap(drawable2);
        return future != null ? (Bitmap)future.get() : null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean saveBitmap(File file, Bitmap bitmap) {
        block14: {
            var2_6 = null;
            var3_7 = v0;
            v1 = var1_5;
            var3_7(new FileOutputStream(var0));
            try {
                var0_1 = BitmapUtils.compressQuietly((Bitmap)v1, Bitmap.CompressFormat.PNG, 100, var3_7);
            }
            catch (Throwable var0_2) {
                var2_6 = var3_7;
                break block14;
            }
            catch (IOException v2) {
                var2_6 = var3_7;
                ** GOTO lbl-1000
            }
            try {
                v0.close();
                return var0_1;
            }
            catch (IOException v3) {
                InstabugSDKLogger.e("IBG-Core", "can't close BufferedOutputStream");
            }
            return var0_1;
            catch (Throwable var0_3) {
                break block14;
            }
            catch (IOException v4) {}
lbl-1000:
            // 2 sources

            {
                InstabugSDKLogger.e("IBG-Core", "can't compress bitmap");
                if (var2_6 == null) return false;
            }
            try {
                var2_6.close();
                return false;
            }
            catch (IOException v5) {
                InstabugSDKLogger.e("IBG-Core", "can't close BufferedOutputStream");
            }
            return false;
        }
        if (var2_6 == null) throw var0_4;
        try {
            var2_6.close();
            throw var0_4;
        }
        catch (IOException v6) {
            InstabugSDKLogger.e("IBG-Core", "can't close BufferedOutputStream");
        }
        throw var0_4;
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    public static void loadBitmapForAsset(@Nullable Context context, String fileUrl, AssetEntity.AssetType type, OnBitmapReady onBitmapReady) {
        if (context != null) {
            void var3_3;
            void var2_2;
            void var1_1;
            Context context2;
            AssetsCacheManager.getAssetEntity(AssetsCacheManager.createEmptyEntity(context2, (String)var1_1, (AssetEntity.AssetType)var2_2), new AssetsCacheManager.OnDownloadFinished((OnBitmapReady)var3_3){
                final /* synthetic */ OnBitmapReady a;
                {
                    this.a = onBitmapReady;
                }

                /*
                 * WARNING - void declaration
                 */
                private static /* synthetic */ void a(AssetEntity assetEntity, OnBitmapReady onBitmapReady) {
                    void var1_1;
                    BitmapUtils.access$000(assetEntity, (OnBitmapReady)var1_1);
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void onSuccess(AssetEntity assetEntity) {
                    void var1_1;
                    InstabugSDKLogger.d("IBG-Core", "Asset Entity downloaded: " + var1_1.getFile().getPath());
                    if (ThreadUtils.isCurrentThreadMain()) {
                        PoolProvider.postIOTask(() -> b.a((AssetEntity)var1_1, this.a));
                    } else {
                        BitmapUtils.access$000((AssetEntity)var1_1, this.a);
                    }
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void onFailed(Throwable error) {
                    void var1_1;
                    InstabugSDKLogger.e("IBG-Core", "Asset Entity downloading got error", (Throwable)var1_1);
                    this.a.onBitmapFailedToLoad();
                }
            });
        }
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @WorkerThread
    private static void decodeBitmap(AssetEntity assetEntity, OnBitmapReady onBitmapReady) {
        AssetEntity assetEntity2;
        void var1_3;
        FileInputStream fileInputStream;
        FileInputStream fileInputStream2 = fileInputStream;
        void v12 = var1_3;
        FileInputStream fileInputStream3 = fileInputStream2;
        FileInputStream fileInputStream4 = fileInputStream3;
        fileInputStream3(assetEntity2.getFile());
        v12.onBitmapReady(BitmapFactory.decodeStream((InputStream)fileInputStream4));
        fileInputStream.close();
        return;
        catch (Throwable throwable) {
            try {
                fileInputStream2.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                try {
                    throwable.addSuppressed(throwable2);
                    throw throwable;
                }
                catch (IOException iOException) {
                    InstabugSDKLogger.e("IBG-Core", "Asset Entity downloading got FileNotFoundException error", iOException);
                    var1_3.onBitmapFailedToLoad();
                }
            }
        }
    }

    @WorkerThread
    @NonNull
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public static File getIconTargetDirectory(long currentTime) {
        long l5;
        File file = (File)CoreServiceLocator.getReproScreenshotsCacheDir().getCurrentSpanDirectory();
        return new File(file, "icon_" + l5 + ".png");
    }

    @Nullable
    private static Future<Bitmap> drawableToResizedBitmap(Drawable drawable2) throws ExecutionException, InterruptedException {
        Drawable drawable3;
        Object object;
        if (drawable2 instanceof BitmapDrawable && (object = BitmapUtils.extractBitmap((BitmapDrawable)drawable3)) != null) {
            return object;
        }
        object = Instabug.getApplicationContext();
        if (object != null) {
            int n5 = DisplayUtils.dpToPxIntRounded(object.getResources(), 72);
            int n6 = drawable3.getIntrinsicWidth();
            int n7 = drawable3.getIntrinsicHeight();
            if (n6 <= n5 && n7 <= n5) {
                return BitmapUtils.createBitMap(drawable3, n6, n7);
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static Future<Bitmap> createBitMap(Drawable drawable2, int intrinsicWidth, int intrinsicHeight) throws ExecutionException, InterruptedException {
        Canvas canvas;
        void var2_3;
        void var1_1;
        Drawable drawable3;
        Drawable drawable4 = drawable3;
        drawable3 = Bitmap.createBitmap((int)var1_1, (int)var2_3, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas2 = canvas;
        canvas = new Canvas((Bitmap)drawable3);
        BitmapUtils.drawDrawableIntoCanvasInMainThread(BitmapUtils.getClonedDrawable(drawable4), canvas2);
        return PoolProvider.submitIOTask(() -> BitmapUtils.lambda$createBitMap$2(intrinsicWidth, (int)var2_3, (Bitmap)drawable3));
    }

    @NonNull
    private static Drawable getClonedDrawable(Drawable drawable2) {
        Drawable drawable3;
        if (drawable2.getConstantState() != null) {
            drawable3 = drawable3.getConstantState().newDrawable();
        }
        return drawable3;
    }

    @Nullable
    private static FutureTask<Bitmap> extractBitmap(BitmapDrawable drawable2) {
        BitmapDrawable bitmapDrawable = drawable2.getBitmap();
        if (bitmapDrawable != null) {
            FutureTask<Bitmap> futureTask = new FutureTask<Bitmap>(() -> BitmapUtils.lambda$extractBitmap$3((Bitmap)bitmapDrawable));
            futureTask.run();
            return futureTask;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static void drawDrawableIntoCanvasInMainThread(Drawable clonedDrawable, Canvas canvas) throws ExecutionException, InterruptedException {
        void var1_1;
        PoolProvider.submitMainThreadTask(() -> BitmapUtils.lambda$drawDrawableIntoCanvasInMainThread$4(clonedDrawable, (Canvas)var1_1)).get();
    }

    public static Bitmap drawableToBitmap(Drawable drawable2) {
        Canvas canvas;
        Drawable drawable3;
        BitmapDrawable bitmapDrawable;
        if (drawable2 instanceof BitmapDrawable && (bitmapDrawable = (BitmapDrawable)drawable3).getBitmap() != null) {
            return bitmapDrawable.getBitmap();
        }
        int n5 = drawable3.getIntrinsicWidth();
        int n6 = drawable3.getIntrinsicHeight();
        if (n5 <= 0 || n6 <= 0) {
            n5 = n6 = 1;
        }
        Bitmap bitmap = Bitmap.createBitmap((int)n5, (int)n6, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Drawable drawable4 = drawable3;
        drawable3 = canvas;
        int n7 = new Canvas(bitmap).getWidth();
        n6 = drawable3.getHeight();
        drawable4.setBounds(0, 0, n7, n6);
        drawable4.draw((Canvas)drawable3);
        return bitmap;
    }

    /*
     * WARNING - void declaration
     */
    private static float[] getTargetDimensions(int realWidth, int realHeight) {
        void var1_1;
        int n5;
        float f5 = 24.0f;
        float[] fArray = new float[2];
        float[] fArray2 = fArray;
        fArray[0] = f5;
        fArray[1] = f5;
        if (realHeight > n5) {
            fArray2[0] = (float)n5 / (float)var1_1 * f5;
        } else if (var1_1 < n5) {
            fArray2[1] = (float)var1_1 / (float)n5 * f5;
        }
        return fArray2;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static Bitmap resizeBitmap(Bitmap bitmap, float targetWidth, float targetHeight) {
        Paint paint;
        Matrix matrix;
        Canvas canvas;
        Bitmap bitmap2;
        void var2_3;
        void var1_1;
        if (bitmap == null) {
            return null;
        }
        if (var1_1 == 0.0f && var2_3 == 0.0f) {
            return bitmap2;
        }
        Bitmap bitmap3 = Bitmap.createBitmap((int)((int)var1_1), (int)((int)var2_3), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        if (bitmap2.getWidth() < bitmap2.getHeight() && var1_1 > var2_3) {
            return bitmap2;
        }
        if (bitmap2.getWidth() > bitmap2.getHeight() && var1_1 < var2_3) {
            return bitmap2;
        }
        Canvas canvas2 = canvas;
        canvas = new Canvas(bitmap3);
        Matrix matrix2 = matrix;
        matrix = new Matrix();
        if (bitmap2.getWidth() < bitmap2.getHeight()) {
            matrix2.setScale((float)(var1_1 /= (float)bitmap2.getWidth()), (float)(var2_3 / (float)bitmap2.getHeight()));
        } else {
            void v22 = var1_1;
            var1_1 = var2_3 / (float)bitmap2.getHeight();
            matrix2.setScale((float)var1_1, (float)(v22 / (float)bitmap2.getWidth()));
        }
        Paint paint2 = paint;
        paint = new Paint();
        canvas2.drawBitmap(bitmap2, matrix2, paint2);
        return bitmap3;
    }

    /*
     * WARNING - void declaration
     */
    public static void saveBitmap(Bitmap bitmap, Uri imageUri, Context context, OnSaveBitmapCallback callback) {
        if (imageUri.getPath() != null) {
            void var3_3;
            Bitmap bitmap2;
            void var2_2;
            void var1_1;
            PoolProvider.postIOTask(() -> BitmapUtils.lambda$saveBitmap$5((Uri)var1_1, (Context)var2_2, bitmap2, (OnSaveBitmapCallback)var3_3));
        }
    }

    @WorkerThread
    public static Bitmap decryptBitmap(String path) {
        Object object = InstabugCore.decryptOnTheFly(path);
        if (((ProcessedBytes)object).isProcessSuccessful()) {
            byte[] byArray = ((ProcessedBytes)object).getFileBytes();
            return BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length);
        }
        object = Bitmap.Config.ARGB_8888;
        return Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)object);
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    public static boolean compressQuietly(@NonNull Bitmap bitmap, @NonNull Bitmap.CompressFormat format, @IntRange(from=0L, to=100L) int quality, @NonNull OutputStream outputStream) {
        boolean bl;
        block4: {
            block3: {
                void var3_4;
                void var2_3;
                void var1_2;
                Bitmap bitmap2;
                try {
                    if (bitmap.isRecycled()) break block3;
                }
                catch (Exception exception) {
                    InstabugSDKLogger.e("IBG-Core", "Error while compressing bitmap " + exception.getMessage());
                    return false;
                }
                if (!bitmap2.compress((Bitmap.CompressFormat)var1_2, (int)var2_3, (OutputStream)var3_4)) break block3;
                bl = true;
                break block4;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    public static d compressQuietlyBitmap(@NonNull Bitmap bitmap, @NonNull Bitmap.CompressFormat format, @IntRange(from=0L, to=100L) int quality, @NonNull OutputStream outputStream) {
        try {
            void var3_5;
            void var2_4;
            void var1_3;
            Bitmap bitmap2;
            if (bitmap.isRecycled()) return new d(false, false);
            if (!bitmap2.compress((Bitmap.CompressFormat)var1_3, (int)var2_4, (OutputStream)var3_5)) return new d(false, false);
            return new d(true, false);
        }
        catch (Exception exception) {
            InstabugSDKLogger.e("IBG-Core", "Error while compressing bitmap " + exception.getMessage());
            return new d(false, false);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            InstabugSDKLogger.e("IBG-Core", "Error while compressing bitmap due to low memory " + outOfMemoryError.getMessage());
            return new d(false, true);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static /* synthetic */ void lambda$saveBitmap$5(Uri imageUri, Context context, Bitmap bitmap, OnSaveBitmapCallback callback) {
        void var2_4;
        Uri uri;
        OutputStream outputStream;
        if (imageUri.getPath() == null) return;
        void v02 = outputStream;
        uri = Uri.fromFile((File)new File(uri.getPath()));
        outputStream = v02.getContentResolver().openOutputStream(uri);
        if (outputStream == null) return;
        final boolean bl = BitmapUtils.compressQuietly((Bitmap)var2_4, Bitmap.CompressFormat.PNG, 100, outputStream);
        try {
            void var3_5;
            new Handler(Looper.getMainLooper()).post(new Runnable((OnSaveBitmapCallback)var3_5, uri){
                final /* synthetic */ OnSaveBitmapCallback b;
                final /* synthetic */ Uri c;
                {
                    this.b = onSaveBitmapCallback;
                    this.c = uri;
                }

                @Override
                public void run() {
                    OnSaveBitmapCallback onSaveBitmapCallback;
                    if (bl && (onSaveBitmapCallback = this.b) != null) {
                        onSaveBitmapCallback.onSuccess(this.c);
                    }
                }
            });
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (fileNotFoundException.getMessage() == null) return;
            InstabugSDKLogger.e("IBG-Core", "Error while saving bitmap: " + fileNotFoundException.getMessage());
        }
        return;
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ Canvas lambda$drawDrawableIntoCanvasInMainThread$4(Drawable clonedDrawable, Canvas canvas) throws Exception {
        void var1_2;
        Drawable drawable2;
        Drawable drawable3 = drawable2;
        void v12 = var1_2;
        int n5 = v12.getWidth();
        int n6 = v12.getHeight();
        drawable3.setBounds(0, 0, n5, n6);
        drawable3.draw((Canvas)var1_2);
        return canvas;
    }

    private static /* synthetic */ Bitmap lambda$extractBitmap$3(Bitmap originalBitmap) throws Exception {
        return BitmapUtils.resizeBitmap(originalBitmap, 24.0f, 24.0f);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ Bitmap lambda$createBitMap$2(int intrinsicWidth, int intrinsicHeight, Bitmap bitmap) throws Exception {
        void var1_2;
        int n5;
        float[] fArray = BitmapUtils.getTargetDimensions(n5, (int)var1_2);
        float f5 = fArray[0];
        return BitmapUtils.resizeBitmap(bitmap, f5, fArray[1]);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$saveBitmap$1(Context context, Bitmap bitmap, OnSaveBitmapCallback callback) {
        void var2_4;
        Uri uri;
        BufferedOutputStream bufferedOutputStream;
        FileOutputStream fileOutputStream;
        File file;
        Object object = DiskUtils.getInstabugInternalDirectory(context);
        Object object2 = file;
        file = new File((File)object, "bug_" + System.currentTimeMillis() + "_.jpg");
        object = fileOutputStream;
        fileOutputStream = new FileOutputStream((File)object2);
        object2 = bufferedOutputStream;
        ((BufferedOutputStream)object2)((OutputStream)object);
        final boolean bl = BitmapUtils.compressQuietly((Bitmap)uri, Bitmap.CompressFormat.JPEG, 100, (OutputStream)object2);
        ((OutputStream)bufferedOutputStream).close();
        uri = Uri.fromFile((File)file);
        try {
            new Handler(Looper.getMainLooper()).post(new Runnable((OnSaveBitmapCallback)var2_4){
                final /* synthetic */ OnSaveBitmapCallback c;
                {
                    this.c = onSaveBitmapCallback;
                }

                @Override
                public void run() {
                    Uri uri2;
                    if (bl && (uri2 = uri) != null) {
                        this.c.onSuccess(uri2);
                    } else {
                        this.c.onError(new Throwable("Uri equal null"));
                    }
                }
            });
        }
        catch (IOException iOException) {
            var2_4.onError(iOException);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$saveBitmapAsPNG$0(Bitmap bitmap, int quality, File directory, String fileNamePrefix, OnSaveBitmapCallback callback) {
        try {
            void var3_4;
            void var2_3;
            void var1_2;
            Bitmap bitmap2;
            callback.onSuccess(BitmapUtils.saveBitmapAsPNG(bitmap2, (int)var1_2, (File)var2_3, (String)var3_4));
        }
        catch (IOException iOException) {
            void var4_5;
            var4_5.onError(iOException);
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$000(AssetEntity x02, OnBitmapReady x12) {
        void var1_1;
        BitmapUtils.decodeBitmap(x02, (OnBitmapReady)var1_1);
    }

    @Keep
    public static interface OnBitmapReady {
        public void onBitmapReady(@Nullable Bitmap var1);

        public void onBitmapFailedToLoad();
    }

    public static interface OnSaveBitmapCallback {
        public void onSuccess(Uri var1);

        public void onError(Throwable var1);
    }
}

