/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.model;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.library.Feature;
import com.instabug.library.Instabug;
import com.instabug.library.d;
import com.instabug.library.internal.servicelocator.CoreServiceLocator;
import com.instabug.library.internal.storage.cache.Cacheable;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.StringUtility;
import com.instabug.library.util.memory.MemoryUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ConsoleLog
implements Cacheable,
Serializable {
    private static final String CONSOLE_LOG_DEFAULT_DATE_FORMAT = "MM-dd HH:mm:ss.SSS";
    private static final String KEY_TIMESTAMP = "timestamp";
    private static final String KEY_MESSAGE = "message";
    private static final String KEY_DATE = "date";
    public static final int LINES_LIMIT = 700;
    @Nullable
    private String message;
    private long timeStamp;
    @Nullable
    private String date;

    public static ArrayList<ConsoleLog> fromJson(JSONArray consoleLogsAsJsonArray) throws JSONException {
        JSONArray jSONArray;
        ArrayList<ConsoleLog> arrayList;
        ArrayList<ConsoleLog> arrayList2 = arrayList;
        arrayList = new ArrayList<ConsoleLog>();
        if (consoleLogsAsJsonArray != null && jSONArray.length() > 0) {
            for (int i5 = 0; i5 < jSONArray.length(); ++i5) {
                ConsoleLog consoleLog;
                ConsoleLog consoleLog2 = consoleLog;
                consoleLog2();
                consoleLog.fromJson(jSONArray.getJSONObject(i5).toString());
                arrayList2.add(consoleLog);
            }
        }
        return arrayList2;
    }

    public static JSONArray toJson(@Nullable ArrayList<ConsoleLog> consoleLogsArrayList) {
        Iterator<ConsoleLog> iterator;
        JSONArray jSONArray;
        JSONArray jSONArray2 = jSONArray;
        jSONArray = new JSONArray();
        if (consoleLogsArrayList != null && ((ArrayList)((Object)iterator)).size() > 0) {
            iterator = ((ArrayList)((Object)iterator)).iterator();
            while (iterator.hasNext()) {
                ConsoleLog consoleLog = (ConsoleLog)iterator.next();
                try {
                    jSONArray2.put((Object)new JSONObject(consoleLog.toJson()));
                }
                catch (JSONException jSONException) {
                    InstabugSDKLogger.e("IBG-Core", "Error while parsing console log " + jSONException.getMessage());
                }
            }
        }
        return jSONArray2;
    }

    /*
     * WARNING - void declaration
     */
    static long convertConsoleLogMessageDateToTimeStamp(@Nullable String dateAsString, SimpleDateFormat dateFormat, Calendar tempCalendar, Calendar consoleLogMessageCalendar) {
        if (dateAsString != null) {
            void var3_4;
            void var2_3;
            block10: {
                Date date;
                try {
                    void var1_2;
                    date = var1_2.parse((String)((Object)date));
                    if (date == null) break block10;
                }
                catch (Exception exception) {
                    return 0L;
                }
                var2_3.setTime(date);
            }
            void v12 = var3_4;
            int n5 = 2;
            var3_4.set(n5, var2_3.get(2));
            n5 = 5;
            var3_4.set(n5, var2_3.get(5));
            n5 = 11;
            var3_4.set(n5, var2_3.get(11));
            n5 = 12;
            var3_4.set(n5, var2_3.get(12));
            n5 = 13;
            var3_4.set(n5, var2_3.get(13));
            n5 = 14;
            v12.set(n5, var2_3.get(14));
            return v12.getTimeInMillis();
        }
        return 0L;
    }

    /*
     * Loose catch block
     */
    @Nullable
    public static synchronized List<String> getConsoleLogs(float percentage) {
        LinkedList linkedList;
        Object object = Instabug.getApplicationContext();
        if (object != null && MemoryUtils.isLowMemory((Context)object)) {
            InstabugSDKLogger.e("IBG-Core", "Running low on memory. Excluding Console Logs serialization from state builder.");
            return null;
        }
        object = linkedList;
        linkedList = new LinkedList();
        if (d.c().b((Object)"CONSOLE_LOGS") == Feature.State.ENABLED) {
            BufferedReader bufferedReader;
            float f5;
            int n5 = CoreServiceLocator.getLimitConstraintApplier().applyConstraints(Math.round(f5 * 700.0f));
            Process process = Runtime.getRuntime().exec("logcat -v time -d -t " + n5 + " --pid=" + android.os.Process.myPid());
            BufferedReader bufferedReader2 = bufferedReader;
            bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream(), Charset.forName("UTF-8")));
            while (true) {
                String string2;
                block19: {
                    string2 = bufferedReader2.readLine();
                    if (string2 == null) break;
                    if (string2.length() < 19) continue;
                    if (((LinkedList)object).size() < n5) break block19;
                    ((LinkedList)object).removeFirst();
                }
                ((LinkedList)object).add(string2);
            }
            process.destroy();
            try {
                bufferedReader2.close();
            }
            catch (IOException iOException) {
                InstabugSDKLogger.e("IBG-Core", "Failed to close file reader", iOException);
            }
            return object;
            catch (Throwable throwable) {
                BufferedReader bufferedReader3;
                try {
                    bufferedReader3 = bufferedReader2;
                    InstabugSDKLogger.e("IBG-Core", "Could not read logcat log", throwable);
                    process.destroy();
                }
                catch (Throwable throwable2) {
                    process.destroy();
                    try {
                        bufferedReader2.close();
                    }
                    catch (IOException iOException) {
                        InstabugSDKLogger.e("IBG-Core", "Failed to close file reader", iOException);
                    }
                    throw throwable2;
                }
                try {
                    bufferedReader3.close();
                }
                catch (IOException iOException) {
                    InstabugSDKLogger.e("IBG-Core", "Failed to close file reader", iOException);
                }
                return object;
            }
            catch (Throwable throwable) {
                InstabugSDKLogger.e("IBG-Core", "Could not read logcat log", throwable);
                return object;
            }
        }
        return object;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    /*
     * WARNING - void declaration
     */
    public void setTimeStamp(long timeStamp) {
        void var1_1;
        this.timeStamp = var1_1;
    }

    @Nullable
    public String getMessage() {
        return this.message;
    }

    /*
     * WARNING - void declaration
     */
    public void setMessage(@Nullable String message) {
        void var1_1;
        this.message = var1_1;
    }

    @Nullable
    public String getDate() {
        return this.date;
    }

    /*
     * WARNING - void declaration
     */
    public void setDate(String date) {
        void var1_1;
        this.date = var1_1;
    }

    @Override
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public String toJson() throws JSONException {
        JSONObject jSONObject;
        if (this.timeStamp == 0L && Looper.myLooper() != Looper.getMainLooper()) {
            ConsoleLog consoleLog = this;
            consoleLog.setTimeStamp(ConsoleLog.convertConsoleLogMessageDateToTimeStamp(consoleLog.getDate(), new SimpleDateFormat(CONSOLE_LOG_DEFAULT_DATE_FORMAT, Locale.US), Calendar.getInstance(), Calendar.getInstance()));
        }
        JSONObject jSONObject2 = jSONObject;
        jSONObject2();
        long l5 = this.getTimeStamp();
        jSONObject2.put(KEY_TIMESTAMP, l5);
        jSONObject2.put(KEY_MESSAGE, (Object)this.getMessage());
        jSONObject.put(KEY_DATE, (Object)this.getDate());
        return jSONObject.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fromJson(String modelAsJson) throws JSONException {
        void var1_1;
        JSONObject jSONObject;
        JSONObject jSONObject2 = jSONObject;
        if (new JSONObject((String)var1_1).has(KEY_TIMESTAMP)) {
            if (StringUtility.isNumeric(jSONObject2.getString(KEY_TIMESTAMP))) {
                this.setTimeStamp(jSONObject2.getLong(KEY_TIMESTAMP));
            } else {
                this.setTimeStamp(ConsoleLog.convertConsoleLogMessageDateToTimeStamp(jSONObject2.getString(KEY_TIMESTAMP), new SimpleDateFormat(CONSOLE_LOG_DEFAULT_DATE_FORMAT, Locale.US), Calendar.getInstance(), Calendar.getInstance()));
            }
        }
        if (jSONObject2.has(KEY_MESSAGE)) {
            this.setMessage(jSONObject2.getString(KEY_MESSAGE));
        }
        if (jSONObject2.has(KEY_DATE)) {
            this.setDate(jSONObject2.getString(KEY_DATE));
        }
    }

    @NonNull
    public String toString() {
        return "ConsoleLog{timeStamp='" + this.timeStamp + '\'' + ", message='" + this.message + '\'' + ", date='" + this.date + '\'' + '}';
    }
}

