/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ImageView;

public class ScaleImageView
extends ImageView
implements View.OnTouchListener {
    private Context mContext;
    private float MAX_SCALE = 5.0f;
    private Matrix mMatrix;
    private final float[] mMatrixValues = new float[9];
    private int mWidth;
    private int mHeight;
    private int mIntrinsicWidth;
    private int mIntrinsicHeight;
    private float mScale;
    private float mMinScale;
    private float mPrevDistance;
    private boolean isScaling;
    private int mPrevMoveX;
    private int mPrevMoveY;
    private GestureDetector mDetector;

    /*
     * WARNING - void declaration
     */
    public ScaleImageView(Context context, AttributeSet attr2) {
        super((Context)var1_1, (AttributeSet)var2_2);
        void var2_2;
        void var1_1;
        this.mContext = var1_1;
        this.initialize();
    }

    /*
     * WARNING - void declaration
     */
    public ScaleImageView(Context context) {
        super((Context)var1_1);
        void var1_1;
        this.mContext = var1_1;
        this.initialize();
    }

    private void initialize() {
        GestureDetector.SimpleOnGestureListener simpleOnGestureListener;
        GestureDetector gestureDetector;
        ScaleImageView scaleImageView = this;
        scaleImageView.setScaleType(ImageView.ScaleType.MATRIX);
        scaleImageView.mMatrix = new Matrix();
        Drawable drawable2 = scaleImageView.getDrawable();
        if (drawable2 != null) {
            ScaleImageView scaleImageView2 = this;
            this.mIntrinsicWidth = drawable2.getIntrinsicWidth();
            scaleImageView2.mIntrinsicHeight = drawable2.getIntrinsicHeight();
            scaleImageView2.setOnTouchListener(scaleImageView2);
        }
        drawable2 = gestureDetector;
        Context context = this.mContext;
        GestureDetector.SimpleOnGestureListener simpleOnGestureListener2 = simpleOnGestureListener;
        simpleOnGestureListener = new GestureDetector.SimpleOnGestureListener(this){
            final /* synthetic */ ScaleImageView a;
            {
                void var1_1;
                this.a = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public boolean onDoubleTap(MotionEvent e5) {
                void var1_1;
                a a5 = this;
                a5.a.maxZoomTo((int)var1_1.getX(), (int)var1_1.getY());
                a5.a.cutting();
                return super.onDoubleTap((MotionEvent)var1_1);
            }
        };
        gestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)simpleOnGestureListener2);
        this.mDetector = drawable2;
    }

    /*
     * WARNING - void declaration
     */
    private float distance(float x02, float x12, float y02, float y12) {
        void var4_5;
        void var3_4;
        void var0_1;
        void var2_3;
        float f5 = x02 - var2_3;
        void v12 = var0_1 = var3_4 - var4_5;
        return (float)Math.sqrt(f5 * f5 + v12 * v12);
    }

    private float dispDistance() {
        int n5 = this.mWidth;
        int n6 = this.mHeight;
        return (float)Math.sqrt(n5 * n5 + n6 * n6);
    }

    /*
     * WARNING - void declaration
     */
    public void setImageBitmap(Bitmap bm) {
        void var1_1;
        ScaleImageView scaleImageView = this;
        super.setImageBitmap((Bitmap)var1_1);
        scaleImageView.initialize();
    }

    /*
     * WARNING - void declaration
     */
    public void setImageResource(int resId) {
        void var1_1;
        ScaleImageView scaleImageView = this;
        super.setImageResource((int)var1_1);
        scaleImageView.initialize();
    }

    /*
     * WARNING - void declaration
     */
    protected boolean setFrame(int l5, int t4, int r4, int b5) {
        boolean bl;
        int n5;
        int n6;
        float f5;
        float f6;
        void var2_4;
        void var4_6;
        void var1_2;
        void var3_5;
        void var5_7 = var3_5 - var1_2;
        this.mWidth = var5_7;
        this.mHeight = var4_6 - var2_4;
        this.mMatrix.reset();
        this.mScale = f6 = (float)var5_7 / (float)this.mIntrinsicWidth;
        int n7 = this.mIntrinsicHeight;
        int n8 = this.mHeight;
        if (f5 * (float)n6 > (float)n5) {
            ScaleImageView scaleImageView = this;
            scaleImageView.mScale = f6 = (float)n8 / (float)n7;
            float f7 = f6;
            scaleImageView.mMatrix.postScale(f7, f7);
            bl = (var3_5 - scaleImageView.mWidth) / 2;
            n7 = 0;
        } else {
            ScaleImageView scaleImageView = this;
            float f8 = f6;
            scaleImageView.mMatrix.postScale(f8, f8);
            n7 = (var4_6 - scaleImageView.mHeight) / 2;
            bl = false;
        }
        ScaleImageView scaleImageView = this;
        float f9 = (float)bl;
        scaleImageView.mMatrix.postTranslate(f9, (float)n7);
        scaleImageView.setImageMatrix(scaleImageView.mMatrix);
        scaleImageView.mMinScale = f9 = scaleImageView.mScale;
        ScaleImageView scaleImageView2 = this;
        int n9 = scaleImageView2.mWidth / 2;
        scaleImageView.zoomTo(f9, n9, scaleImageView2.mHeight / 2);
        scaleImageView.cutting();
        return super.setFrame((int)var1_2, (int)var2_4, (int)var3_5, (int)var4_6);
    }

    /*
     * WARNING - void declaration
     */
    protected float getValue(Matrix matrix, int whichValue) {
        void var2_2;
        void var1_1;
        var1_1.getValues(this.mMatrixValues);
        return this.mMatrixValues[var2_2];
    }

    protected float getScale() {
        ScaleImageView scaleImageView = this;
        return scaleImageView.getValue(scaleImageView.mMatrix, 0);
    }

    public float getTranslateX() {
        ScaleImageView scaleImageView = this;
        return scaleImageView.getValue(scaleImageView.mMatrix, 2);
    }

    protected float getTranslateY() {
        ScaleImageView scaleImageView = this;
        return scaleImageView.getValue(scaleImageView.mMatrix, 5);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    protected void maxZoomTo(int x4, int y4) {
        void var2_2;
        void var1_1;
        if (this.mMinScale != this.getScale()) {
            float f5;
            float f6 = this.mMinScale;
            if (this.getScale() - f5 > 0.1f) {
                this.zoomTo(f6 / this.getScale(), (int)var1_1, (int)var2_2);
                return;
            }
        }
        ScaleImageView scaleImageView = this;
        scaleImageView.zoomTo(scaleImageView.MAX_SCALE / this.getScale(), (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void zoomTo(float scale, int x4, int y4) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.getScale() * var1_1 < this.mMinScale) {
            return;
        }
        if (var1_1 >= 1.0f && this.getScale() * var1_1 > this.MAX_SCALE) {
            return;
        }
        ScaleImageView scaleImageView = this;
        void v12 = var1_1;
        scaleImageView.mMatrix.postScale((float)v12, (float)v12);
        ScaleImageView scaleImageView2 = this;
        int n5 = scaleImageView2.mWidth;
        float f5 = -((float)n5 * var1_1 - (float)n5) / 2.0f;
        int n6 = scaleImageView2.mHeight;
        scaleImageView.mMatrix.postTranslate(f5, -((float)n6 * var1_1 - (float)n6) / 2.0f);
        scaleImageView.mMatrix.postTranslate((float)(-(var2_2 - this.mWidth / 2)) * var1_1, 0.0f);
        scaleImageView.mMatrix.postTranslate(0.0f, (float)(-(var3_3 - this.mHeight / 2)) * var1_1);
        scaleImageView.setImageMatrix(scaleImageView.mMatrix);
    }

    public void cutting() {
        int n5;
        ScaleImageView scaleImageView = this;
        int n6 = (int)((float)scaleImageView.mIntrinsicWidth * this.getScale());
        int n7 = (int)((float)scaleImageView.mIntrinsicHeight * this.getScale());
        if (scaleImageView.getTranslateX() < (float)(-(n6 - this.mWidth))) {
            this.mMatrix.postTranslate(-(this.getTranslateX() + (float)n6 - (float)this.mWidth), 0.0f);
        }
        if (this.getTranslateX() > 0.0f) {
            this.mMatrix.postTranslate(-this.getTranslateX(), 0.0f);
        }
        if (this.getTranslateY() < (float)(-(n7 - this.mHeight))) {
            this.mMatrix.postTranslate(0.0f, -(this.getTranslateY() + (float)n7 - (float)this.mHeight));
        }
        if (this.getTranslateY() > 0.0f) {
            this.mMatrix.postTranslate(0.0f, -this.getTranslateY());
        }
        if (n6 < (n5 = this.mWidth)) {
            this.mMatrix.postTranslate((float)(n5 - n6) / 2.0f, 0.0f);
        }
        if (n7 < (n6 = this.mHeight)) {
            this.mMatrix.postTranslate(0.0f, (float)(n6 - n7) / 2.0f);
        }
        ScaleImageView scaleImageView2 = this;
        scaleImageView2.setImageMatrix(scaleImageView2.mMatrix);
    }

    /*
     * WARNING - void declaration
     */
    public boolean onTouchEvent(MotionEvent event) {
        block10: {
            int n5;
            void var1_4;
            block7: {
                block8: {
                    block9: {
                        if (this.mDetector.onTouchEvent((MotionEvent)var1_4)) {
                            return true;
                        }
                        void v02 = var1_4;
                        n5 = v02.getPointerCount();
                        int n6 = v02.getAction();
                        if (n6 == 0) break block7;
                        if (n6 == 1) break block8;
                        if (n6 == 2) break block9;
                        if (n6 == 5) break block7;
                        if (n6 == 6) break block8;
                        if (n6 == 261) break block7;
                        if (n6 == 262) break block8;
                        break block10;
                    }
                    if (n5 >= 2 && this.isScaling) {
                        ScaleImageView scaleImageView = this;
                        void v22 = var1_4;
                        float f5 = v22.getX(0);
                        float f6 = v22.getX(1);
                        float f7 = v22.getY(0);
                        float f8 = v22.getY(1);
                        this.mPrevDistance = f5 = scaleImageView.distance(f5, f6, f7, f8);
                        float f9 = (f5 - this.mPrevDistance) / this.dispDistance() + 1.0f;
                        ScaleImageView scaleImageView2 = this;
                        int n7 = scaleImageView2.mWidth / 2;
                        scaleImageView.zoomTo(f9 * f9, n7, scaleImageView2.mHeight / 2);
                        scaleImageView.cutting();
                    } else if (!this.isScaling) {
                        ScaleImageView scaleImageView = this;
                        ScaleImageView scaleImageView3 = this;
                        int n8 = scaleImageView3.mPrevMoveX - (int)var1_4.getX();
                        int n9 = scaleImageView3.mPrevMoveY - (int)var1_4.getY();
                        this.mPrevMoveX = (int)var1_4.getX();
                        scaleImageView.mPrevMoveY = (int)var1_4.getY();
                        scaleImageView.mMatrix.postTranslate((float)(-n8), (float)(-n9));
                        scaleImageView.cutting();
                    }
                    break block10;
                }
                if (var1_4.getPointerCount() <= 1) {
                    this.isScaling = false;
                }
                break block10;
            }
            if (n5 >= 2) {
                void v7 = var1_4;
                float f10 = v7.getX(0);
                float f11 = v7.getX(1);
                float f12 = v7.getY(0);
                float f13 = v7.getY(1);
                this.mPrevDistance = this.distance(f10, f11, f12, f13);
                this.isScaling = true;
            } else {
                this.mPrevMoveX = (int)var1_4.getX();
                this.mPrevMoveY = (int)var1_4.getY();
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean onTouch(View v4, MotionEvent event) {
        void var2_2;
        return super.onTouchEvent((MotionEvent)var2_2);
    }
}

