/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.encryption;

import android.os.Build;
import android.util.Base64;
import com.instabug.library.diagnostics.IBGDiagnostics;
import com.instabug.library.encryption.StaticKeyProvider;
import com.instabug.library.encryption.c;
import com.instabug.library.encryption.iv.a;
import com.instabug.library.util.InstabugSDKLogger;
import java.nio.charset.Charset;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0002\b\u0012\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00022\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u0007J\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00022\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u0007J\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00022\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u0007J\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u00022\b\u0010\u0003\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\u0007H\u0007J\u0014\u0010\t\u001a\u0004\u0018\u00010\u00022\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u0007J\u001c\u0010\t\u001a\u0004\u0018\u00010\u00022\b\u0010\u0003\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\u0007H\u0007J\u0010\u0010\u0006\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\nH\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\nH\u0007J\b\u0010\f\u001a\u00020\u000bH\u0002J\b\u0010\r\u001a\u00020\u000bH\u0002R\u0014\u0010\u000e\u001a\u00020\u00078\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00078\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u000fR\u0014\u0010\u0011\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0012R\u0014\u0010\u0014\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0012R\u0014\u0010\u0015\u001a\u00020\u00078\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u000fR\u0014\u0010\u0016\u001a\u00020\u00028\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0012R\u0017\u0010\u0017\u001a\u00020\n8\u0006\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001d"}, d2={"Lcom/instabug/library/encryption/EncryptionManager;", "", "", "data", "encryptWithStaticKey", "decryptWithStaticKey", "encrypt", "", "ivVersion", "decrypt", "", "Ljava/security/spec/AlgorithmParameterSpec;", "getIvSpec", "getIvSpecV2", "IV_V1", "I", "IV_V2", "AES_MODE", "Ljava/lang/String;", "ENCRYPTION_PREFIX", "ENCRYPTION_NEW_LINE_REPLACEMENT", "IV_LENGTH", "LINE_FEED", "iv", "[B", "getIv", "()[B", "<init>", "()V", "instabug-core_defaultUiRelease"})
public final class EncryptionManager {
    @NotNull
    public static final EncryptionManager INSTANCE = new EncryptionManager();
    public static final int IV_V1 = 1;
    public static final int IV_V2 = 2;
    @NotNull
    private static final String AES_MODE = "AES/GCM/NoPadding";
    @NotNull
    private static final String ENCRYPTION_PREFIX = "^instaEncrypted^";
    @NotNull
    private static final String ENCRYPTION_NEW_LINE_REPLACEMENT = "^instaLINE^";
    private static final int IV_LENGTH = 128;
    @NotNull
    public static final String LINE_FEED = "\n\r";
    @NotNull
    private static final byte[] iv;

    private EncryptionManager() {
    }

    @JvmStatic
    @Nullable
    public static final String encryptWithStaticKey(@Nullable String data) {
        String string2;
        if (data != null) {
            block8: {
                if (!StringsKt.startsWith$default((String)string2, (String)ENCRYPTION_PREFIX, (boolean)false, (int)2, null)) break block8;
                return string2;
            }
            Cipher cipher = Cipher.getInstance(AES_MODE);
            Cipher cipher2 = cipher;
            String string3 = string2;
            AlgorithmParameterSpec algorithmParameterSpec = INSTANCE.getIvSpec();
            try {
                cipher2.init(1, StaticKeyProvider.a(), algorithmParameterSpec);
                byte[] byArray = string3.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                byte[] byArray2 = cipher.doFinal(byArray);
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"cipher.doFinal(data.toByteArray())");
                String string4 = Base64.encodeToString((byte[])byArray2, (int)0);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"encodeToString(cipherText, Base64.DEFAULT)");
                return StringsKt.replace$default((String)string4, (String)"\n", (String)ENCRYPTION_NEW_LINE_REPLACEMENT, (boolean)false, (int)4, null);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                IBGDiagnostics.reportNonFatalAndLog(outOfMemoryError, "OOM while encrypting string, returning original string", "IBG-Core");
            }
            catch (Exception exception) {
                IBGDiagnostics.reportNonFatalAndLog(exception, "Error while encrypting string, returning original string", "IBG-Core");
            }
        } else {
            string2 = null;
        }
        return string2;
    }

    @JvmStatic
    @Nullable
    public static final String decryptWithStaticKey(@Nullable String data) {
        String string2;
        block12: {
            block11: {
                Object object;
                if (data == null) break block11;
                if (string2.length() == 0) {
                    return "";
                }
                Object object2 = StringsKt.replace$default((String)string2, (String)ENCRYPTION_NEW_LINE_REPLACEMENT, (String)"\n", (boolean)false, (int)4, null);
                try {
                    object = Base64.decode((String)object2, (int)0);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return object2;
                }
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"{\n                Base64\u2026          )\n            }");
                Cipher cipher = Cipher.getInstance(AES_MODE);
                Cipher cipher2 = cipher;
                byte[] byArray = object;
                object2 = INSTANCE.getIvSpec();
                cipher2.init(2, StaticKeyProvider.a(), (AlgorithmParameterSpec)object2);
                byte[] byArray2 = cipher.doFinal(byArray);
                object2 = byArray2;
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"decryptedBytes");
                Charset charset = Charset.forName("UTF-8");
                object = charset;
                try {
                    Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(\"UTF-8\")");
                    return new String((byte[])object2, (Charset)object);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    InstabugSDKLogger.e("IBG-Core", "OOM while decrypting string, returning original string");
                    IBGDiagnostics.reportNonFatal(outOfMemoryError, "OOM while decrypting string, returning original string");
                }
                catch (Exception exception) {
                    InstabugSDKLogger.e("IBG-Core", "Error while decrypting string, returning original string");
                    IBGDiagnostics.reportNonFatal(exception, "Error: " + exception.getMessage() + "while decrypting string, returning original string");
                }
                break block12;
            }
            string2 = null;
        }
        return string2;
    }

    @JvmStatic
    @Nullable
    public static final String encrypt(@Nullable String data) {
        return EncryptionManager.encrypt(data, 1);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @JvmStatic
    @Nullable
    public static final String encrypt(@Nullable String data, int ivVersion) {
        byte[] byArray;
        Object object;
        String string2;
        if (data == null) {
            return null;
        }
        try {
            void var1_1;
            if (StringsKt.startsWith$default((String)string2, (String)ENCRYPTION_PREFIX, (boolean)false, (int)2, null)) {
                return string2;
            }
            object = Cipher.getInstance(AES_MODE);
            AlgorithmParameterSpec algorithmParameterSpec = var1_1 == true ? INSTANCE.getIvSpec() : INSTANCE.getIvSpecV2();
            ((Cipher)object).init(1, c.a(), algorithmParameterSpec);
            byte[] byArray2 = string2.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
            byArray = ((Cipher)object).doFinal(byArray2);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            InstabugSDKLogger.e("IBG-Core", "OOM while encrypting string, returning original string");
            IBGDiagnostics.reportNonFatal(outOfMemoryError, "OOM while encrypting string, returning original string");
            return string2;
        }
        catch (Exception exception) {
            InstabugSDKLogger.e("IBG-Core", "Error while encrypting string, returning original string");
            IBGDiagnostics.reportNonFatal(exception, "Error: " + exception.getMessage() + "while encrypting string, returning original string");
            return string2;
        }
        object = byArray;
        {
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"cipher.doFinal(data.toByteArray())");
            StringBuilder stringBuilder = new StringBuilder().append(ENCRYPTION_PREFIX);
            String string3 = Base64.encodeToString((byte[])object, (int)0);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"encodeToString(cipherText, Base64.DEFAULT)");
            return stringBuilder.append(StringsKt.replace$default((String)string3, (String)"\n", (String)ENCRYPTION_NEW_LINE_REPLACEMENT, (boolean)false, (int)4, null)).toString();
        }
    }

    @JvmStatic
    @Nullable
    public static final String decrypt(@Nullable String data) {
        return EncryptionManager.decrypt(data, 1);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @JvmStatic
    @Nullable
    public static final String decrypt(@Nullable String data, int ivVersion) {
        Charset charset;
        byte[] byArray;
        byte[] byArray2;
        String string2;
        if (data == null) {
            return null;
        }
        if (string2.length() == 0) {
            return "";
        }
        boolean bl = false;
        if (bl) {
            return "";
        }
        if (!StringsKt.startsWith$default((String)string2, (String)ENCRYPTION_PREFIX, (boolean)false, (int)2, null)) {
            return string2;
        }
        String string3 = string2;
        Object object = string3.substring(16, string3.length());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        try {
            byArray2 = Base64.decode((String)StringsKt.replace$default((String)object, (String)ENCRYPTION_NEW_LINE_REPLACEMENT, (String)"\n", (boolean)false, (int)4, null), (int)0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return object;
        }
        {
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"{\n                Base64\u2026          )\n            }");
        }
        try {
            void var1_1;
            object = Cipher.getInstance(AES_MODE);
            AlgorithmParameterSpec algorithmParameterSpec = var1_1 == true ? INSTANCE.getIvSpec() : INSTANCE.getIvSpecV2();
            ((Cipher)object).init(2, c.a(), algorithmParameterSpec);
            byArray = ((Cipher)object).doFinal(byArray2);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            InstabugSDKLogger.e("IBG-Core", "OOM while decrypting string, returning original string");
            IBGDiagnostics.reportNonFatal(outOfMemoryError, "OOM while decrypting string, returning original string");
            return string2;
        }
        catch (Exception exception) {
            InstabugSDKLogger.e("IBG-Core", "Error while decrypting string, returning original string");
            IBGDiagnostics.reportNonFatal(exception, "Error: " + exception.getMessage() + "while decrypting string, returning original string");
            return string2;
        }
        object = byArray;
        {
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decryptedBytes");
            charset = Charset.forName("UTF-8");
        }
        {
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(\"UTF-8\")");
            return new String((byte[])object, charset);
        }
    }

    @JvmStatic
    @NotNull
    public static final byte[] encrypt(@NotNull byte[] data) throws Exception, OutOfMemoryError {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Cipher cipher = Cipher.getInstance(AES_MODE);
        cipher.init(1, c.a(), INSTANCE.getIvSpec());
        byte[] byArray2 = cipher.doFinal(byArray);
        try {
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"{\n            val cipher\u2026r.doFinal(data)\n        }");
            byArray = byArray2;
        }
        catch (Exception exception) {
            InstabugSDKLogger.e("IBG-Core", "Error while encrypting bytes");
        }
        return byArray;
    }

    @JvmStatic
    @NotNull
    public static final byte[] decrypt(@NotNull byte[] data) throws Exception, OutOfMemoryError {
        byte[] byArray;
        Cipher cipher;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        try {
            cipher = Cipher.getInstance(AES_MODE);
        }
        catch (Exception exception) {
            InstabugSDKLogger.e("IBG-Core", "Error while decrypting bytes");
            return byArray;
        }
        cipher.init(2, c.a(), INSTANCE.getIvSpec());
        byte[] byArray2 = cipher.doFinal(byArray);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"cipher.doFinal(data)");
        return byArray2;
    }

    private final AlgorithmParameterSpec getIvSpec() {
        Object object;
        if (Build.VERSION.SDK_INT > 19) {
            GCMParameterSpec gCMParameterSpec;
            object = gCMParameterSpec;
            gCMParameterSpec = new GCMParameterSpec(96, iv);
        } else {
            IvParameterSpec ivParameterSpec;
            object = ivParameterSpec;
            ivParameterSpec = new IvParameterSpec(iv);
        }
        return object;
    }

    private final synchronized AlgorithmParameterSpec getIvSpecV2() {
        AlgorithmParameterSpec algorithmParameterSpec;
        Object object = a.a();
        if (Build.VERSION.SDK_INT > 19) {
            GCMParameterSpec gCMParameterSpec;
            algorithmParameterSpec = gCMParameterSpec;
            gCMParameterSpec = new GCMParameterSpec(128, (byte[])object);
        } else {
            IvParameterSpec ivParameterSpec;
            algorithmParameterSpec = ivParameterSpec;
            ivParameterSpec = new IvParameterSpec((byte[])object);
        }
        return algorithmParameterSpec;
    }

    static {
        byte[] byArray = "RandomAESIv1".getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        iv = byArray;
    }

    @NotNull
    public final byte[] getIv() {
        return iv;
    }
}

