/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.networkv2;

import android.net.TrafficStats;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.instabug.library.IBGNetworkWorker;
import com.instabug.library.internal.servicelocator.CoreServiceLocator;
import com.instabug.library.networkv2.INetworkManager;
import com.instabug.library.networkv2.RequestResponse;
import com.instabug.library.networkv2.connection.FileDownloadConnectionManager;
import com.instabug.library.networkv2.connection.MultipartConnectionManager;
import com.instabug.library.networkv2.connection.NormalConnectionManager;
import com.instabug.library.networkv2.execptions.a;
import com.instabug.library.networkv2.request.Request;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.PoolProvider;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.security.SecureRandom;
import java.util.Random;

@Keep
public class NetworkManager
implements INetworkManager {
    private static final Random threadTagSeed = new SecureRandom(new byte[4]);
    @Nullable
    private OnDoRequestListener onDoRequestListener;

    public NetworkManager() {
    }

    /*
     * WARNING - void declaration
     */
    public NetworkManager(@Nullable OnDoRequestListener onDoRequestListener) {
        void var1_1;
        this.onDoRequestListener = var1_1;
    }

    public static boolean isOnline() {
        return com.instabug.library.networkv2.detectors.a.a.d();
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    private void doRequest(@IBGNetworkWorker @NonNull String workerThreadName, @NonNull com.instabug.library.networkv2.connection.a connectionManager, @NonNull Request request, Request.Callbacks<RequestResponse, Throwable> callback) {
        void var4_4;
        void var2_2;
        void var3_3;
        PoolProvider.getNetworkingSingleThreadExecutor(workerThreadName).execute(() -> this.lambda$doRequest$0((Request)var3_3, (com.instabug.library.networkv2.connection.a)var2_2, (Request.Callbacks)var4_4));
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    private void doRequestOnSameThread(@NonNull com.instabug.library.networkv2.connection.a connectionManager, @NonNull Request request, Request.Callbacks<RequestResponse, Throwable> callback) {
        void var3_3;
        void var1_1;
        void var2_2;
        this.handleRequest((Request)var2_2, (com.instabug.library.networkv2.connection.a)var1_1, (Request.Callbacks<RequestResponse, Throwable>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private void handleRequest(Request request, com.instabug.library.networkv2.connection.a connectionManager, Request.Callbacks<RequestResponse, Throwable> callback) {
        com.instabug.library.networkv2.utils.a.f(request);
        boolean bl = false;
        com.instabug.library.networkDiagnostics.manager.a a5 = CoreServiceLocator.getNetworkDiagnosticsManager();
        do {
            void var3_4;
            void var1_2;
            try {
                void var2_3;
                this.performRequest((Request)var1_2, (com.instabug.library.networkv2.connection.a)var2_3, (Request.Callbacks<RequestResponse, Throwable>)var3_4);
                break;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                if (var3_4 != null) {
                    var3_4.onFailed(outOfMemoryError);
                }
                a5.b();
            }
            catch (Exception exception) {
                if (var3_4 != null) {
                    var3_4.onFailed(exception);
                }
                a5.b();
            }
            catch (IOException iOException) {
                boolean bl2;
                block13: {
                    block12: {
                        long l5;
                        void v12;
                        bl2 = com.instabug.library.networkv2.utils.a.g((Request)var1_2);
                        if (!bl2) break block12;
                        try {
                            void v02 = var1_2;
                            v12 = v02;
                            l5 = com.instabug.library.networkv2.utils.a.b((Request)v02);
                        }
                        catch (InterruptedException interruptedException) {
                            throw new a(interruptedException, "Thread is interrupted while waiting for the next network request retry!");
                        }
                        InstabugSDKLogger.d("IBG-Core", "Request " + var1_2.getRequestUrl() + " failed to connect to network, retrying in " + l5 + " seconds.");
                        Thread.sleep(l5 * 1000L);
                        com.instabug.library.networkv2.utils.a.d((Request)v12);
                        break block13;
                    }
                    if (var3_4 != null) {
                        a5.b();
                        var3_4.onFailed(iOException);
                    }
                }
                bl = bl2;
            }
        } while (bl);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void performRequest(Request request, com.instabug.library.networkv2.connection.a connectionManager, Request.Callbacks<RequestResponse, Throwable> callback) throws Exception, OutOfMemoryError {
        void var1_5;
        Object object;
        block28: {
            void var3_8;
            Object this_;
            RequestResponse requestResponse;
            com.instabug.library.networkDiagnostics.manager.a a5;
            block27: {
                block26: {
                    object = ((NetworkManager)this_).onDoRequestListener;
                    if (object != null) {
                        object.onRequestStarted((Request)var1_5);
                    }
                    object = null;
                    a5 = CoreServiceLocator.getNetworkDiagnosticsManager();
                    try {
                        TrafficStats.setThreadStatsTag((int)threadTagSeed.nextInt());
                        object = requestResponse.create((Request)var1_5);
                        if (object != null) break block26;
                        if (object != null) {
                            ((HttpURLConnection)object).disconnect();
                        }
                        if (object == null) return;
                    }
                    catch (Throwable throwable) {
                        if (object != null) {
                            ((HttpURLConnection)object).disconnect();
                        }
                        if (object == null) throw throwable;
                        try {
                            if (((URLConnection)object).getInputStream() == null) throw throwable;
                            ((URLConnection)object).getInputStream().close();
                            throw throwable;
                        }
                        catch (Exception exception) {
                            try {
                                if (((HttpURLConnection)object).getErrorStream() == null) throw throwable;
                                ((HttpURLConnection)object).getErrorStream().close();
                                throw throwable;
                            }
                            catch (Exception exception2) {
                                InstabugSDKLogger.e("IBG-Core", "failed to close connection input stream for url " + var1_5.getRequestUrl(), exception);
                            }
                        }
                        throw throwable;
                    }
                    try {
                        if (((URLConnection)object).getInputStream() == null) return;
                        ((URLConnection)object).getInputStream().close();
                        return;
                    }
                    catch (Exception exception) {
                        try {
                            if (((HttpURLConnection)object).getErrorStream() == null) return;
                            ((HttpURLConnection)object).getErrorStream().close();
                            return;
                        }
                        catch (Exception exception3) {
                            InstabugSDKLogger.e("IBG-Core", "failed to close connection input stream for url " + var1_5.getRequestUrl(), exception);
                        }
                    }
                    return;
                }
                if (((HttpURLConnection)object).getResponseCode() < 400) break block27;
                this_ = requestResponse.handleServerError((HttpURLConnection)object);
                if (var3_8 != null) {
                    var3_8.onFailed(this_);
                }
                Object object2 = object;
                Object object3 = object2;
                a5.b();
                ((HttpURLConnection)object2).disconnect();
                try {
                    if (((URLConnection)object3).getInputStream() == null) return;
                    ((URLConnection)object).getInputStream().close();
                    return;
                }
                catch (Exception exception) {
                    try {
                        if (((HttpURLConnection)object).getErrorStream() == null) return;
                        ((HttpURLConnection)object).getErrorStream().close();
                        return;
                    }
                    catch (Exception exception4) {
                        InstabugSDKLogger.e("IBG-Core", "failed to close connection input stream for url " + var1_5.getRequestUrl(), exception);
                    }
                }
                return;
            }
            requestResponse = requestResponse.handleResponse((HttpURLConnection)object, (Request)var1_5);
            if (var3_8 != null) {
                var3_8.onSucceeded(requestResponse);
            }
            a5.d();
            this_ = ((NetworkManager)this_).onDoRequestListener;
            if (this_ == null) break block28;
            this_.onComplete();
        }
        Object object4 = object;
        ((HttpURLConnection)object4).disconnect();
        try {
            if (((URLConnection)object4).getInputStream() == null) return;
            ((URLConnection)object).getInputStream().close();
            return;
        }
        catch (Exception exception) {
            try {
                if (((HttpURLConnection)object).getErrorStream() == null) return;
                ((HttpURLConnection)object).getErrorStream().close();
                return;
            }
            catch (Exception exception5) {
                InstabugSDKLogger.e("IBG-Core", "failed to close connection input stream for url " + var1_5.getRequestUrl(), exception);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$doRequest$0(Request request, com.instabug.library.networkv2.connection.a connectionManager, Request.Callbacks callback) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.handleRequest((Request)var1_1, (com.instabug.library.networkv2.connection.a)var2_2, (Request.Callbacks<RequestResponse, Throwable>)var3_3);
    }

    @Override
    @Nullable
    public OnDoRequestListener getOnDoRequestListener() {
        return this.onDoRequestListener;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setOnDoRequestListener(@Nullable OnDoRequestListener onDoRequestListener) {
        void var1_1;
        this.onDoRequestListener = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @WorkerThread
    public void doRequest(@IBGNetworkWorker String ibgNetworkWorker, int requestType, @NonNull Request request, Request.Callbacks<RequestResponse, Throwable> callback) {
        void var3_3;
        if (NetworkManager.isOnline()) {
            void var4_4;
            void var1_1;
            Object object;
            void var2_2;
            if (var2_2 != true) {
                if (var2_2 != 2) {
                    if (var2_2 != 3) {
                        InstabugSDKLogger.e("IBG-Core", "undefined request type for " + var3_3.getRequestUrlForLogging());
                    } else {
                        FileDownloadConnectionManager fileDownloadConnectionManager;
                        Object object2 = object;
                        object = fileDownloadConnectionManager;
                        fileDownloadConnectionManager = new FileDownloadConnectionManager();
                        super.doRequest((String)var1_1, (com.instabug.library.networkv2.connection.a)object, (Request)var3_3, (Request.Callbacks<RequestResponse, Throwable>)var4_4);
                    }
                } else {
                    MultipartConnectionManager multipartConnectionManager;
                    NetworkManager networkManager = object;
                    object = multipartConnectionManager;
                    multipartConnectionManager = new MultipartConnectionManager();
                    networkManager.doRequest((String)var1_1, (com.instabug.library.networkv2.connection.a)object, (Request)var3_3, (Request.Callbacks<RequestResponse, Throwable>)var4_4);
                }
            } else {
                NormalConnectionManager normalConnectionManager;
                NetworkManager networkManager = object;
                object = normalConnectionManager;
                normalConnectionManager = new NormalConnectionManager();
                networkManager.doRequest((String)var1_1, (com.instabug.library.networkv2.connection.a)object, (Request)var3_3, (Request.Callbacks<RequestResponse, Throwable>)var4_4);
            }
        } else {
            InstabugSDKLogger.d("IBG-Core", "Device internet is disabled, can't make request: " + var3_3.getEndpoint());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @WorkerThread
    public void doRequestOnSameThread(int requestType, @NonNull Request request, Request.Callbacks<RequestResponse, Throwable> callback) {
        void var2_2;
        if (NetworkManager.isOnline()) {
            void var3_3;
            Object object;
            void var1_1;
            if (var1_1 != true) {
                if (var1_1 != 2) {
                    if (var1_1 != 3) {
                        InstabugSDKLogger.e("IBG-Core", "undefined request type for " + var2_2.getRequestUrlForLogging());
                    } else {
                        FileDownloadConnectionManager fileDownloadConnectionManager;
                        Object object2 = object;
                        object = fileDownloadConnectionManager;
                        fileDownloadConnectionManager = new FileDownloadConnectionManager();
                        super.doRequestOnSameThread((com.instabug.library.networkv2.connection.a)object, (Request)var2_2, (Request.Callbacks<RequestResponse, Throwable>)var3_3);
                    }
                } else {
                    MultipartConnectionManager multipartConnectionManager;
                    NetworkManager networkManager = object;
                    object = multipartConnectionManager;
                    multipartConnectionManager = new MultipartConnectionManager();
                    networkManager.doRequestOnSameThread((com.instabug.library.networkv2.connection.a)object, (Request)var2_2, (Request.Callbacks<RequestResponse, Throwable>)var3_3);
                }
            } else {
                NormalConnectionManager normalConnectionManager;
                NetworkManager networkManager = object;
                object = normalConnectionManager;
                normalConnectionManager = new NormalConnectionManager();
                networkManager.doRequestOnSameThread((com.instabug.library.networkv2.connection.a)object, (Request)var2_2, (Request.Callbacks<RequestResponse, Throwable>)var3_3);
            }
        } else {
            InstabugSDKLogger.d("IBG-Core", "Device internet is disabled, can't make request: " + var2_2.getEndpoint());
        }
    }

    public static interface OnDoRequestListener {
        public void onRequestStarted(Request var1);

        public void onStart();

        public void onComplete();
    }
}

