/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.core.plugin;

import android.content.Context;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.library.Instabug;
import com.instabug.library.core.plugin.PluginPromptOption;
import com.instabug.library.internal.dataretention.d;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public abstract class Plugin {
    public static final int STATE_BACKGROUND = 0;
    public static final int STATE_FOREGROUND = 1;
    public static final int STATE_PROCESSING_ATTACHMENT = 2;
    @Nullable
    protected WeakReference<Context> contextWeakReference;
    protected int state = 0;
    private int lifeCycleState = -1;

    private boolean canStop() {
        int n5 = this.lifeCycleState;
        return n5 == 4 || n5 == 2 || n5 == 3;
    }

    private boolean canStart() {
        int n5 = this.lifeCycleState;
        return n5 == 1 || n5 == 5;
    }

    private boolean canWake() {
        int n5 = this.lifeCycleState;
        return n5 == 2 || n5 == 4;
    }

    private boolean canSleep() {
        return this.lifeCycleState == 3;
    }

    /*
     * WARNING - void declaration
     */
    @CallSuper
    public void init(Context context) {
        void var1_1;
        WeakReference<void> weakReference;
        Plugin plugin = this_;
        WeakReference<void> this_ = weakReference;
        weakReference = new WeakReference<void>(var1_1);
        plugin.contextWeakReference = this_;
        plugin.lifeCycleState = 1;
    }

    public abstract void wake();

    public abstract void sleep();

    public abstract void stop();

    public abstract void start(Context var1);

    void wakeIfPossible() {
        if (this.canWake()) {
            this.wake();
            this.lifeCycleState = 3;
        }
    }

    void sleepIfPossible() {
        if (this.canSleep()) {
            this.sleep();
            this.lifeCycleState = 4;
        }
    }

    void stopIfPossible() {
        if (this.canStop()) {
            this.stop();
            this.lifeCycleState = 5;
        }
    }

    /*
     * WARNING - void declaration
     */
    void startIfPossible(Context context) {
        if (this.canStart()) {
            void var1_1;
            this.start((Context)var1_1);
            this.lifeCycleState = 2;
        }
    }

    public abstract long getLastActivityTime();

    public void onLocaleChanged(Locale oldLocale, Locale newLocale) {
    }

    public void initDefaultPromptOptionAvailabilityState() {
    }

    @Nullable
    public ArrayList<PluginPromptOption> getPromptOptions() {
        return null;
    }

    @Nullable
    public ArrayList<PluginPromptOption> getPluginOptions(boolean ignoreBaseFeature) {
        return null;
    }

    @NonNull
    public List<d> getDataDisposalPolicies() {
        return Collections.emptyList();
    }

    public int getState() {
        return this.state;
    }

    /*
     * WARNING - void declaration
     */
    public void setState(int state) {
        void var1_1;
        this.state = var1_1;
    }

    @Nullable
    public Context getAppContext() {
        return Instabug.getApplicationContext();
    }

    public boolean isAppContextAvailable() {
        WeakReference<Context> this_ = ((Plugin)((Object)this_)).contextWeakReference;
        return this_ != null && this_.get() != null;
    }

    public void invoke(PluginPromptOption pluginPromptOption) {
    }

    public abstract boolean isFeatureEnabled();
}

