/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.encryption;

import androidx.annotation.VisibleForTesting;
import com.instabug.library.diagnostics.IBGDiagnostics;
import com.instabug.library.util.InstabugSDKLogger;
import java.security.Key;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\n\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u0007J\t\u0010\u0005\u001a\u00020\u0004H\u0087 \u00a8\u0006\b"}, d2={"Lcom/instabug/library/encryption/StaticKeyProvider;", "", "Ljava/security/Key;", "a", "", "getKeyString", "<init>", "()V", "instabug-core_defaultUiRelease"})
public final class StaticKeyProvider {
    public static final StaticKeyProvider a = new StaticKeyProvider();

    private StaticKeyProvider() {
    }

    public static final Key a() {
        SecretKeySpec secretKeySpec;
        SecretKeySpec secretKeySpec2 = secretKeySpec;
        try {
            byte[] byArray = StaticKeyProvider.getKeyString().getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            secretKeySpec = new SecretKeySpec(byArray, "AES");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            InstabugSDKLogger.e("IBG-Core", "Error loading native library while getting static encryption key");
            secretKeySpec2 = null;
        }
        return secretKeySpec2;
    }

    @JvmStatic
    @VisibleForTesting
    @NotNull
    public static final native String getKeyString();

    static {
        try {
            System.loadLibrary("ibg-native");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            InstabugSDKLogger.e("IBG-Core", "Error loading native library while getting static encryption key");
            IBGDiagnostics.reportNonFatal(unsatisfiedLinkError, "Error loading native library");
        }
    }
}

