/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util.threading;

import android.content.Context;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.instabug.library.Instabug;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.DefensiveRunnableKt;
import com.instabug.library.util.threading.MainThreadExecutor;
import com.instabug.library.util.threading.OrderedExecutorService;
import com.instabug.library.util.threading.PriorityThreadFactory;
import com.instabug.library.util.threading.ReturnableSingleThreadExecutor;
import com.instabug.library.util.threading.SingleThreadPoolExecutor;
import com.instabug.library.util.threading.a;
import com.instabug.library.util.threading.e;
import com.instabug.library.util.threading.f;
import com.instabug.library.util.threading.g;
import com.instabug.library.util.threading.i;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class PoolProvider {
    public static final int NUMBER_OF_CORES = Runtime.getRuntime().availableProcessors();
    private static final int NUMBER_OF_THREADS_FOR_SCHEDULED_EXECUTOR = 4;
    private static PoolProvider INSTANCE;
    private static final Map<String, SingleThreadPoolExecutor> singleThreadPoolExecutorhMap;
    private static final Map<String, ReturnableSingleThreadExecutor> returnableSingleThreadPoolExecutorhMap;
    private static final Map<String, f> networkingSingleThreadExecutorMap;
    private static final Map<String, e> monitoredSingleThreadExecutorMap;
    private final ThreadPoolExecutor forIOTasks;
    private final ScheduledThreadPoolExecutor forScheduledTasks;
    private final Executor mainThreadExecutor;
    private final OrderedExecutorService orderedExecutor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized PoolProvider getInstance() {
        if (INSTANCE == null) {
            Class<PoolProvider> clazz = PoolProvider.class;
            synchronized (PoolProvider.class) {
                INSTANCE = new PoolProvider();
            }
        }
        return INSTANCE;
    }

    @Nullable
    public static Context getContext() {
        try {
            return Instabug.getApplicationContext();
        }
        catch (IllegalStateException illegalStateException) {
            return null;
        }
    }

    private PoolProvider() {
        a a5;
        MainThreadExecutor mainThreadExecutor;
        PriorityThreadFactory priorityThreadFactory;
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
        PriorityThreadFactory priorityThreadFactory2;
        LinkedBlockingQueue<Runnable> linkedBlockingQueue;
        ThreadPoolExecutor threadPoolExecutor;
        ThreadPoolExecutor this_ = threadPoolExecutor;
        int n5 = NUMBER_OF_CORES;
        int n6 = n5 * 2;
        Object object = TimeUnit.SECONDS;
        LinkedBlockingQueue<Runnable> linkedBlockingQueue2 = linkedBlockingQueue;
        linkedBlockingQueue = new LinkedBlockingQueue<Runnable>();
        PriorityThreadFactory priorityThreadFactory3 = priorityThreadFactory2;
        priorityThreadFactory2 = new PriorityThreadFactory("core-io-executor", 10);
        threadPoolExecutor = new ThreadPoolExecutor(n6, n5 * 2, 10L, (TimeUnit)((Object)object), (BlockingQueue<Runnable>)linkedBlockingQueue2, priorityThreadFactory3);
        v4.forIOTasks = this_;
        Executor executor = scheduledThreadPoolExecutor;
        object = priorityThreadFactory;
        priorityThreadFactory = new PriorityThreadFactory("core-scheduled-executor", 10);
        scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(4, (ThreadFactory)object);
        v4.forScheduledTasks = executor;
        executor = mainThreadExecutor;
        mainThreadExecutor = new MainThreadExecutor();
        v4.mainThreadExecutor = executor;
        executor = a5;
        a5 = new a(this_);
        v4.orderedExecutor = executor;
    }

    public static void postIOTask(Runnable runnable) {
        Runnable runnable2;
        PoolProvider.getInstance().orderedExecutor.execute(() -> {
            Throwable throwable;
            if (PoolProvider.getContext() == null) {
                return;
            }
            try {
                throwable.run();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                if (throwable2 instanceof OutOfMemoryError) {
                    InstabugSDKLogger.e("IBG-Core", "low memory, can't run i/o task", throwable);
                }
                InstabugSDKLogger.e("IBG-Core", "Error while running IO task", throwable);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public static void postOrderedIOTask(@NonNull String key, Runnable runnable) {
        void var1_1;
        Runnable runnable2;
        Runnable runnable3;
        String string2 = runnable3;
        runnable3 = runnable2;
        runnable2 = new Runnable((Runnable)var1_1){
            final /* synthetic */ Runnable a;
            {
                this.a = runnable;
            }

            @Override
            public void run() {
                if (PoolProvider.getContext() == null) {
                    return;
                }
                try {
                    this.a.run();
                }
                catch (Throwable throwable) {
                    if (throwable instanceof OutOfMemoryError) {
                        InstabugSDKLogger.e("IBG-Core", "low memory, can't run i/o task", throwable);
                    }
                    InstabugSDKLogger.e("IBG-Core", "Error while running IO task", throwable);
                }
            }
        };
        PoolProvider.getInstance().orderedExecutor.execute(string2, runnable3);
    }

    public static void postIOTaskWithCheck(Runnable runnable) {
        Runnable runnable2;
        if (Looper.myLooper() == Looper.getMainLooper()) {
            PoolProvider.postIOTask(runnable2);
        } else {
            runnable2.run();
        }
    }

    public static <T> Future<T> submitIOTask(Callable<T> callable) {
        Callable<T> callable2;
        return PoolProvider.getInstance().forIOTasks.submit(callable2);
    }

    /*
     * WARNING - void declaration
     */
    public static void postDelayedTask(Runnable runnable, long delayMillis) {
        void var1_1;
        Object object;
        Runnable runnable2 = new Runnable((Runnable)object){
            final /* synthetic */ Runnable a;
            {
                this.a = runnable;
            }

            @Override
            public void run() {
                if (PoolProvider.getContext() == null) {
                    return;
                }
                try {
                    this.a.run();
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    InstabugSDKLogger.e("IBG-Core", "low memory, can't run delayed task", outOfMemoryError);
                }
            }
        };
        object = TimeUnit.MILLISECONDS;
        PoolProvider.getInstance().forScheduledTasks.schedule(runnable2, (long)var1_1, (TimeUnit)((Object)object));
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static ScheduledFuture<?> postDelayedTaskAtFixedDelay(long initialDelay, long delayMillis, @NonNull Runnable command) {
        void var2_3;
        long l5;
        void var4_2;
        TimeUnit timeUnit = TimeUnit.MILLISECONDS;
        return PoolProvider.getInstance().forScheduledTasks.scheduleWithFixedDelay(() -> PoolProvider.lambda$postDelayedTaskAtFixedDelay$1((Runnable)var4_2), l5, (long)var2_3, timeUnit);
    }

    public static void postMainThreadTaskWithoutCheck(Runnable runnable) {
        Runnable runnable2;
        PoolProvider.getInstance().mainThreadExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    runnable2.run();
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    InstabugSDKLogger.e("IBG-Core", "low memory, can't run main thread task", outOfMemoryError);
                }
            }
        });
    }

    public static void postMainThreadTask(Runnable runnable) {
        Runnable runnable2;
        PoolProvider.getInstance().mainThreadExecutor.execute(new Runnable(){

            @Override
            public void run() {
                if (PoolProvider.getContext() == null) {
                    return;
                }
                try {
                    runnable2.run();
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    InstabugSDKLogger.e("IBG-Core", "low memory, can't run main thread task", outOfMemoryError);
                }
            }
        });
    }

    public static <R> FutureTask<R> submitMainThreadTask(Callable<R> task) {
        Callable<R> callable;
        FutureTask<R> futureTask = new FutureTask<R>(callable);
        PoolProvider.postMainThreadTask(futureTask);
        return futureTask;
    }

    /*
     * WARNING - void declaration
     */
    public static void postTask(Executor executor, Runnable runnable) {
        void var1_1;
        Runnable runnable2;
        Runnable runnable3 = runnable2;
        runnable2 = new Runnable((Runnable)var1_1){
            final /* synthetic */ Runnable a;
            {
                this.a = runnable;
            }

            @Override
            public void run() {
                if (PoolProvider.getContext() == null) {
                    return;
                }
                try {
                    this.a.run();
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    InstabugSDKLogger.e("IBG-Core", "low memory, can't run task", outOfMemoryError);
                }
            }
        };
        executor.execute(runnable3);
    }

    public static Executor newBackgroundExecutor(String identifier) {
        String string2;
        PriorityThreadFactory priorityThreadFactory;
        LinkedBlockingQueue<Runnable> linkedBlockingQueue;
        int n5 = NUMBER_OF_CORES;
        int n6 = n5 * 2;
        int n7 = n5 * 2 + 1;
        TimeUnit timeUnit = TimeUnit.SECONDS;
        LinkedBlockingQueue<Runnable> linkedBlockingQueue2 = linkedBlockingQueue;
        linkedBlockingQueue = new LinkedBlockingQueue<Runnable>();
        PriorityThreadFactory priorityThreadFactory2 = priorityThreadFactory;
        priorityThreadFactory = new PriorityThreadFactory(string2, 10);
        return new ThreadPoolExecutor(n6, n7, 60L, timeUnit, linkedBlockingQueue2, priorityThreadFactory2);
    }

    public static synchronized Executor getSingleThreadExecutor(String identifier) {
        SingleThreadPoolExecutor singleThreadPoolExecutor;
        String string2;
        Map<String, SingleThreadPoolExecutor> map = singleThreadPoolExecutorhMap;
        if (map.containsKey(string2)) {
            return map.get(string2);
        }
        SingleThreadPoolExecutor singleThreadPoolExecutor2 = singleThreadPoolExecutor;
        singleThreadPoolExecutor2(string2);
        singleThreadPoolExecutor2.setIdentifier(string2).setThreadPoolIdleListener(new i(){

            /*
             * WARNING - void declaration
             */
            @Override
            public void a(String identifier) {
                if (identifier != null) {
                    void var1_1;
                    singleThreadPoolExecutorhMap.remove(var1_1);
                }
            }
        });
        map.put(string2, singleThreadPoolExecutor2);
        return singleThreadPoolExecutor;
    }

    public static synchronized Executor getNetworkingSingleThreadExecutor(String identifier) {
        return PoolProvider.getNetworkingSingleThreadExecutor(identifier, false);
    }

    /*
     * WARNING - void declaration
     */
    public static synchronized Executor getNetworkingSingleThreadExecutor(String identifier, boolean retryable) {
        f f5;
        void var1_1;
        String string2;
        Map<String, f> map = networkingSingleThreadExecutorMap;
        if (map.containsKey(string2)) {
            return map.get(string2);
        }
        if (var1_1 != false) {
            g g5;
            f5 = g5;
            g5 = new g(string2);
        } else {
            f f6;
            f5 = f6;
            f6 = new f(string2);
        }
        f5.setIdentifier(string2).setThreadPoolIdleListener(new i(){

            /*
             * WARNING - void declaration
             */
            @Override
            public void a(String identifier) {
                if (identifier != null) {
                    void var1_1;
                    singleThreadPoolExecutorhMap.remove(var1_1);
                }
            }
        });
        map.put(string2, f5);
        return f5;
    }

    public static synchronized ReturnableSingleThreadExecutor getReturnableSingleThreadExecutor(String identifier) {
        ReturnableSingleThreadExecutor returnableSingleThreadExecutor;
        String string2;
        Map<String, ReturnableSingleThreadExecutor> map = returnableSingleThreadPoolExecutorhMap;
        if (map.containsKey(string2)) {
            return map.get(string2);
        }
        ReturnableSingleThreadExecutor returnableSingleThreadExecutor2 = returnableSingleThreadExecutor;
        returnableSingleThreadExecutor2(string2);
        map.put(string2, returnableSingleThreadExecutor2);
        return returnableSingleThreadExecutor;
    }

    public static synchronized e getMonitoredSingleThreadExecutor(String identifier) {
        e e5;
        String string2;
        Map<String, e> map = monitoredSingleThreadExecutorMap;
        if (map.containsKey(string2)) {
            return map.get(string2);
        }
        e e6 = e5;
        e6();
        map.put(string2, e6);
        return e5;
    }

    public static Executor getUserActionsExecutor() {
        return PoolProvider.getSingleThreadExecutor("user-actions-executor");
    }

    public static synchronized Executor getSyncExecutor() {
        return PoolProvider.getSingleThreadExecutor("sync-Executor");
    }

    public static ReturnableSingleThreadExecutor getApiExecutor() {
        return PoolProvider.getReturnableSingleThreadExecutor("API-executor");
    }

    public static ReturnableSingleThreadExecutor getChatsCacheExecutor() {
        return PoolProvider.getReturnableSingleThreadExecutor("chats-cache-executor");
    }

    public static ReturnableSingleThreadExecutor getSurveysDBExecutor() {
        return PoolProvider.getReturnableSingleThreadExecutor("surveys-db-executor");
    }

    public static e getDatabaseExecutor() {
        return PoolProvider.getMonitoredSingleThreadExecutor("IBG-db-executor");
    }

    public static e getDiagnosticsDatabaseExecutor() {
        return PoolProvider.getMonitoredSingleThreadExecutor("IBG-diagnostics-db-executor");
    }

    public static ReturnableSingleThreadExecutor getFilesEncryptionExecutor() {
        return PoolProvider.getReturnableSingleThreadExecutor("Files-Encryption");
    }

    private static /* synthetic */ void lambda$postDelayedTaskAtFixedDelay$1(Runnable command) {
        Runnable runnable;
        if (PoolProvider.getContext() == null) {
            return;
        }
        DefensiveRunnableKt.runDefensive(runnable).run();
    }

    static {
        singleThreadPoolExecutorhMap = new HashMap<String, SingleThreadPoolExecutor>();
        returnableSingleThreadPoolExecutorhMap = new HashMap<String, ReturnableSingleThreadExecutor>();
        networkingSingleThreadExecutorMap = new HashMap<String, f>();
        monitoredSingleThreadExecutorMap = new HashMap<String, e>();
    }

    public ThreadPoolExecutor getBackgroundExecutor() {
        return this.forIOTasks;
    }

    public ThreadPoolExecutor getIOExecutor() {
        return this.forIOTasks;
    }

    public OrderedExecutorService getOrderedExecutor() {
        return this.orderedExecutor;
    }

    public ScheduledExecutorService getScheduledExecutor() {
        return this.forScheduledTasks;
    }

    public Executor getMainExecutor() {
        return this.mainThreadExecutor;
    }
}

