/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.provider.MediaStore;
import android.widget.ImageView;
import androidx.annotation.DrawableRes;
import androidx.annotation.IntRange;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.instabug.library.Instabug;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.diagnostics.IBGDiagnostics;
import com.instabug.library.internal.servicelocator.CoreServiceLocator;
import com.instabug.library.internal.storage.DiskUtils;
import com.instabug.library.internal.storage.ProcessedBytes;
import com.instabug.library.internal.storage.cache.AssetsCacheManager;
import com.instabug.library.model.AssetEntity;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.BitmapWorkerTask;
import com.instabug.library.util.DisplayUtils;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.PoolProvider;
import com.instabug.library.util.threading.ThreadUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BitmapUtils {
    private static final String ICON_FILE_PREFIX = "icon";

    @Nullable
    public static Bitmap getBitmapFromUri(@NonNull Uri uri) {
        Uri uri2;
        block3: {
            uri2 = null;
            if (Instabug.getApplicationContext() == null) break block3;
            try {
                Uri uri3;
                uri2 = uri3 = MediaStore.Images.Media.getBitmap((ContentResolver)Instabug.getApplicationContext().getContentResolver(), (Uri)uri3);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                InstabugSDKLogger.e("IBG-Core", "getBitmapFromFilePath returns null because of " + iOException.getMessage());
            }
        }
        return uri2;
    }

    /*
     * WARNING - void declaration
     */
    public static void compressBitmapAndSave(@NonNull Context context, @NonNull File originalImageFile) {
        void var1_1;
        if (context != null && var1_1 != null) {
            try {
                BitmapUtils.compressBitmapAndSave((File)var1_1);
            }
            catch (Throwable throwable) {
                IBGDiagnostics.reportNonFatalAndLog(throwable, "Error occur while compress images" + throwable.getMessage(), "IBG-Core");
            }
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    private static void compressBitmapAndSave(File originalImageFile) {
        var1_2 = v0;
        new BitmapFactory.Options().inJustDecodeBounds = true;
        v1 = new FileInputStream(var0);
        v2 = v1;
        BitmapFactory.decodeStream((InputStream)v1, null, (BitmapFactory.Options)var1_2);
        v2.close();
        var2_3 = 1;
        while (true) {
            if (var1_2.outWidth / var2_3 / 2 < 900) break;
            if (var1_2.outHeight / var2_3 / 2 < 900) break;
            var2_3 *= 2;
            continue;
            break;
        }
        var1_2 = v3;
        new BitmapFactory.Options().inSampleSize = var2_3;
        var2_4 = v4;
        var1_2 = BitmapFactory.decodeStream((InputStream)new FileInputStream(var0), null, (BitmapFactory.Options)var1_2);
        var3_5 = v5;
        v5 = new FileOutputStream(var0);
        if (var1_2 == null) ** GOTO lbl35
        v6 = var1_2;
        v7 = v6;
        v6.compress(BitmapUtils.getImageMimeType(var0), 100, (OutputStream)var3_5);
        try {
            v7.recycle();
lbl35:
            // 2 sources

            var3_5.close();
            var2_4.close();
        }
        catch (Exception var0_1) {
            var0_1.printStackTrace();
            InstabugSDKLogger.e("IBG-Core", "bitmap doesn't compressed correctly " + var0_1.getMessage());
        }
    }

    private static Bitmap.CompressFormat getImageMimeType(File file) {
        if (file.getName().contains("png")) {
            return Bitmap.CompressFormat.PNG;
        }
        return Bitmap.CompressFormat.JPEG;
    }

    public static void loadBitmap(String localPath, ImageView imageView) {
        String string2;
        Object[] objectArray;
        BitmapWorkerTask bitmapWorkerTask = new BitmapWorkerTask((ImageView)objectArray);
        Object[] objectArray2 = new String[1];
        objectArray = objectArray2;
        objectArray2[0] = string2;
        bitmapWorkerTask.execute(objectArray);
    }

    /*
     * WARNING - void declaration
     */
    public static void loadBitmapWithFallback(String localPath, ImageView imageView, @DrawableRes int fallbackDrawable) {
        String string2;
        void var2_2;
        Object[] objectArray;
        BitmapWorkerTask bitmapWorkerTask = new BitmapWorkerTask((ImageView)objectArray, (int)var2_2);
        Object[] objectArray2 = new String[1];
        objectArray = objectArray2;
        objectArray2[0] = string2;
        bitmapWorkerTask.execute(objectArray);
    }

    /*
     * WARNING - void declaration
     */
    public static void loadBitmap(String localPath, ImageView imageView, float targetWidth, float targetHeight) {
        String string2;
        void var3_3;
        void var2_2;
        Object[] objectArray;
        BitmapWorkerTask bitmapWorkerTask = new BitmapWorkerTask((ImageView)objectArray, (float)var2_2, (float)var3_3);
        Object[] objectArray2 = new String[1];
        objectArray = objectArray2;
        objectArray2[0] = string2;
        bitmapWorkerTask.execute(objectArray);
    }

    /*
     * WARNING - void declaration
     */
    public static void loadBitmap(@NonNull String localPath, ImageView imageView, BitmapWorkerTask.OnImageLoadedListener onImageLoadedListener) {
        String string2;
        void var2_2;
        Object[] objectArray;
        BitmapWorkerTask bitmapWorkerTask = new BitmapWorkerTask((ImageView)objectArray, (BitmapWorkerTask.OnImageLoadedListener)var2_2);
        Object[] objectArray2 = new String[1];
        objectArray = objectArray2;
        objectArray2[0] = string2;
        bitmapWorkerTask.execute(objectArray);
    }

    /*
     * WARNING - void declaration
     */
    public static void loadBitmap(String localPath, ImageView imageView, float targetWidth, float targetHeight, BitmapWorkerTask.OnImageLoadedListener onImageLoadedListener) {
        String string2;
        void var4_4;
        void var3_3;
        void var2_2;
        Object[] objectArray;
        BitmapWorkerTask bitmapWorkerTask = new BitmapWorkerTask((ImageView)objectArray, (float)var2_2, (float)var3_3, (BitmapWorkerTask.OnImageLoadedListener)var4_4);
        Object[] objectArray2 = new String[1];
        objectArray = objectArray2;
        objectArray2[0] = string2;
        bitmapWorkerTask.execute(objectArray);
    }

    public static Bitmap decodeSampledBitmapFromLocalPath(String imageFilePath) {
        String string2;
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)string2, (BitmapFactory.Options)options);
        options.inSampleSize = BitmapUtils.calculateInSampleSize(options);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeFile((String)imageFilePath, (BitmapFactory.Options)options);
    }

    public static int calculateInSampleSize(BitmapFactory.Options options) {
        BitmapFactory.Options options2;
        int n5 = options.outHeight;
        int n6 = options2.outWidth;
        int n7 = 1;
        int n8 = 500;
        int n9 = 500;
        if (n5 > n8 || n6 > n9) {
            int n10 = n6;
            n6 = n5 / 2;
            n5 = n10 / 2;
            while (n6 / n7 >= n8 && n5 / n7 >= n9) {
                n7 *= 2;
            }
        }
        return n7;
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    public static Uri saveBitmapAsPNG(Bitmap bitmap, int quality, File directory, String fileNamePrefix) throws IOException {
        void var1_1;
        BufferedOutputStream bufferedOutputStream;
        void var3_3;
        BufferedOutputStream bufferedOutputStream2;
        File file;
        Object object = file;
        file = new File((File)((Object)bufferedOutputStream2), (String)var3_3 + "_" + System.currentTimeMillis() + ".png");
        bufferedOutputStream2 = bufferedOutputStream;
        bufferedOutputStream = new BufferedOutputStream(new FileOutputStream((File)object));
        boolean bl = BitmapUtils.compressQuietly(bitmap, Bitmap.CompressFormat.PNG, (int)var1_1, bufferedOutputStream2);
        ((OutputStream)bufferedOutputStream2).close();
        object = Uri.fromFile((File)object);
        if (bl && object != null) {
            return object;
        }
        throw new IOException("Uri equal null");
    }

    /*
     * WARNING - void declaration
     */
    public static void saveBitmapAsPNG(Bitmap bitmap, int quality, File directory, String fileNamePrefix, OnSaveBitmapCallback callback) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        PoolProvider.postIOTask(() -> BitmapUtils.lambda$saveBitmapAsPNG$0(bitmap, (int)var1_1, (File)var2_2, (String)var3_3, (OnSaveBitmapCallback)var4_4));
    }

    /*
     * WARNING - void declaration
     */
    public static void saveBitmap(Bitmap bitmap, Context context, OnSaveBitmapCallback callback) {
        void var2_2;
        Bitmap bitmap2;
        PoolProvider.postIOTask(() -> BitmapUtils.lambda$saveBitmap$1(context, bitmap2, (OnSaveBitmapCallback)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public static void saveDrawableBitmap(Drawable drawable2, long currentTime, OnSaveBitmapCallback callback) {
        void var3_2;
        Drawable drawable3;
        void var1_1;
        if (drawable2 == null) {
            return;
        }
        PoolProvider.postIOTask(() -> BitmapUtils.lambda$saveDrawableBitmap$2((long)var1_1, drawable3, (OnSaveBitmapCallback)var3_2));
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    public static void loadBitmapForAsset(@Nullable Context context, String fileUrl, AssetEntity.AssetType type, OnBitmapReady onBitmapReady) {
        if (context != null) {
            void var3_3;
            void var2_2;
            void var1_1;
            Context context2;
            AssetsCacheManager.getAssetEntity(AssetsCacheManager.createEmptyEntity(context2, (String)var1_1, (AssetEntity.AssetType)var2_2), new AssetsCacheManager.OnDownloadFinished((OnBitmapReady)var3_3){
                final /* synthetic */ OnBitmapReady a;
                {
                    this.a = onBitmapReady;
                }

                /*
                 * WARNING - void declaration
                 */
                private static /* synthetic */ void a(AssetEntity assetEntity, OnBitmapReady onBitmapReady) {
                    void var1_1;
                    BitmapUtils.access$000(assetEntity, (OnBitmapReady)var1_1);
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void onSuccess(AssetEntity assetEntity) {
                    void var1_1;
                    InstabugSDKLogger.d("IBG-Core", "Asset Entity downloaded: " + var1_1.getFile().getPath());
                    if (ThreadUtils.isCurrentThreadMain()) {
                        PoolProvider.postIOTask(() -> c.a((AssetEntity)var1_1, this.a));
                    } else {
                        BitmapUtils.access$000((AssetEntity)var1_1, this.a);
                    }
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void onFailed(Throwable error) {
                    void var1_1;
                    InstabugSDKLogger.e("IBG-Core", "Asset Entity downloading got error", (Throwable)var1_1);
                    this.a.onBitmapFailedToLoad();
                }
            });
        }
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @WorkerThread
    private static void decodeBitmap(AssetEntity assetEntity, OnBitmapReady onBitmapReady) {
        AssetEntity assetEntity2;
        void var1_3;
        FileInputStream fileInputStream;
        FileInputStream fileInputStream2 = fileInputStream;
        void v12 = var1_3;
        FileInputStream fileInputStream3 = fileInputStream2;
        FileInputStream fileInputStream4 = fileInputStream3;
        fileInputStream3(assetEntity2.getFile());
        v12.onBitmapReady(BitmapFactory.decodeStream((InputStream)fileInputStream4));
        fileInputStream.close();
        return;
        catch (Throwable throwable) {
            try {
                fileInputStream2.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                try {
                    throwable.addSuppressed(throwable2);
                    throw throwable;
                }
                catch (IOException iOException) {
                    InstabugSDKLogger.e("IBG-Core", "Asset Entity downloading got FileNotFoundException error", iOException);
                    var1_3.onBitmapFailedToLoad();
                }
            }
        }
    }

    @WorkerThread
    @NonNull
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public static File getIconTargetDirectory(long currentTime) {
        long l5;
        File file = (File)CoreServiceLocator.getReproScreenshotsCacheDir().getCurrentSpanDirectory();
        return new File(file, "icon_" + l5 + ".png");
    }

    /*
     * WARNING - void declaration
     */
    private static void drawableToBitmap(Drawable drawable2, OnBitmapReady onBitmapReady) {
        void var1_1;
        Drawable drawable3;
        Context context;
        if (drawable2 instanceof BitmapDrawable && (context = ((BitmapDrawable)drawable3).getBitmap()) != null) {
            var1_1.onBitmapReady(BitmapUtils.resizeBitmap((Bitmap)context, 24.0f, 24.0f));
            return;
        }
        context = Instabug.getApplicationContext();
        if (context != null) {
            int n5 = DisplayUtils.dpToPxIntRounded(context.getResources(), 72);
            final int n6 = drawable3.getIntrinsicWidth();
            final int n7 = drawable3.getIntrinsicHeight();
            if (n6 <= n5 && n7 <= n5) {
                Canvas canvas;
                Bitmap bitmap = Bitmap.createBitmap((int)n6, (int)n7, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                final Canvas canvas2 = canvas;
                canvas = new Canvas(bitmap);
                if (drawable3.getConstantState() != null) {
                    drawable3 = drawable3.getConstantState().newDrawable();
                }
                PoolProvider.postMainThreadTask(new Runnable((OnBitmapReady)var1_1, bitmap){
                    final /* synthetic */ OnBitmapReady e;
                    final /* synthetic */ Bitmap f;
                    {
                        this.e = onBitmapReady;
                        this.f = bitmap;
                    }

                    @Override
                    public void run() {
                        d d5 = this;
                        d d6 = this;
                        int n5 = d6.canvas2.getWidth();
                        int n62 = d6.canvas2.getHeight();
                        d5.drawable3.setBounds(0, 0, n5, n62);
                        d5.drawable3.draw(canvas2);
                        d d7 = this;
                        int n72 = d7.n7;
                        OnBitmapReady onBitmapReady = d7.e;
                        Bitmap bitmap = d7.f;
                        PoolProvider.postIOTask(() -> {
                            void var3_4;
                            void var1_2;
                            int n5;
                            float[] fArray = BitmapUtils.access$100(n5, (int)var1_2);
                            float f5 = fArray[0];
                            onBitmapReady.onBitmapReady(BitmapUtils.resizeBitmap((Bitmap)var3_4, f5, fArray[1]));
                        });
                    }
                });
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static float[] getTargetDimensions(int realWidth, int realHeight) {
        void var1_1;
        int n5;
        float f5 = 24.0f;
        float[] fArray = new float[2];
        float[] fArray2 = fArray;
        fArray[0] = f5;
        fArray[1] = f5;
        if (realHeight > n5) {
            fArray2[0] = (float)n5 / (float)var1_1 * f5;
        } else if (var1_1 < n5) {
            fArray2[1] = (float)var1_1 / (float)n5 * f5;
        }
        return fArray2;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static Bitmap resizeBitmap(Bitmap bitmap, float targetWidth, float targetHeight) {
        Paint paint;
        Matrix matrix;
        Canvas canvas;
        Bitmap bitmap2;
        void var2_3;
        void var1_1;
        if (bitmap == null) {
            return null;
        }
        if (var1_1 == 0.0f && var2_3 == 0.0f) {
            return bitmap2;
        }
        Bitmap bitmap3 = Bitmap.createBitmap((int)((int)var1_1), (int)((int)var2_3), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        if (bitmap2.getWidth() < bitmap2.getHeight() && var1_1 > var2_3) {
            return bitmap2;
        }
        if (bitmap2.getWidth() > bitmap2.getHeight() && var1_1 < var2_3) {
            return bitmap2;
        }
        Canvas canvas2 = canvas;
        canvas = new Canvas(bitmap3);
        Matrix matrix2 = matrix;
        matrix = new Matrix();
        if (bitmap2.getWidth() < bitmap2.getHeight()) {
            matrix2.setScale((float)(var1_1 /= (float)bitmap2.getWidth()), (float)(var2_3 / (float)bitmap2.getHeight()));
        } else {
            void v22 = var1_1;
            var1_1 = var2_3 / (float)bitmap2.getHeight();
            matrix2.setScale((float)var1_1, (float)(v22 / (float)bitmap2.getWidth()));
        }
        Paint paint2 = paint;
        paint = new Paint();
        canvas2.drawBitmap(bitmap2, matrix2, paint2);
        return bitmap3;
    }

    /*
     * WARNING - void declaration
     */
    public static void saveBitmap(Bitmap bitmap, Uri imageUri, Context context, OnSaveBitmapCallback callback) {
        if (imageUri.getPath() != null) {
            void var3_3;
            Bitmap bitmap2;
            void var2_2;
            void var1_1;
            PoolProvider.postIOTask(() -> BitmapUtils.lambda$saveBitmap$3((Uri)var1_1, (Context)var2_2, bitmap2, (OnSaveBitmapCallback)var3_3));
        }
    }

    @WorkerThread
    public static Bitmap decryptBitmap(String path) {
        Object object = InstabugCore.decryptOnTheFly(path);
        if (((ProcessedBytes)object).isProcessSuccessful()) {
            byte[] byArray = ((ProcessedBytes)object).getFileBytes();
            return BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length);
        }
        object = Bitmap.Config.ARGB_8888;
        return Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)object);
    }

    /*
     * Exception decompiling
     */
    public static void maskBitmap(@Nullable Activity activity, Bitmap bitmap, @NonNull SettingsManager settingsManager, @Nullable Canvas canvas) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [25[UNCONDITIONALDOLOOP]], but top level block is 7[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    public static boolean compressQuietly(@NonNull Bitmap bitmap, @NonNull Bitmap.CompressFormat format, @IntRange(from=0L, to=100L) int quality, @NonNull OutputStream outputStream) {
        boolean bl;
        block4: {
            block3: {
                void var3_4;
                void var2_3;
                void var1_2;
                Bitmap bitmap2;
                try {
                    if (bitmap.isRecycled()) break block3;
                }
                catch (Exception exception) {
                    InstabugSDKLogger.e("IBG-Core", "Error while compressing bitmap " + exception.getMessage());
                    return false;
                }
                if (!bitmap2.compress((Bitmap.CompressFormat)var1_2, (int)var2_3, (OutputStream)var3_4)) break block3;
                bl = true;
                break block4;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static /* synthetic */ void lambda$saveBitmap$3(Uri imageUri, Context context, Bitmap bitmap, OnSaveBitmapCallback callback) {
        void var2_4;
        Uri uri;
        OutputStream outputStream;
        if (imageUri.getPath() == null) return;
        void v02 = outputStream;
        uri = Uri.fromFile((File)new File(uri.getPath()));
        outputStream = v02.getContentResolver().openOutputStream(uri);
        if (outputStream == null) return;
        final boolean bl = BitmapUtils.compressQuietly((Bitmap)var2_4, Bitmap.CompressFormat.PNG, 100, outputStream);
        try {
            void var3_5;
            new Handler(Looper.getMainLooper()).post(new Runnable((OnSaveBitmapCallback)var3_5, uri){
                final /* synthetic */ OnSaveBitmapCallback b;
                final /* synthetic */ Uri c;
                {
                    this.b = onSaveBitmapCallback;
                    this.c = uri;
                }

                @Override
                public void run() {
                    OnSaveBitmapCallback onSaveBitmapCallback;
                    if (bl && (onSaveBitmapCallback = this.b) != null) {
                        onSaveBitmapCallback.onSuccess(this.c);
                    }
                }
            });
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (fileNotFoundException.getMessage() == null) return;
            InstabugSDKLogger.e("IBG-Core", "Error while saving bitmap: " + fileNotFoundException.getMessage());
        }
        return;
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$saveDrawableBitmap$2(long currentTime, Drawable drawable2, OnSaveBitmapCallback callback) {
        void var3_4;
        OnBitmapReady onBitmapReady;
        long l5;
        Drawable drawable3 = drawable2;
        final File file = BitmapUtils.getIconTargetDirectory(l5);
        OnBitmapReady onBitmapReady2 = onBitmapReady;
        try {
            onBitmapReady = new OnBitmapReady((OnSaveBitmapCallback)var3_4){
                final /* synthetic */ OnSaveBitmapCallback b;
                {
                    this.b = onSaveBitmapCallback;
                }

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Unable to fully structure code
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void onBitmapReady(Bitmap bitmap) {
                    block15: {
                        block16: {
                            if (bitmap == null) {
                                return;
                            }
                            var2_5 = false;
                            var3_6 = null;
                            var4_7 = v0;
                            v1 = var1_4;
                            var4_7(new FileOutputStream(file));
                            var2_5 = BitmapUtils.compressQuietly((Bitmap)v1, Bitmap.CompressFormat.PNG, 100, var4_7);
                            v0.close();
                            catch (Throwable var0_1) {
                                var3_6 = var4_7;
                                break block15;
                            }
                            catch (IOException v2) {
                                var3_6 = var4_7;
                                ** GOTO lbl-1000
                            }
                            catch (IOException v3) {
                                InstabugSDKLogger.e("IBG-Core", "can't close BufferedOutputStream");
                            }
                            break block16;
                            catch (Throwable var0_2) {
                                break block15;
                            }
                            catch (IOException v4) {}
lbl-1000:
                            // 2 sources

                            {
                                InstabugSDKLogger.e("IBG-Core", "can't compress bitmap");
                                if (var3_6 == null) break block16;
                            }
                            {
                                var3_6.close();
                            }
                        }
                        var1_4 = Uri.fromFile((File)file);
                        if (var2_5 && var1_4 != null) {
                            this.b.onSuccess(var1_4);
                            return;
                        }
                        this.b.onError(new Throwable("Uri equal null"));
                        return;
                    }
                    if (var3_6 == null) throw var0_3;
                    try {
                        var3_6.close();
                        throw var0_3;
                    }
                    catch (IOException v5) {
                        InstabugSDKLogger.e("IBG-Core", "can't close BufferedOutputStream");
                    }
                    throw var0_3;
                }

                @Override
                public void onBitmapFailedToLoad() {
                }
            };
            BitmapUtils.drawableToBitmap(drawable3, onBitmapReady2);
        }
        catch (Exception exception) {
            var3_4.onError(exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$saveBitmap$1(Context context, Bitmap bitmap, OnSaveBitmapCallback callback) {
        void var2_4;
        Uri uri;
        BufferedOutputStream bufferedOutputStream;
        File file;
        Object object = DiskUtils.getInstabugInternalDirectory(context);
        File file2 = file;
        file = new File((File)object, "bug_" + System.currentTimeMillis() + "_.jpg");
        object = bufferedOutputStream;
        object(new FileOutputStream(file2));
        final boolean bl = BitmapUtils.compressQuietly((Bitmap)uri, Bitmap.CompressFormat.JPEG, 100, (OutputStream)object);
        ((OutputStream)bufferedOutputStream).close();
        uri = Uri.fromFile((File)file);
        try {
            new Handler(Looper.getMainLooper()).post(new Runnable((OnSaveBitmapCallback)var2_4){
                final /* synthetic */ OnSaveBitmapCallback c;
                {
                    this.c = onSaveBitmapCallback;
                }

                @Override
                public void run() {
                    Uri uri2;
                    if (bl && (uri2 = uri) != null) {
                        this.c.onSuccess(uri2);
                    } else {
                        this.c.onError(new Throwable("Uri equal null"));
                    }
                }
            });
        }
        catch (IOException iOException) {
            var2_4.onError(iOException);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$saveBitmapAsPNG$0(Bitmap bitmap, int quality, File directory, String fileNamePrefix, OnSaveBitmapCallback callback) {
        try {
            void var3_4;
            void var2_3;
            void var1_2;
            Bitmap bitmap2;
            callback.onSuccess(BitmapUtils.saveBitmapAsPNG(bitmap2, (int)var1_2, (File)var2_3, (String)var3_4));
        }
        catch (IOException iOException) {
            void var4_5;
            var4_5.onError(iOException);
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$000(AssetEntity x02, OnBitmapReady x12) {
        void var1_1;
        BitmapUtils.decodeBitmap(x02, (OnBitmapReady)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ float[] access$100(int x02, int x12) {
        void var1_1;
        return BitmapUtils.getTargetDimensions(x02, (int)var1_1);
    }

    @Keep
    public static interface OnBitmapReady {
        public void onBitmapReady(@Nullable Bitmap var1);

        public void onBitmapFailedToLoad();
    }

    public static interface OnSaveBitmapCallback {
        public void onSuccess(Uri var1);

        public void onError(Throwable var1);
    }
}

