/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.invocation;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.view.MotionEvent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.instabug.library.Feature;
import com.instabug.library.Instabug;
import com.instabug.library.InstabugState;
import com.instabug.library.InstabugStateProvider;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.eventbus.ActivityLifecycleSubscriber;
import com.instabug.library.core.eventbus.DefaultActivityLifeCycleEventHandler;
import com.instabug.library.core.plugin.PluginPromptOption;
import com.instabug.library.d;
import com.instabug.library.internal.servicelocator.CoreServiceLocator;
import com.instabug.library.invocation.InstabugInvocationEvent;
import com.instabug.library.invocation.InvocationSettings;
import com.instabug.library.invocation.c;
import com.instabug.library.invocation.invoker.FloatingButtonInvoker;
import com.instabug.library.invocation.invoker.f;
import com.instabug.library.invocation.invoker.g;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.PoolProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class InvocationManager
implements DefaultActivityLifeCycleEventHandler {
    private static InvocationManager INSTANCE;
    private InvocationSettings currentInvocationSettings;
    private AtomicReferenceArray<InstabugInvocationEvent> currentInstabugInvocationEvents;
    private List<com.instabug.library.invocation.invoker.a> currentInvokersList;
    @Nullable
    private AtomicReferenceArray<com.instabug.library.invocation.invoker.a> currentInvokers;
    @Nullable
    private AtomicReference<com.instabug.library.invocation.invoker.a> lastUsedInvoker;
    @VisibleForTesting
    @Nullable
    ActivityLifecycleSubscriber currentActivityLifeCycleSubscriber;
    private final com.instabug.library.invocation.b invocationManagerSubscribers;
    private AtomicBoolean isInvocationAvailable;
    @Nullable
    private AtomicReference<com.instabug.library.invocation.d> invocationRequestListenerImp;

    private InvocationManager() {
        InvocationManager invocationManager = this;
        invocationManager.currentInvokersList = new ArrayList<com.instabug.library.invocation.invoker.a>();
        invocationManager.lastUsedInvoker = new AtomicReference();
        invocationManager.currentActivityLifeCycleSubscriber = null;
        invocationManager.isInvocationAvailable = new AtomicBoolean(true);
        invocationManager.currentInvocationSettings = new InvocationSettings();
        this.currentInstabugInvocationEvents = new AtomicReferenceArray<InstabugInvocationEvent>(1);
        this.currentInstabugInvocationEvents.set(0, InstabugInvocationEvent.SHAKE);
        invocationManager.currentInvokers = new AtomicReferenceArray<com.instabug.library.invocation.invoker.a>(this.createInvokersList());
        this.invocationManagerSubscribers = new c(this);
        this.invocationManagerSubscribers.subscribe();
        invocationManager.subscribeToCurrentActivityLifeCycle();
        invocationManager.invocationRequestListenerImp = new AtomicReference<com.instabug.library.invocation.d>(new com.instabug.library.invocation.d());
    }

    @NonNull
    private com.instabug.library.invocation.invoker.a[] createInvokersList() {
        this.currentInvokersList = new ArrayList<com.instabug.library.invocation.invoker.a>();
        return this.currentInvokersList.toArray(new com.instabug.library.invocation.invoker.a[this.currentInvokersList.size()]);
    }

    /*
     * WARNING - void declaration
     */
    private void addToCurrentInvokers(com.instabug.library.invocation.invoker.a invoker) {
        void var1_1;
        this.currentInvokersList.add((com.instabug.library.invocation.invoker.a)var1_1);
        List<com.instabug.library.invocation.invoker.a> list = this.currentInvokersList;
        this.currentInvokers = new AtomicReferenceArray<com.instabug.library.invocation.invoker.a>(list.toArray(new com.instabug.library.invocation.invoker.a[list.size()]));
    }

    public static synchronized void init() {
        if (INSTANCE == null) {
            INSTANCE = new InvocationManager();
        } else if (!SettingsManager.getInstance().isInBackground()) {
            INSTANCE.listen();
        }
    }

    public static synchronized InvocationManager getInstance() {
        if (INSTANCE == null) {
            InvocationManager.init();
        }
        return INSTANCE;
    }

    private void subscribeToCurrentActivityLifeCycle() {
        if (this.currentActivityLifeCycleSubscriber == null) {
            this.currentActivityLifeCycleSubscriber = CoreServiceLocator.createActivityLifecycleSubscriber(this);
            this.currentActivityLifeCycleSubscriber.subscribe();
        }
    }

    private boolean isPromptOptionsAvailable() {
        return this.getAvailablePromptOptions().size() > 0;
    }

    @Nullable
    private FloatingButtonInvoker getFloatingButtonInvoker() {
        FloatingButtonInvoker floatingButtonInvoker = null;
        if (this.currentInvokers != null) {
            for (int i5 = 0; i5 < this.currentInvokers.length(); ++i5) {
                com.instabug.library.invocation.invoker.a a5 = this.currentInvokers.get(i5);
                if (!(a5 instanceof FloatingButtonInvoker)) continue;
                floatingButtonInvoker = (FloatingButtonInvoker)a5;
                break;
            }
        }
        return floatingButtonInvoker;
    }

    @VisibleForTesting
    @SuppressLint(value={"ERADICATE_FIELD_NOT_NULLABLE"})
    public static void tearDown() {
        INSTANCE = null;
    }

    public void getInvocationRequested() {
        AtomicReference<com.instabug.library.invocation.d> atomicReference = this.invocationRequestListenerImp;
        if (atomicReference != null && atomicReference.get() != null) {
            this.invocationRequestListenerImp.get().a();
        } else {
            InstabugSDKLogger.e("IBG-Core", "invocationRequestListenerImp == null ");
        }
    }

    public void release() {
        ActivityLifecycleSubscriber activityLifecycleSubscriber = ((InvocationManager)((Object)this_)).currentActivityLifeCycleSubscriber;
        if (activityLifecycleSubscriber != null) {
            activityLifecycleSubscriber.unsubscribe();
        }
        ((InvocationManager)((Object)this_)).invocationRequestListenerImp = null;
        com.instabug.library.invocation.b this_ = ((InvocationManager)((Object)this_)).invocationManagerSubscribers;
        if (this_ != null) {
            this_.unsubscribe();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setInstabugInvocationEvent(InstabugInvocationEvent ... instabugInvocationEvent) {
        int n5;
        void var1_1;
        if (instabugInvocationEvent == null) {
            InstabugSDKLogger.e("IBG-Core", "Passed invocation events has null value, no change will take effect to the previous set invocation events");
            return;
        }
        InvocationManager invocationManager = this;
        invocationManager.currentInstabugInvocationEvents = invocationManager.removeDuplicates((InstabugInvocationEvent[])var1_1);
        if (invocationManager.currentInvokers != null) {
            for (n5 = 0; n5 < this.currentInvokers.length(); ++n5) {
                this.currentInvokers.get(n5).sleep();
            }
            this.currentInvokers = new AtomicReferenceArray<com.instabug.library.invocation.invoker.a>(this.createInvokersList());
        }
        block7: for (n5 = 0; n5 < this.currentInstabugInvocationEvents.length(); ++n5) {
            Object object = this.currentInstabugInvocationEvents.get(n5);
            InstabugSDKLogger.v("IBG-Core", "set instabug invocation event: " + (Object)object);
            if (object == InstabugInvocationEvent.NONE && ((void)var1_1).length == 1) {
                this.currentInvokers = null;
                break;
            }
            if (this.currentInvokers == null) {
                this.currentInvokers = new AtomicReferenceArray<com.instabug.library.invocation.invoker.a>(this.createInvokersList());
            }
            Context context = Instabug.getApplicationContext();
            if (this.invocationRequestListenerImp == null) continue;
            switch (b.a[object.ordinal()]) {
                default: {
                    continue block7;
                }
                case 4: {
                    if (Build.VERSION.SDK_INT >= 34 || this.currentInvokers == null || this.invocationRequestListenerImp.get() == null) continue block7;
                    this.addToCurrentInvokers(new com.instabug.library.invocation.invoker.c(this.invocationRequestListenerImp.get()));
                    continue block7;
                }
                case 3: {
                    if (context != null && this.invocationRequestListenerImp.get() != null) {
                        g g5;
                        object = g5;
                        g5 = new g(context, this.invocationRequestListenerImp.get());
                        if (this.currentInvokers == null) continue block7;
                        this.addToCurrentInvokers((com.instabug.library.invocation.invoker.a)object);
                        continue block7;
                    }
                    InstabugSDKLogger.e("IBG-Core", "did not add TwoFingerSwipeLeftInvoker due to null appContext");
                    continue block7;
                }
                case 2: {
                    if (this.currentInvokers == null || this.invocationRequestListenerImp.get() == null) continue block7;
                    this.addToCurrentInvokers(new FloatingButtonInvoker(this.invocationRequestListenerImp.get()));
                    continue block7;
                }
                case 1: {
                    if (context != null && this.invocationRequestListenerImp.get() != null) {
                        f f5;
                        object = f5;
                        ((f)object)(context, this.invocationRequestListenerImp.get());
                        f5.a(this.currentInvocationSettings.getShakeThreshold());
                        if (this.currentInvokers == null) continue block7;
                        this.addToCurrentInvokers((com.instabug.library.invocation.invoker.a)object);
                        continue block7;
                    }
                    InstabugSDKLogger.e("IBG-Core", "did not add ShakeInvoker due to null appContext");
                }
            }
        }
        if (this.currentInvokers != null) {
            InvocationManager invocationManager2 = this;
            invocationManager2.setLastUsedInvoker(null);
            invocationManager2.listen();
        }
    }

    @VisibleForTesting
    AtomicReferenceArray<InstabugInvocationEvent> removeDuplicates(InstabugInvocationEvent[] events) {
        InstabugInvocationEvent[] instabugInvocationEventArray;
        HashSet<void> hashSet;
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        HashSet<void> hashSet2 = hashSet;
        hashSet = new HashSet<void>();
        int n5 = events.length;
        for (int i5 = 0; i5 < n5; ++i5) {
            void var5_5 = instabugInvocationEventArray[i5];
            if (hashSet2.contains(var5_5)) continue;
            arrayList2.add(var5_5);
            hashSet2.add(var5_5);
        }
        instabugInvocationEventArray = new InstabugInvocationEvent[arrayList2.size()];
        return new AtomicReferenceArray<InstabugInvocationEvent>(arrayList2.toArray(instabugInvocationEventArray));
    }

    @Nullable
    public InstabugInvocationEvent[] getCurrentInstabugInvocationEvents() {
        if (d.c().b((Object)"BUG_REPORTING") == Feature.State.DISABLED) {
            return null;
        }
        InstabugInvocationEvent[] instabugInvocationEventArray = (InstabugInvocationEvent[])com.instabug.library.invocation.util.a.a(this.currentInstabugInvocationEvents, InstabugInvocationEvent.class);
        if (instabugInvocationEventArray != null) {
            return Arrays.copyOf(instabugInvocationEventArray, this.currentInstabugInvocationEvents.length());
        }
        return null;
    }

    public InvocationSettings getCurrentInvocationSettings() {
        return this.currentInvocationSettings;
    }

    @Nullable
    List<com.instabug.library.invocation.invoker.a> getCurrentInvokers() {
        com.instabug.library.invocation.invoker.a[] this_ = (com.instabug.library.invocation.invoker.a[])com.instabug.library.invocation.util.a.a(this_.currentInvokers, com.instabug.library.invocation.invoker.a.class);
        if (this_ == null) {
            return null;
        }
        return Arrays.asList(this_);
    }

    @Nullable
    public com.instabug.library.invocation.invoker.a getLastUsedInvoker() {
        AtomicReference<com.instabug.library.invocation.invoker.a> this_ = ((InvocationManager)((Object)this_)).lastUsedInvoker;
        if (this_ == null) {
            return null;
        }
        return (com.instabug.library.invocation.invoker.a)this_.get();
    }

    /*
     * WARNING - void declaration
     */
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public void setLastUsedInvoker(@Nullable com.instabug.library.invocation.invoker.a lastUsedInvoker) {
        AtomicReference<com.instabug.library.invocation.invoker.a> this_ = ((InvocationManager)((Object)this_)).lastUsedInvoker;
        if (this_ != null) {
            void var1_1;
            this_.set((com.instabug.library.invocation.invoker.a)var1_1);
        }
    }

    public void listen() {
        if (Instabug.isEnabled() && this.isInvocationAvailable.get() && this.isPromptOptionsAvailable() && this.currentInvokers != null && InstabugCore.getTargetActivity() != null && InstabugCore.getRunningSession() != null && !SettingsManager.getInstance().isProcessingForeground()) {
            for (int i5 = 0; i5 < this.currentInvokers.length(); ++i5) {
                com.instabug.library.invocation.invoker.a a5 = this.currentInvokers.get(i5);
                if (a5.isActive()) continue;
                a5.listen();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void handle(MotionEvent motionEvent) {
        if (this.currentInvokers == null) {
            return;
        }
        if (((Object)((Object)InstabugStateProvider.getInstance().getState())).equals((Object)InstabugState.ENABLED) && !InstabugCore.isForegroundBusy()) {
            for (int i5 = 0; i5 < this.currentInvokers.length(); ++i5) {
                void var1_1;
                com.instabug.library.invocation.invoker.a a5 = this.currentInvokers.get(i5);
                if (!(a5 instanceof g)) continue;
                a5.handle(var1_1);
                break;
            }
        }
    }

    public void sleep() {
        if (this.currentInvokers != null) {
            for (int i5 = 0; i5 < this.currentInvokers.length(); ++i5) {
                com.instabug.library.invocation.invoker.a a5 = this.currentInvokers.get(i5);
                if (!a5.isActive()) continue;
                a5.sleep();
            }
        }
    }

    public void switchOffInvocation() {
        this.isInvocationAvailable.set(false);
    }

    public void switchOnInvocation() {
        this.isInvocationAvailable.set(true);
    }

    public ArrayList<PluginPromptOption> getAvailablePromptOptions() {
        return com.instabug.library.core.plugin.c.f();
    }

    @Override
    public void handleActivityResumed() {
        PoolProvider.postIOTask(() -> {
            InvocationManager invocationManager = this;
            synchronized (invocationManager) {
                invocationManager.listen();
                return;
            }
        });
    }

    @Override
    public void handleActivityPaused() {
        PoolProvider.postIOTask(() -> {
            InvocationManager invocationManager = this;
            synchronized (invocationManager) {
                invocationManager.sleep();
                return;
            }
        });
    }

    public void notifyPrimaryColorChanged() {
        if (Instabug.isEnabled() && this.currentInvokers != null) {
            for (int i5 = 0; i5 < this.currentInvokers.length(); ++i5) {
                com.instabug.library.invocation.invoker.a a5 = this.currentInvokers.get(i5);
                if (InstabugCore.getTargetActivity() == null || !(a5 instanceof FloatingButtonInvoker)) continue;
                PoolProvider.postMainThreadTask(new Runnable(this, a5){
                    final /* synthetic */ com.instabug.library.invocation.invoker.a a;
                    final /* synthetic */ InvocationManager b;
                    {
                        void var1_1;
                        this.b = var1_1;
                        this.a = a5;
                    }

                    @Override
                    public void run() {
                        a a5 = this;
                        a5.a.sleep();
                        a5.a.listen();
                    }
                });
            }
        }
    }

    public void notifyInvocationOptionChanged() {
        InvocationManager invocationManager = this;
        boolean bl = invocationManager.isPromptOptionsAvailable() ^ true;
        FloatingButtonInvoker floatingButtonInvoker = invocationManager.getFloatingButtonInvoker();
        if (floatingButtonInvoker != null) {
            if (bl) {
                floatingButtonInvoker.sleep();
            } else {
                floatingButtonInvoker.updateButtonLocation();
            }
        }
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public void show() {
        AtomicReference<Object> atomicReference;
        AtomicReference<com.instabug.library.invocation.d> atomicReference2 = ((InvocationManager)((Object)this_)).invocationRequestListenerImp;
        if (atomicReference2 != null && atomicReference2.get() != null) {
            ((InvocationManager)((Object)this_)).invocationRequestListenerImp.get().a();
        }
        InvocationManager invocationManager = this_;
        AtomicReference<Object> this_ = atomicReference;
        atomicReference = new AtomicReference<Object>(null);
        invocationManager.lastUsedInvoker = this_;
    }

    /*
     * WARNING - void declaration
     */
    public void invoke(int invocationMode) {
        AtomicReference<com.instabug.library.invocation.d> atomicReference = this.invocationRequestListenerImp;
        if (atomicReference != null && atomicReference.get() != null) {
            void var1_1;
            this.invocationRequestListenerImp.get().b((int)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void forceInvoke(int invocationMode) {
        AtomicReference<com.instabug.library.invocation.d> atomicReference = this.invocationRequestListenerImp;
        if (atomicReference != null && atomicReference.get() != null) {
            void var1_1;
            this.invocationRequestListenerImp.get().a((int)var1_1);
        }
    }
}

