/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.model.v3Session;

import android.content.Context;
import android.database.Cursor;
import androidx.annotation.VisibleForTesting;
import com.instabug.library.Instabug;
import com.instabug.library.core.eventbus.coreeventbus.IBGSdkCoreEvent;
import com.instabug.library.internal.storage.cache.dbv2.IBGContentValues;
import com.instabug.library.internal.storage.cache.dbv2.IBGCursor;
import com.instabug.library.model.common.Session;
import com.instabug.library.model.v3Session.IBGInMemorySession;
import com.instabug.library.model.v3Session.IBGSessionData;
import com.instabug.library.model.v3Session.e;
import com.instabug.library.model.v3Session.f;
import com.instabug.library.model.v3Session.m;
import com.instabug.library.model.v3Session.t;
import com.instabug.library.model.v3Session.v;
import com.instabug.library.model.v3Session.x;
import com.instabug.library.model.v3Session.y;
import com.instabug.library.model.v3Session.z;
import com.instabug.library.networkv2.request.Endpoints;
import com.instabug.library.networkv2.request.Request;
import com.instabug.library.networkv2.request.RequestParameter;
import com.instabug.library.sessionV3.configurations.c;
import com.instabug.library.util.DeviceStateProvider;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.extenstions.a;
import com.instabug.library.util.extenstions.b;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.UInt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

public final class IBGSessionMapper {
    @NotNull
    public static final IBGSessionMapper INSTANCE = new IBGSessionMapper();

    private IBGSessionMapper() {
    }

    /*
     * WARNING - void declaration
     */
    private final void addAppDataValues(IBGContentValues $this$addAppDataValues, m appData) {
        void var2_2;
        void var1_1;
        var1_1.put("app_token", var2_2.a(), false);
        var1_1.put("os", var2_2.e(), false);
        var1_1.put("device", var2_2.c(), false);
        var1_1.put("sdk_version", var2_2.g(), false);
        var1_1.put("app_version", var2_2.b(), false);
        var1_1.put("locale", var2_2.d(), false);
        $this$addAppDataValues.put("screen_size", var2_2.f(), false);
    }

    /*
     * WARNING - void declaration
     */
    private final void addUserDataValues(IBGContentValues $this$addUserDataValues, v userData) {
        void var2_2;
        void var1_1;
        var1_1.put("uuid", var2_2.f(), true);
        var1_1.put("user_events", var2_2.c(), false);
        var1_1.put("user_attributes", var2_2.a(), false);
        var1_1.put("user_email", var2_2.b(), false);
        String string2 = "user_name";
        String string3 = userData.d();
        if (string3 == null) {
            string3 = "";
        }
        var1_1.put(string2, string3, false);
        var1_1.put("users_page_enabled", a.a(var2_2.e()), false);
    }

    /*
     * WARNING - void declaration
     */
    private final void addStartTimeValues(IBGContentValues $this$addStartTimeValues, x startTime) {
        void var2_2;
        void var1_1;
        var1_1.put("background_start_time", var2_2.a(), false);
        var1_1.put("nano_start_time", var2_2.c(), false);
        $this$addStartTimeValues.put("foreground_start_time", var2_2.b(), false);
    }

    /*
     * WARNING - void declaration
     */
    private final void addStoreRatingData(IBGContentValues $this$addStoreRatingData, String ratingDialogDetection) {
        if (ratingDialogDetection != null) {
            void var2_2;
            void var1_1;
            var1_1.put("rating_dialog_detection", (String)var2_2, false);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final e getSession(IBGCursor $this$session) {
        void var1_1;
        IBGCursor iBGCursor = $this$session;
        void v12 = var1_1;
        long l10 = b.c((Cursor)v12, "session_serial");
        String string2 = b.e((Cursor)v12, "session_id");
        v v10 = ((IBGSessionMapper)((Object)x10)).getSessionUserData((IBGCursor)v12);
        m m10 = ((IBGSessionMapper)((Object)x10)).getAppData((IBGCursor)var1_1);
        y y10 = y.valueOf(b.e(iBGCursor, "stitching_state"));
        long l11 = b.c(iBGCursor, "duration");
        Object object = b.d(iBGCursor, "production_usage");
        object = object == null ? null : ((IBGSessionMapper)((Object)x10)).getToSessionProductionUsage((String)object);
        void v22 = var1_1;
        x x10 = ((IBGSessionMapper)((Object)x10)).getStatTime((IBGCursor)var1_1);
        boolean bl = b.a((Cursor)v22, "v2_session_sent");
        z z10 = z.valueOf(b.e((Cursor)v22, "sync_status"));
        int n10 = UInt.constructor-impl((int)((int)b.c((Cursor)v22, "session_random_id")));
        boolean bl2 = b.a((Cursor)v22, "sr_enabled");
        String string3 = b.d((Cursor)v22, "rating_dialog_detection");
        return new e(l10, string2, n10, v10, m10, y10, bl, x10, (t)object, l11, z10, bl2, string3, null);
    }

    private final v getSessionUserData(IBGCursor $this$sessionUserData) {
        IBGCursor iBGCursor = $this$sessionUserData;
        String string2 = b.e(iBGCursor, "uuid");
        String string3 = b.d(iBGCursor, "user_name");
        String string4 = b.d(iBGCursor, "user_email");
        boolean bl = b.a(iBGCursor, "users_page_enabled");
        String string5 = b.d(iBGCursor, "user_events");
        String string6 = b.d(iBGCursor, "user_attributes");
        return new v(string2, string3, string4, string6, bl, string5);
    }

    private final x getStatTime(IBGCursor $this$statTime) {
        IBGCursor iBGCursor = $this$statTime;
        long l10 = b.c(iBGCursor, "nano_start_time");
        long l11 = b.c(iBGCursor, "foreground_start_time");
        long l12 = b.c(iBGCursor, "background_start_time");
        return new x(l10, l12, l11);
    }

    private final m getAppData(IBGCursor $this$appData) {
        IBGCursor iBGCursor = $this$appData;
        String string2 = b.e(iBGCursor, "device");
        String string3 = b.d(iBGCursor, "sdk_version");
        String string4 = b.d(iBGCursor, "app_token");
        String string5 = b.d(iBGCursor, "app_version");
        String string6 = b.e(iBGCursor, "os");
        String string7 = b.d(iBGCursor, "locale");
        String string8 = b.d(iBGCursor, "screen_size");
        return new m(string4, string6, string2, string5, string3, string7, string8);
    }

    @VisibleForTesting
    public static /* synthetic */ void getAsJson$annotations(t t10) {
    }

    @VisibleForTesting
    public static /* synthetic */ void getToSessionProductionUsage$annotations(String string2) {
    }

    public static /* synthetic */ Request constructRequest$default(IBGSessionMapper iBGSessionMapper, f f10, c c10, int n10, Object object) {
        if ((n10 & 1) != 0) {
            c10 = com.instabug.library.sessionV3.di.f.r();
        }
        return iBGSessionMapper.constructRequest(f10, c10);
    }

    /*
     * WARNING - void declaration
     */
    private final Request.Builder addCommonKeys(Request.Builder $this$addCommonKeys, Map<String, ? extends Object> common) {
        void var1_1;
        for (Map.Entry entry : common.entrySet()) {
            var1_1.addParameter(new RequestParameter<Object>((String)entry.getKey(), INSTANCE.mapValueToJson(entry.getValue())));
        }
        return var1_1;
    }

    private final Request.Builder addSessions(Request.Builder $this$addSessions, List<? extends Map<String, ? extends Object>> sessions) {
        JSONArray jSONArray;
        RequestParameter<JSONArray> requestParameter;
        JSONArray jSONArray2;
        Iterator iterator;
        ArrayList<Map<String, Object>> arrayList;
        Object object = INSTANCE;
        ArrayList<Map<String, Object>> arrayList2 = arrayList;
        arrayList = new ArrayList<Map<String, Object>>(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)iterator), (int)10));
        iterator = sessions.iterator();
        while (iterator.hasNext()) {
            arrayList2.add(((IBGSessionMapper)object).mapSessionToJson((Map)iterator.next()));
        }
        void v12 = jSONArray2;
        object = requestParameter;
        jSONArray2 = jSONArray;
        jSONArray = new JSONArray(arrayList2);
        requestParameter = new RequestParameter<JSONArray>("ses", jSONArray2);
        v12.addParameter((RequestParameter)object);
        return v12;
    }

    private final Map<String, Object> mapSessionToJson(Map<String, ? extends Object> sessionMap) {
        Iterator<Map.Entry<String, ? extends Object>> iterator;
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList(iterator.size());
        for (Map.Entry<String, ? extends Object> entry : sessionMap.entrySet()) {
            arrayList2.add(TuplesKt.to((Object)entry.getKey(), (Object)INSTANCE.mapValueToJson(entry.getValue())));
        }
        return MapsKt.toMap((Iterable)arrayList2);
    }

    private final Object mapValueToJson(Object value) {
        IBGSessionMapper this_;
        IBGSessionMapper iBGSessionMapper;
        if (this_.isJsonArray(iBGSessionMapper)) {
            JSONArray jSONArray;
            this_ = jSONArray;
            jSONArray = new JSONArray(iBGSessionMapper.toString());
            iBGSessionMapper = this_;
        } else if (this_.isJsonObject(iBGSessionMapper)) {
            JSONObject jSONObject;
            this_ = jSONObject;
            jSONObject = new JSONObject(iBGSessionMapper.toString());
            iBGSessionMapper = this_;
        }
        return iBGSessionMapper;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isJsonArray(Object value) {
        void var1_1;
        return StringsKt.startsWith$default((String)value.toString(), (String)"[", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)var1_1.toString(), (String)"]", (boolean)false, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isJsonObject(Object value) {
        void var1_1;
        return StringsKt.startsWith$default((String)value.toString(), (String)"{", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)var1_1.toString(), (String)"}", (boolean)false, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final Request.Builder addDroppedSessionCount(Request.Builder $this$addDroppedSessionCount, c ibgSessionConfigurations) {
        void var1_2;
        int n10 = ibgSessionConfigurations.b();
        if (n10 > 0) {
            InstabugSDKLogger.w("IBG-Core", n10 + " sessions have been dropped due to reaching sessions storage limit. Please contact support for more information.");
            var1_2.addParameter(new RequestParameter<Integer>("dsc", n10));
        }
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    private final Request.Builder addDebugMode(Request.Builder $this$addDebugMode, c ibgSessionConfigurations) {
        void var1_1;
        if (ibgSessionConfigurations.d()) {
            RequestParameter<Boolean> requestParameter;
            RequestParameter<String> requestParameter2;
            void v02 = var1_1;
            Object object = requestParameter2;
            requestParameter2 = new RequestParameter<String>("IBG-APM-DEBUG-MODE", "true");
            v02.addHeader((RequestParameter<String>)object);
            object = requestParameter;
            requestParameter = new RequestParameter<Boolean>("dm", Boolean.TRUE);
            v02.addParameter((RequestParameter)object);
        }
        return var1_1;
    }

    private final Request.Builder addStaticData(Request.Builder $this$addStaticData) {
        RequestParameter<Object> requestParameter;
        RequestParameter<Object> requestParameter2;
        Request.Builder builder = $this$addStaticData;
        Context context = Instabug.getApplicationContext();
        Object object = DeviceStateProvider.getScreenDensity(context);
        RequestParameter<Object> requestParameter3 = requestParameter2;
        requestParameter2 = new RequestParameter<Object>("dst", object);
        ((Request.Builder)((Object)requestParameter3)).addParameter(requestParameter3);
        object = DeviceStateProvider.getAppPackageName(context);
        requestParameter3 = requestParameter;
        requestParameter = new RequestParameter<Object>("bid", object);
        builder.addParameter(requestParameter3);
        return builder;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Session toCoreSession(@NotNull e $this$toCoreSession) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)$this$toCoreSession, (String)"<this>");
        return new Session((e)var1_1){
            final /* synthetic */ e a;
            {
                this.a = e10;
            }

            @Override
            @NotNull
            public String getId() {
                return this.a.c();
            }

            @Override
            @NotNull
            public String getOs() {
                return this.a.a().e();
            }

            @Override
            @NotNull
            public String getUuid() {
                return this.a.l().f();
            }

            @Override
            @Nullable
            public String getAppVersion() {
                return this.a.a().b();
            }

            @Override
            public long getStartTimestampMicros() {
                return this.a.i().d();
            }

            @Override
            public long getStartNanoTime() {
                return this.a.i().c();
            }

            @Override
            @NotNull
            public String getVersion() {
                return "V3";
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IBGContentValues toContentValues(@NotNull e $this$toContentValues) {
        void var1_1;
        IBGContentValues iBGContentValues;
        e e10 = $this$toContentValues;
        Intrinsics.checkNotNullParameter((Object)e10, (String)"<this>");
        IBGContentValues iBGContentValues2 = iBGContentValues;
        iBGContentValues2();
        iBGContentValues2.put("session_id", var1_1.c(), true);
        iBGContentValues2.put("duration", var1_1.b(), false);
        iBGContentValues2.put("v2_session_sent", a.a(var1_1.m()), false);
        iBGContentValues2.put("stitching_state", var1_1.j().name(), false);
        iBGContentValues.put("sync_status", var1_1.k().name(), true);
        Object object = "production_usage";
        Object object2 = e10.d();
        object2 = object2 == null ? null : INSTANCE.getAsJson((t)object2);
        Object object3 = iBGContentValues2;
        iBGContentValues2.put((String)object, (String)object2, false);
        iBGContentValues2.put("session_random_id", (long)var1_1.e() & 0xFFFFFFFFL, true);
        ((IBGContentValues)object3).put("sr_enabled", a.a(var1_1.h()), true);
        object = INSTANCE;
        super.addStartTimeValues(iBGContentValues2, var1_1.i());
        super.addUserDataValues(iBGContentValues2, var1_1.l());
        super.addAppDataValues(iBGContentValues2, var1_1.a());
        ((IBGSessionMapper)object).addStoreRatingData(iBGContentValues2, var1_1.f());
        return object3;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final e toSession(@NotNull IBGCursor $this$toSession) {
        Object object;
        void var1_2;
        block6: {
            block5: {
                IBGCursor iBGCursor = $this$toSession;
                Intrinsics.checkNotNullParameter((Object)iBGCursor, (String)"<this>");
                IBGSessionMapper iBGSessionMapper = null;
                try {
                    object = iBGCursor.moveToNext() ? var1_2 : null;
                    if (object != null) break block5;
                    object = null;
                    break block6;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        CloseableKt.closeFinally((Closeable)var1_2, (Throwable)throwable);
                        throw throwable2;
                    }
                }
            }
            object = INSTANCE.getSession((IBGCursor)object);
        }
        CloseableKt.closeFinally((Closeable)var1_2, (Throwable)((Object)iBGSessionMapper));
        return object;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public final List<e> toSessionList(@NotNull IBGCursor $this$toSessionList) {
        void var1_2;
        ArrayList<e> arrayList;
        Intrinsics.checkNotNullParameter((Object)$this$toSessionList, (String)"<this>");
        IBGSessionMapper iBGSessionMapper = null;
        ArrayList<e> arrayList2 = arrayList;
        try {
            arrayList = new ArrayList<e>();
        }
        catch (Throwable throwable) {
            try {
                throw throwable;
            }
            catch (Throwable throwable2) {
                CloseableKt.closeFinally((Closeable)var1_2, (Throwable)throwable);
                throw throwable2;
            }
        }
        while (var1_2.moveToNext()) {
            arrayList2.add(INSTANCE.getSession((IBGCursor)var1_2));
        }
        CloseableKt.closeFinally((Closeable)var1_2, (Throwable)((Object)iBGSessionMapper));
        return arrayList2;
    }

    @NotNull
    public final String getAsJson(@NotNull t $this$asJson) {
        HashMap hashMap;
        t t10 = $this$asJson;
        Intrinsics.checkNotNullParameter((Object)t10, (String)"<this>");
        Object object = hashMap;
        hashMap = new HashMap();
        object = t10.a((Map)object);
        String string2 = new JSONObject((Map)object).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"hashMapOf<String, Any>()\u2026)\n            .toString()");
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final t getToSessionProductionUsage(@NotNull String $this$toSessionProductionUsage) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)$this$toSessionProductionUsage, (String)"<this>");
        JSONObject jSONObject = new JSONObject((String)var1_1);
        String string2 = jSONObject.optString("su", "other");
        boolean bl = jSONObject.optBoolean("pua", false);
        boolean bl2 = jSONObject.optBoolean("pub", false);
        boolean bl3 = jSONObject.optBoolean("puc", false);
        boolean bl4 = jSONObject.optBoolean("pufr", false);
        boolean bl5 = jSONObject.optBoolean("pus", false);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"optString(STORE_URL_KEY, DEFAULT_STORE_URL)");
        return new t(string2, bl2, bl5, bl4, bl, bl3);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Request constructRequest(@NotNull f $this$constructRequest, @NotNull c configurations) {
        void var2_2;
        void var1_1;
        IBGSessionMapper iBGSessionMapper = this_;
        IBGSessionMapper iBGSessionMapper2 = this_;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"configurations");
        Request.Builder builder = new Request.Builder().url(Endpoints.V3_SESSION).method("POST");
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"Builder().url(Endpoints.\u2026ethod(RequestMethod.POST)");
        Object this_ = ((IBGSessionMapper)this_).addDroppedSessionCount(builder, (c)var2_2);
        Request.Builder builder2 = iBGSessionMapper2.addCommonKeys((Request.Builder)this_, var1_1.a()).shorten(true);
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"Builder().url(Endpoints.\u2026           .shorten(true)");
        this_ = iBGSessionMapper2.addStaticData(builder2);
        return iBGSessionMapper.addDebugMode(iBGSessionMapper.addSessions((Request.Builder)this_, var1_1.b()), (c)var2_2).disableDefaultParameters(true).build();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Pair<String, JSONObject> getAsPair(@NotNull IBGSessionData $this$asPair) {
        void var1_1;
        IBGSessionData iBGSessionData = $this$asPair;
        Intrinsics.checkNotNullParameter((Object)iBGSessionData, (String)"<this>");
        return TuplesKt.to((Object)iBGSessionData.getFeatureKey(), (Object)var1_1.getFeatureData());
    }

    @NotNull
    public final IBGSdkCoreEvent.V3Session.V3StartedInForeground getAsForegroundStartEvent(@NotNull IBGInMemorySession $this$asForegroundStartEvent) {
        IBGInMemorySession iBGInMemorySession = $this$asForegroundStartEvent;
        Intrinsics.checkNotNullParameter((Object)iBGInMemorySession, (String)"<this>");
        long l10 = iBGInMemorySession.getStartTime().b();
        l10 = TimeUnit.MICROSECONDS.toMillis(l10);
        String string2 = iBGInMemorySession.getId();
        int n10 = iBGInMemorySession.getRandomID-pVg5ArA();
        return new IBGSdkCoreEvent.V3Session.V3StartedInForeground(l10, string2, n10, null);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String getCompositeSessionId(@NotNull IBGInMemorySession $this$getCompositeSessionId, @NotNull String appToken) {
        String string2;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"appToken");
        Object object = $this$getCompositeSessionId.getStartTime();
        if (((x)object).e()) {
            object = null;
        }
        if (object == null) {
            string2 = null;
        } else {
            long l10 = ((x)object).b();
            l10 = TimeUnit.MICROSECONDS.toMillis(l10);
            string2 = (String)var2_2 + '-' + l10 + '-' + UInt.toString-impl((int)var1_1.getRandomID-pVg5ArA());
        }
        return string2;
    }
}

