/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.storage.cache.db;

import android.annotation.SuppressLint;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.instabug.library.Instabug;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.diagnostics.IBGDiagnostics;
import com.instabug.library.util.InstabugSDKLogger;
import java.util.Arrays;

public class SQLiteDatabaseWrapper {
    @Nullable
    private SQLiteDatabase database;
    private final SQLiteOpenHelper databaseHelper;
    @Nullable
    private Boolean databaseTransactionsEnabled;

    /*
     * WARNING - void declaration
     */
    SQLiteDatabaseWrapper(SQLiteOpenHelper helper) {
        void var1_1;
        this.databaseHelper = var1_1;
    }

    private synchronized boolean isDatabaseTransactionsEnabled() {
        if (((SQLiteDatabaseWrapper)this).databaseTransactionsEnabled == null && Instabug.getApplicationContext() != null) {
            ((SQLiteDatabaseWrapper)this).databaseTransactionsEnabled = InstabugCore.isDatabaseTransactionDisabled(Instabug.getApplicationContext()) ^ true;
        }
        return (this = ((SQLiteDatabaseWrapper)this).databaseTransactionsEnabled) != null ? (Boolean)this : false;
    }

    /*
     * WARNING - void declaration
     */
    private synchronized void logOperationFailedWarning(String message) {
        SQLiteDatabaseWrapper this_ = this_.database;
        if (this_ == null) {
            InstabugSDKLogger.e("IBG-Core", "Attempted to do operation on an uninitialized database. Falling back silently");
        } else if (!this_.isOpen()) {
            InstabugSDKLogger.e("IBG-Core", "Attempted to do operation on a closed database. Falling back silently");
        } else {
            void var1_1;
            InstabugSDKLogger.e("IBG-Core", (String)var1_1 + " ,Falling back silently");
        }
    }

    void open() {
        block5: {
            SQLiteDatabase sQLiteDatabase = this.database;
            if (sQLiteDatabase == null) break block5;
            if (!sQLiteDatabase.isOpen()) break block5;
            return;
        }
        try {
            this.database = this.databaseHelper.getWritableDatabase();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            InstabugSDKLogger.e("IBG-Core", "Error while opening the DB: " + outOfMemoryError.getMessage(), outOfMemoryError);
            IBGDiagnostics.reportNonFatal(outOfMemoryError, "Error while opening the DB: " + outOfMemoryError.getMessage());
        }
        catch (Exception exception) {
            InstabugSDKLogger.e("IBG-Core", "Error while opening the DB: " + exception.getMessage(), exception);
            IBGDiagnostics.reportNonFatal(exception, "Error while opening the DB: " + exception.getMessage());
        }
    }

    public synchronized void close() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"ERADICATE_NULLABLE_DEREFERENCE"})
    public void beginTransaction() {
        try {
            SQLiteDatabase sQLiteDatabase = this.database;
            if (sQLiteDatabase != null && sQLiteDatabase.isOpen()) {
                if (!this.isDatabaseTransactionsEnabled()) return;
                this.database.beginTransaction();
                return;
            }
            this.logOperationFailedWarning("DB transaction failed");
            return;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            IBGDiagnostics.reportNonFatal(outOfMemoryError, "DB transaction failed due to: " + outOfMemoryError.getMessage());
            this.logOperationFailedWarning("\"DB transaction failed due to an Exception due to: " + outOfMemoryError.getMessage());
            return;
        }
        catch (Exception exception) {
            IBGDiagnostics.reportNonFatal(exception, "DB transaction failed due to: " + exception.getMessage());
            this.logOperationFailedWarning("DB transaction failed due to:" + exception.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public long insert(@NonNull String table, @Nullable String nullColumnHack, @NonNull ContentValues values) {
        try {
            SQLiteDatabase sQLiteDatabase = this.database;
            if (sQLiteDatabase != null && sQLiteDatabase.isOpen()) {
                void var3_5;
                void var2_4;
                void var1_1;
                return this.database.insert((String)var1_1, (String)var2_4, (ContentValues)var3_5);
            }
            this.logOperationFailedWarning("DB insertion failed");
            return -1L;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            IBGDiagnostics.reportNonFatal(outOfMemoryError, "DB insertion failed due to: " + outOfMemoryError.getMessage() + Arrays.toString(outOfMemoryError.getStackTrace()));
            this.logOperationFailedWarning("DB insertion failed due to: " + outOfMemoryError.getMessage() + Arrays.toString(outOfMemoryError.getStackTrace()));
            return -1L;
        }
        catch (Exception exception) {
            IBGDiagnostics.reportNonFatal(exception, "DB insertion failed due to: " + exception.getMessage() + Arrays.toString(exception.getStackTrace()));
            this.logOperationFailedWarning("DB insertion failed due to: " + exception.getMessage() + Arrays.toString(exception.getStackTrace()));
            return -1L;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public long insertWithOnConflict(@NonNull String tableName, @Nullable String nullColumnHack, @NonNull ContentValues values) {
        try {
            SQLiteDatabase sQLiteDatabase = this.database;
            if (sQLiteDatabase != null && sQLiteDatabase.isOpen()) {
                void var3_5;
                void var2_4;
                void var1_1;
                return this.database.insertWithOnConflict((String)var1_1, (String)var2_4, (ContentValues)var3_5, 4);
            }
            this.logOperationFailedWarning("DB insertion with on conflict failed");
            return -1L;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            IBGDiagnostics.reportNonFatal(outOfMemoryError, "DB insertion with on conflict failed: " + outOfMemoryError.getMessage() + Arrays.toString(outOfMemoryError.getStackTrace()));
            this.logOperationFailedWarning("DB insertion with on conflict failed due to: " + outOfMemoryError.getMessage() + Arrays.toString(outOfMemoryError.getStackTrace()));
            return -1L;
        }
        catch (Exception exception) {
            IBGDiagnostics.reportNonFatal(exception, "DB insertion with on conflict failed: " + exception.getMessage() + Arrays.toString(exception.getStackTrace()));
            this.logOperationFailedWarning("DB insertion with on conflict failed due to: " + exception.getMessage() + Arrays.toString(exception.getStackTrace()));
            return -1L;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public long insertWithOnConflictReplace(@NonNull String tableName, @Nullable String nullColumnHack, @NonNull ContentValues values) {
        try {
            SQLiteDatabase sQLiteDatabase = this.database;
            if (sQLiteDatabase != null && sQLiteDatabase.isOpen()) {
                void var3_5;
                void var2_4;
                void var1_1;
                return this.database.insertWithOnConflict((String)var1_1, (String)var2_4, (ContentValues)var3_5, 5);
            }
            this.logOperationFailedWarning("DB insertion with on conflict replace failed");
            return -1L;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            IBGDiagnostics.reportNonFatal(outOfMemoryError, "DB insertion with on conflict replace failed: " + outOfMemoryError.getMessage() + Arrays.toString(outOfMemoryError.getStackTrace()));
            this.logOperationFailedWarning("DB insertion with on conflict replace failed due to: " + outOfMemoryError.getMessage() + Arrays.toString(outOfMemoryError.getStackTrace()));
            return -1L;
        }
        catch (Exception exception) {
            IBGDiagnostics.reportNonFatal(exception, "DB insertion with on conflict replace failed: " + exception.getMessage() + Arrays.toString(exception.getStackTrace()));
            this.logOperationFailedWarning("DB insertion with on conflict replace failed due to: " + exception.getMessage() + Arrays.toString(exception.getStackTrace()));
            return -1L;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"ERADICATE_NULLABLE_DEREFERENCE"})
    public void execSQL(@NonNull String sql) {
        try {
            SQLiteDatabase sQLiteDatabase = this.database;
            if (sQLiteDatabase != null && sQLiteDatabase.isOpen()) {
                void var1_1;
                this.database.execSQL((String)var1_1);
                return;
            }
            this.logOperationFailedWarning("DB execution a sql failed");
            return;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            IBGDiagnostics.reportNonFatal(outOfMemoryError, "DB execution a sql failed: " + outOfMemoryError.getMessage() + Arrays.toString(outOfMemoryError.getStackTrace()));
            this.logOperationFailedWarning("DB execution a sql failed due to: " + outOfMemoryError.getMessage() + Arrays.toString(outOfMemoryError.getStackTrace()));
            return;
        }
        catch (Exception exception) {
            IBGDiagnostics.reportNonFatal(exception, "DB execution a sql failed: " + exception.getMessage() + Arrays.toString(exception.getStackTrace()));
            this.logOperationFailedWarning("DB execution a sql failed due to: " + exception.getMessage() + Arrays.toString(exception.getStackTrace()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"ERADICATE_NULLABLE_DEREFERENCE"})
    public void setTransactionSuccessful() {
        try {
            SQLiteDatabase sQLiteDatabase = this.database;
            if (sQLiteDatabase != null && sQLiteDatabase.isOpen()) {
                if (!this.isDatabaseTransactionsEnabled()) return;
                this.database.setTransactionSuccessful();
                return;
            }
            this.logOperationFailedWarning("DB transaction not successful");
            return;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            IBGDiagnostics.reportNonFatal(outOfMemoryError, "DB transaction not successful due to: " + outOfMemoryError.getMessage());
            this.logOperationFailedWarning("DB transaction not successful due to: " + outOfMemoryError.getMessage());
            return;
        }
        catch (Exception exception) {
            IBGDiagnostics.reportNonFatal(exception, "DB transaction not successful due to: " + exception.getMessage());
            this.logOperationFailedWarning("DB transaction not successful due to: " + exception.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"ERADICATE_NULLABLE_DEREFERENCE"})
    public synchronized void endTransaction() {
        try {
            SQLiteDatabase sQLiteDatabase = this.database;
            if (sQLiteDatabase != null && sQLiteDatabase.isOpen()) {
                if (!this.isDatabaseTransactionsEnabled()) return;
                this.database.endTransaction();
                return;
            }
            this.logOperationFailedWarning("DB end transaction not successful");
            return;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            IBGDiagnostics.reportNonFatal(outOfMemoryError, "DB end transaction not successful due to: " + outOfMemoryError.getMessage());
            this.logOperationFailedWarning("B end transaction not successful due to: " + outOfMemoryError.getMessage());
            return;
        }
        catch (Exception exception) {
            IBGDiagnostics.reportNonFatal(exception, "DB end transaction not successful due to: " + exception.getMessage());
            this.logOperationFailedWarning("DB end transaction not successful due to: " + exception.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public Cursor rawQuery(@NonNull String sql, @Nullable String[] selectionArgs) {
        try {
            SQLiteDatabase sQLiteDatabase = this.database;
            if (sQLiteDatabase != null && sQLiteDatabase.isOpen()) {
                void var2_4;
                void var1_1;
                return this.database.rawQuery((String)var1_1, (String[])var2_4);
            }
            this.logOperationFailedWarning("DB raw query failed");
            return null;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            IBGDiagnostics.reportNonFatal(outOfMemoryError, "DB raw query failed: " + outOfMemoryError.getMessage() + Arrays.toString(outOfMemoryError.getStackTrace()));
            this.logOperationFailedWarning("DB raw query failed due to: " + outOfMemoryError.getMessage() + Arrays.toString(outOfMemoryError.getStackTrace()));
            return null;
        }
        catch (Exception exception) {
            IBGDiagnostics.reportNonFatal(exception, "DB raw query failed: " + exception.getMessage() + Arrays.toString(exception.getStackTrace()));
            this.logOperationFailedWarning("DB raw query failed due to: " + exception.getMessage() + Arrays.toString(exception.getStackTrace()));
            return null;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public int delete(@NonNull String table, @Nullable String whereClause, @Nullable String[] whereArgs) {
        try {
            SQLiteDatabase sQLiteDatabase = this.database;
            if (sQLiteDatabase != null && sQLiteDatabase.isOpen()) {
                void var3_5;
                void var2_4;
                void var1_1;
                return this.database.delete((String)var1_1, (String)var2_4, (String[])var3_5);
            }
            this.logOperationFailedWarning("DB deletion failed");
            return 0;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            IBGDiagnostics.reportNonFatal(outOfMemoryError, "DB raw query failed: " + outOfMemoryError.getMessage() + Arrays.toString(outOfMemoryError.getStackTrace()));
            this.logOperationFailedWarning("DB deletion failed: " + outOfMemoryError.getMessage() + Arrays.toString(outOfMemoryError.getStackTrace()));
            return 0;
        }
        catch (Exception exception) {
            IBGDiagnostics.reportNonFatal(exception, "DB raw query failed: " + exception.getMessage() + Arrays.toString(exception.getStackTrace()));
            this.logOperationFailedWarning("DB deletion failed: " + exception.getMessage() + Arrays.toString(exception.getStackTrace()));
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public int update(@NonNull String table, @NonNull ContentValues values, @Nullable String whereClause, @Nullable String[] whereArgs) {
        try {
            SQLiteDatabase sQLiteDatabase = this.database;
            if (sQLiteDatabase != null && sQLiteDatabase.isOpen()) {
                void var4_6;
                void var3_5;
                void var2_4;
                void var1_1;
                return this.database.update((String)var1_1, (ContentValues)var2_4, (String)var3_5, (String[])var4_6);
            }
            this.logOperationFailedWarning("DB update failed");
            return -1;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            IBGDiagnostics.reportNonFatal(outOfMemoryError, "DB update failed: " + outOfMemoryError.getMessage() + Arrays.toString(outOfMemoryError.getStackTrace()));
            this.logOperationFailedWarning("DB update failed: " + outOfMemoryError.getMessage() + Arrays.toString(outOfMemoryError.getStackTrace()));
            return -1;
        }
        catch (Exception exception) {
            IBGDiagnostics.reportNonFatal(exception, "DB update failed: " + exception.getMessage() + Arrays.toString(exception.getStackTrace()));
            this.logOperationFailedWarning("DB update failed: " + exception.getMessage() + Arrays.toString(exception.getStackTrace()));
            return -1;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public Cursor query(String table, @Nullable String[] columns, @Nullable String selection, @Nullable String[] selectionArgs, @Nullable String groupBy, @Nullable String having, @Nullable String orderBy) {
        try {
            SQLiteDatabase sQLiteDatabase = this.database;
            if (sQLiteDatabase != null && sQLiteDatabase.isOpen()) {
                void var7_9;
                void var6_8;
                void var5_7;
                void var4_6;
                void var3_5;
                void var2_4;
                void var1_1;
                return this.database.query((String)var1_1, (String[])var2_4, (String)var3_5, (String[])var4_6, (String)var5_7, (String)var6_8, (String)var7_9);
            }
            this.logOperationFailedWarning("DB query failed");
            return null;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            IBGDiagnostics.reportNonFatal(outOfMemoryError, "DB query failed: " + outOfMemoryError.getMessage() + Arrays.toString(outOfMemoryError.getStackTrace()));
            this.logOperationFailedWarning("DB query failed due to: " + outOfMemoryError.getMessage() + Arrays.toString(outOfMemoryError.getStackTrace()));
            return null;
        }
        catch (Exception exception) {
            IBGDiagnostics.reportNonFatal(exception, "DB query failed: " + exception.getMessage() + Arrays.toString(exception.getStackTrace()));
            this.logOperationFailedWarning("DB query failed due to: " + exception.getMessage() + Arrays.toString(exception.getStackTrace()));
            return null;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public Cursor query(String table, @Nullable String[] columns, @Nullable String selection, @Nullable String[] selectionArgs, @Nullable String groupBy, @Nullable String having, @Nullable String orderBy, @Nullable String limit) {
        try {
            SQLiteDatabase sQLiteDatabase = this.database;
            if (sQLiteDatabase != null && sQLiteDatabase.isOpen()) {
                void var8_10;
                void var7_9;
                void var6_8;
                void var5_7;
                void var4_6;
                void var3_5;
                void var2_4;
                void var1_1;
                return this.database.query((String)var1_1, (String[])var2_4, (String)var3_5, (String[])var4_6, (String)var5_7, (String)var6_8, (String)var7_9, (String)var8_10);
            }
            this.logOperationFailedWarning("DB query failed");
            return null;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            IBGDiagnostics.reportNonFatal(outOfMemoryError, "DB query failed: " + outOfMemoryError.getMessage() + Arrays.toString(outOfMemoryError.getStackTrace()));
            this.logOperationFailedWarning("DB query failed due to: " + outOfMemoryError.getMessage() + Arrays.toString(outOfMemoryError.getStackTrace()));
            return null;
        }
        catch (Exception exception) {
            IBGDiagnostics.reportNonFatal(exception, "DB query failed: " + exception.getMessage() + Arrays.toString(exception.getStackTrace()));
            this.logOperationFailedWarning("DB query failed due to: " + exception.getMessage() + Arrays.toString(exception.getStackTrace()));
            return null;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public long queryNumEntries(@NonNull String tableName) {
        try {
            SQLiteDatabase sQLiteDatabase = this.database;
            if (sQLiteDatabase != null && sQLiteDatabase.isOpen()) {
                void var1_1;
                return DatabaseUtils.queryNumEntries((SQLiteDatabase)this.database, (String)var1_1);
            }
            this.logOperationFailedWarning("DB query num entries failed");
            return -1L;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            IBGDiagnostics.reportNonFatal(outOfMemoryError, "DB query num entries failed: " + outOfMemoryError.getMessage() + Arrays.toString(outOfMemoryError.getStackTrace()));
            this.logOperationFailedWarning("DB query num entries failed due to: " + outOfMemoryError.getMessage() + Arrays.toString(outOfMemoryError.getStackTrace()));
            return -1L;
        }
        catch (Exception exception) {
            IBGDiagnostics.reportNonFatal(exception, "DB query num entries failed: " + exception.getMessage() + Arrays.toString(exception.getStackTrace()));
            this.logOperationFailedWarning("DB query num entries failed due to: " + exception.getMessage() + Arrays.toString(exception.getStackTrace()));
            return -1L;
        }
    }

    @VisibleForTesting
    public void closeDB() {
        SQLiteDatabase sQLiteDatabase = this.database;
        if (sQLiteDatabase != null) {
            sQLiteDatabase.close();
            this.database = null;
        }
    }

    public boolean deleteDatabase(Context context) {
        SQLiteDatabaseWrapper sQLiteDatabaseWrapper = this;
        sQLiteDatabaseWrapper.closeDB();
        return context.deleteDatabase(sQLiteDatabaseWrapper.databaseHelper.getDatabaseName());
    }
}

