/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.networkv2.limitation;

import com.instabug.library.networkv2.RateLimitedException;
import com.instabug.library.networkv2.limitation.RateLimitationSettings;
import com.instabug.library.networkv2.limitation.RateLimitedFeature;
import com.instabug.library.networkv2.limitation.b;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.TimeUtils;
import java.util.Arrays;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RateLimiter<M, T extends RateLimitationSettings> {
    @NotNull
    private final T settings;
    @NotNull
    private final Function1<M, Unit> onLimitationApplied;
    @Nullable
    private final RateLimitedFeature feature;

    /*
     * WARNING - void declaration
     */
    public RateLimiter(@NotNull T settings, @NotNull Function1<? super M, Unit> onLimitationApplied, @Nullable RateLimitedFeature feature) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"onLimitationApplied");
        this.settings = var1_1;
        this.onLimitationApplied = var2_2;
        this.feature = var3_3;
    }

    public /* synthetic */ RateLimiter(RateLimitationSettings rateLimitationSettings, Function1 function1, RateLimitedFeature rateLimitedFeature, int n10, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n10 & 4) != 0) {
            rateLimitedFeature = null;
        }
        this(rateLimitationSettings, function1, rateLimitedFeature);
    }

    private final void logFeatureIsRateLimited() {
        Object this_ = this_.feature;
        if (this_ != null) {
            this_ = String.format("You've reached the maximum number of requests in %s. You can read more about our rate limiting policy at this link: https://docs.instabug.com/docs/rate-limits", Arrays.copyOf(new Object[]{((RateLimitedFeature)((Object)this_)).getFeatureName()}, 1));
            Intrinsics.checkNotNullExpressionValue((Object)this_, (String)"format(this, *args)");
            InstabugSDKLogger.d("IBG-Core", (String)this_);
        }
    }

    public final void reset() {
        RateLimiter rateLimiter = this;
        rateLimiter.settings.setLastRequestStartedAt(0L);
        rateLimiter.settings.setLimitedUntil(0);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean inspect(@NotNull Throwable throwable, M obj) {
        void var2_2;
        void var1_1;
        Throwable throwable2 = throwable;
        Intrinsics.checkNotNullParameter((Object)throwable2, (String)"throwable");
        if (!(throwable2 instanceof RateLimitedException)) {
            return false;
        }
        RateLimiter rateLimiter = this;
        rateLimiter.settings.setLimitedUntil(((RateLimitedException)var1_1).getPeriod());
        rateLimiter.onLimitationApplied.invoke((Object)var2_2);
        rateLimiter.logFeatureIsRateLimited();
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean applyIfPossible(M obj) {
        void var1_1;
        if (!this.settings.isRateLimited()) {
            this.settings.setLastRequestStartedAt(TimeUtils.currentTimeMillis());
            return false;
        }
        RateLimiter rateLimiter = this;
        rateLimiter.onLimitationApplied.invoke((Object)var1_1);
        rateLimiter.logFeatureIsRateLimited();
        return true;
    }

    public static final class a {
        @NotNull
        public static final a a = new a();

        private a() {
        }

        @NotNull
        public final RateLimiter a(@NotNull RateLimitedFeature rateLimitedFeature, @NotNull Function1 function1) {
            b b10;
            Intrinsics.checkNotNullParameter((Object)((Object)rateLimitedFeature), (String)"feature");
            Intrinsics.checkNotNullParameter((Object)function1, (String)"limitationAction");
            b b11 = b10;
            b10 = new b(rateLimitedFeature);
            return new RateLimiter(b11, function1, rateLimitedFeature);
        }
    }
}

