/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.invocation;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.MotionEvent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.instabug.library.Feature;
import com.instabug.library.Instabug;
import com.instabug.library.InstabugState;
import com.instabug.library.InstabugStateProvider;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.eventbus.ActivityLifecycleSubscriber;
import com.instabug.library.core.eventbus.DefaultActivityLifeCycleEventHandler;
import com.instabug.library.core.plugin.PluginPromptOption;
import com.instabug.library.internal.servicelocator.CoreServiceLocator;
import com.instabug.library.invocation.InstabugInvocationEvent;
import com.instabug.library.invocation.InvocationSettings;
import com.instabug.library.invocation.c;
import com.instabug.library.invocation.f;
import com.instabug.library.invocation.invoker.FloatingButtonInvoker;
import com.instabug.library.invocation.invoker.m;
import com.instabug.library.invocation.invoker.q;
import com.instabug.library.invocation.invoker.s;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.t;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.PoolProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class InvocationManager
implements DefaultActivityLifeCycleEventHandler {
    private static InvocationManager INSTANCE;
    private InvocationSettings currentInvocationSettings;
    private AtomicReferenceArray<InstabugInvocationEvent> currentInstabugInvocationEvents;
    private List<com.instabug.library.invocation.invoker.a> currentInvokersList;
    @Nullable
    private AtomicReferenceArray<com.instabug.library.invocation.invoker.a> currentInvokers;
    @Nullable
    private AtomicReference<com.instabug.library.invocation.invoker.a> lastUsedInvoker;
    @VisibleForTesting
    @Nullable
    ActivityLifecycleSubscriber currentActivityLifeCycleSubscriber;
    private final com.instabug.library.invocation.b invocationManagerSubscribers;
    private AtomicBoolean isInvocationAvailable;
    @Nullable
    private AtomicReference<f> invocationRequestListenerImp;

    private InvocationManager() {
        InvocationManager invocationManager = this;
        invocationManager.currentInvokersList = new ArrayList<com.instabug.library.invocation.invoker.a>();
        invocationManager.lastUsedInvoker = new AtomicReference();
        invocationManager.currentActivityLifeCycleSubscriber = null;
        invocationManager.isInvocationAvailable = new AtomicBoolean(true);
        invocationManager.currentInvocationSettings = new InvocationSettings();
        this.currentInstabugInvocationEvents = new AtomicReferenceArray<InstabugInvocationEvent>(1);
        this.currentInstabugInvocationEvents.set(0, InstabugInvocationEvent.SHAKE);
        invocationManager.currentInvokers = new AtomicReferenceArray<com.instabug.library.invocation.invoker.a>(this.createInvokersList());
        this.invocationManagerSubscribers = new c(this);
        this.invocationManagerSubscribers.subscribe();
        invocationManager.subscribeToCurrentActivityLifeCycle();
        invocationManager.invocationRequestListenerImp = new AtomicReference<f>(new f());
    }

    @NonNull
    private com.instabug.library.invocation.invoker.a[] createInvokersList() {
        this.currentInvokersList = new ArrayList<com.instabug.library.invocation.invoker.a>();
        return this.currentInvokersList.toArray(new com.instabug.library.invocation.invoker.a[this.currentInvokersList.size()]);
    }

    /*
     * WARNING - void declaration
     */
    private void addToCurrentInvokers(com.instabug.library.invocation.invoker.a invoker) {
        void var1_1;
        this.currentInvokersList.add((com.instabug.library.invocation.invoker.a)var1_1);
        List<com.instabug.library.invocation.invoker.a> list = this.currentInvokersList;
        this.currentInvokers = new AtomicReferenceArray<com.instabug.library.invocation.invoker.a>(list.toArray(new com.instabug.library.invocation.invoker.a[list.size()]));
    }

    public static synchronized void init() {
        if (INSTANCE == null) {
            INSTANCE = new InvocationManager();
        } else if (!SettingsManager.getInstance().isInBackground()) {
            INSTANCE.listen();
        }
    }

    public static synchronized InvocationManager getInstance() {
        if (INSTANCE == null) {
            InvocationManager.init();
        }
        return INSTANCE;
    }

    private void subscribeToCurrentActivityLifeCycle() {
        if (this.currentActivityLifeCycleSubscriber == null) {
            this.currentActivityLifeCycleSubscriber = CoreServiceLocator.createActivityLifecycleSubscriber(this);
            this.currentActivityLifeCycleSubscriber.subscribe();
        }
    }

    private boolean isPromptOptionsAvailable() {
        return this.getAvailablePromptOptions().size() > 0;
    }

    @Nullable
    private FloatingButtonInvoker getFloatingButtonInvoker() {
        FloatingButtonInvoker floatingButtonInvoker = null;
        if (this.currentInvokers != null) {
            for (int i10 = 0; i10 < this.currentInvokers.length(); ++i10) {
                com.instabug.library.invocation.invoker.a a10 = this.currentInvokers.get(i10);
                if (!(a10 instanceof FloatingButtonInvoker)) continue;
                floatingButtonInvoker = (FloatingButtonInvoker)a10;
                break;
            }
        }
        return floatingButtonInvoker;
    }

    @VisibleForTesting
    @SuppressLint(value={"ERADICATE_FIELD_NOT_NULLABLE"})
    public static void tearDown() {
        INSTANCE = null;
    }

    public void release() {
        ActivityLifecycleSubscriber activityLifecycleSubscriber = ((InvocationManager)((Object)this_)).currentActivityLifeCycleSubscriber;
        if (activityLifecycleSubscriber != null) {
            activityLifecycleSubscriber.unsubscribe();
        }
        ((InvocationManager)((Object)this_)).invocationRequestListenerImp = null;
        com.instabug.library.invocation.b this_ = ((InvocationManager)((Object)this_)).invocationManagerSubscribers;
        if (this_ != null) {
            this_.unsubscribe();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setInstabugInvocationEvent(InstabugInvocationEvent ... instabugInvocationEvent) {
        int n10;
        void var1_1;
        if (instabugInvocationEvent == null) {
            InstabugSDKLogger.e("IBG-Core", "Passed invocation events has null value, no change will take effect to the previous set invocation events");
            return;
        }
        InvocationManager invocationManager = this;
        invocationManager.currentInstabugInvocationEvents = invocationManager.removeDuplicates((InstabugInvocationEvent[])var1_1);
        if (invocationManager.currentInvokers != null) {
            for (n10 = 0; n10 < this.currentInvokers.length(); ++n10) {
                this.currentInvokers.get(n10).sleep();
            }
            this.currentInvokers = new AtomicReferenceArray<com.instabug.library.invocation.invoker.a>(this.createInvokersList());
        }
        block7: for (n10 = 0; n10 < this.currentInstabugInvocationEvents.length(); ++n10) {
            Object object = this.currentInstabugInvocationEvents.get(n10);
            InstabugSDKLogger.v("IBG-Core", "set instabug invocation event: " + (Object)object);
            if (object == InstabugInvocationEvent.NONE && ((void)var1_1).length == 1) {
                this.currentInvokers = null;
                break;
            }
            if (this.currentInvokers == null) {
                this.currentInvokers = new AtomicReferenceArray<com.instabug.library.invocation.invoker.a>(this.createInvokersList());
            }
            Context context = Instabug.getApplicationContext();
            if (this.invocationRequestListenerImp == null) continue;
            switch (b.a[object.ordinal()]) {
                default: {
                    continue block7;
                }
                case 4: {
                    if (this.currentInvokers == null || this.invocationRequestListenerImp.get() == null) continue block7;
                    this.addToCurrentInvokers(new m(this.invocationRequestListenerImp.get()));
                    continue block7;
                }
                case 3: {
                    if (context != null && this.invocationRequestListenerImp.get() != null) {
                        s s10;
                        object = s10;
                        s10 = new s(context, this.invocationRequestListenerImp.get());
                        if (this.currentInvokers == null) continue block7;
                        this.addToCurrentInvokers((com.instabug.library.invocation.invoker.a)object);
                        continue block7;
                    }
                    InstabugSDKLogger.e("IBG-Core", "did not add TwoFingerSwipeLeftInvoker due to null appContext");
                    continue block7;
                }
                case 2: {
                    if (this.currentInvokers == null || this.invocationRequestListenerImp.get() == null) continue block7;
                    this.addToCurrentInvokers(new FloatingButtonInvoker(this.invocationRequestListenerImp.get()));
                    continue block7;
                }
                case 1: {
                    if (context != null && this.invocationRequestListenerImp.get() != null) {
                        q q10;
                        object = q10;
                        ((q)object)(context, this.invocationRequestListenerImp.get());
                        q10.a(this.currentInvocationSettings.getShakeThreshold());
                        if (this.currentInvokers == null) continue block7;
                        this.addToCurrentInvokers((com.instabug.library.invocation.invoker.a)object);
                        continue block7;
                    }
                    InstabugSDKLogger.e("IBG-Core", "did not add ShakeInvoker due to null appContext");
                }
            }
        }
        if (this.currentInvokers != null) {
            InvocationManager invocationManager2 = this;
            invocationManager2.setLastUsedInvoker(null);
            invocationManager2.listen();
        }
    }

    @VisibleForTesting
    AtomicReferenceArray<InstabugInvocationEvent> removeDuplicates(InstabugInvocationEvent[] events) {
        InstabugInvocationEvent[] instabugInvocationEventArray;
        HashSet<void> hashSet;
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        HashSet<void> hashSet2 = hashSet;
        hashSet = new HashSet<void>();
        int n10 = events.length;
        for (int i10 = 0; i10 < n10; ++i10) {
            void var5_5 = instabugInvocationEventArray[i10];
            if (hashSet2.contains(var5_5)) continue;
            arrayList2.add(var5_5);
            hashSet2.add(var5_5);
        }
        instabugInvocationEventArray = new InstabugInvocationEvent[arrayList2.size()];
        return new AtomicReferenceArray<InstabugInvocationEvent>(arrayList2.toArray(instabugInvocationEventArray));
    }

    @Nullable
    public InstabugInvocationEvent[] getCurrentInstabugInvocationEvents() {
        if (t.c().b((Object)"BUG_REPORTING") == Feature.State.DISABLED) {
            return null;
        }
        InstabugInvocationEvent[] instabugInvocationEventArray = (InstabugInvocationEvent[])com.instabug.library.invocation.util.a.a(this.currentInstabugInvocationEvents, InstabugInvocationEvent.class);
        if (instabugInvocationEventArray != null) {
            return Arrays.copyOf(instabugInvocationEventArray, this.currentInstabugInvocationEvents.length());
        }
        return null;
    }

    public InvocationSettings getCurrentInvocationSettings() {
        return this.currentInvocationSettings;
    }

    @Nullable
    List<com.instabug.library.invocation.invoker.a> getCurrentInvokers() {
        com.instabug.library.invocation.invoker.a[] this_ = (com.instabug.library.invocation.invoker.a[])com.instabug.library.invocation.util.a.a(this_.currentInvokers, com.instabug.library.invocation.invoker.a.class);
        if (this_ == null) {
            return null;
        }
        return Arrays.asList(this_);
    }

    @Nullable
    public com.instabug.library.invocation.invoker.a getLastUsedInvoker() {
        AtomicReference<com.instabug.library.invocation.invoker.a> this_ = ((InvocationManager)((Object)this_)).lastUsedInvoker;
        if (this_ == null) {
            return null;
        }
        return (com.instabug.library.invocation.invoker.a)this_.get();
    }

    /*
     * WARNING - void declaration
     */
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public void setLastUsedInvoker(@Nullable com.instabug.library.invocation.invoker.a lastUsedInvoker) {
        AtomicReference<com.instabug.library.invocation.invoker.a> this_ = ((InvocationManager)((Object)this_)).lastUsedInvoker;
        if (this_ != null) {
            void var1_1;
            this_.set((com.instabug.library.invocation.invoker.a)var1_1);
        }
    }

    public void listen() {
        if (Instabug.isEnabled() && this.isInvocationAvailable.get() && this.isPromptOptionsAvailable() && this.currentInvokers != null && InstabugCore.getTargetActivity() != null && InstabugCore.getRunningSession() != null && !SettingsManager.getInstance().isProcessingForeground()) {
            for (int i10 = 0; i10 < this.currentInvokers.length(); ++i10) {
                com.instabug.library.invocation.invoker.a a10 = this.currentInvokers.get(i10);
                if (a10.isActive()) continue;
                a10.listen();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void handle(MotionEvent motionEvent) {
        if (this.currentInvokers == null) {
            return;
        }
        if (InstabugStateProvider.getInstance().getState().equals((Object)InstabugState.ENABLED) && !InstabugCore.isForegroundBusy()) {
            for (int i10 = 0; i10 < this.currentInvokers.length(); ++i10) {
                void var1_1;
                com.instabug.library.invocation.invoker.a a10 = this.currentInvokers.get(i10);
                if (!(a10 instanceof s)) continue;
                a10.handle(var1_1);
                break;
            }
        }
    }

    public void sleep() {
        if (this.currentInvokers != null) {
            for (int i10 = 0; i10 < this.currentInvokers.length(); ++i10) {
                com.instabug.library.invocation.invoker.a a10 = this.currentInvokers.get(i10);
                if (!a10.isActive()) continue;
                a10.sleep();
            }
        }
    }

    public void switchOffInvocation() {
        this.isInvocationAvailable.set(false);
    }

    public void switchOnInvocation() {
        this.isInvocationAvailable.set(true);
    }

    public ArrayList<PluginPromptOption> getAvailablePromptOptions() {
        return com.instabug.library.core.plugin.c.f();
    }

    @Override
    public void handleActivityResumed() {
        PoolProvider.postIOTask(() -> {
            InvocationManager invocationManager = this;
            synchronized (invocationManager) {
                invocationManager.listen();
                return;
            }
        });
    }

    @Override
    public void handleActivityPaused() {
        PoolProvider.postIOTask(() -> {
            InvocationManager invocationManager = this;
            synchronized (invocationManager) {
                invocationManager.sleep();
                return;
            }
        });
    }

    public void notifyPrimaryColorChanged() {
        if (Instabug.isEnabled() && this.currentInvokers != null) {
            for (int i10 = 0; i10 < this.currentInvokers.length(); ++i10) {
                final com.instabug.library.invocation.invoker.a a10 = this.currentInvokers.get(i10);
                if (InstabugCore.getTargetActivity() == null || !(a10 instanceof FloatingButtonInvoker)) continue;
                PoolProvider.postMainThreadTask(new Runnable(this){

                    @Override
                    public void run() {
                        a a102 = this;
                        a102.a10.sleep();
                        a102.a10.listen();
                    }
                });
            }
        }
    }

    public void notifyInvocationOptionChanged() {
        InvocationManager invocationManager = this;
        boolean bl = invocationManager.isPromptOptionsAvailable() ^ true;
        FloatingButtonInvoker floatingButtonInvoker = invocationManager.getFloatingButtonInvoker();
        if (floatingButtonInvoker != null) {
            if (bl) {
                floatingButtonInvoker.sleep();
            } else {
                floatingButtonInvoker.updateButtonLocation();
            }
        }
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public void show() {
        AtomicReference<Object> atomicReference;
        AtomicReference<f> atomicReference2 = ((InvocationManager)((Object)this_)).invocationRequestListenerImp;
        if (atomicReference2 != null && atomicReference2.get() != null) {
            ((InvocationManager)((Object)this_)).invocationRequestListenerImp.get().a();
        }
        InvocationManager invocationManager = this_;
        AtomicReference<Object> this_ = atomicReference;
        atomicReference = new AtomicReference<Object>(null);
        invocationManager.lastUsedInvoker = this_;
    }

    /*
     * WARNING - void declaration
     */
    public void invoke(int invocationMode) {
        AtomicReference<f> atomicReference = this.invocationRequestListenerImp;
        if (atomicReference != null && atomicReference.get() != null) {
            void var1_1;
            this.invocationRequestListenerImp.get().b((int)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void forceInvoke(int invocationMode) {
        AtomicReference<f> atomicReference = this.invocationRequestListenerImp;
        if (atomicReference != null && atomicReference.get() != null) {
            void var1_1;
            this.invocationRequestListenerImp.get().a((int)var1_1);
        }
    }
}

