/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.storage.cache.db;

import android.annotation.SuppressLint;
import android.content.Context;
import androidx.annotation.VisibleForTesting;
import com.instabug.library.Instabug;
import com.instabug.library.internal.storage.cache.db.SQLiteDatabaseWrapper;
import com.instabug.library.internal.storage.cache.db.a;
import com.instabug.library.util.InstabugSDKLogger;

public class DatabaseManager {
    private static DatabaseManager instance;
    private static SQLiteDatabaseWrapper databaseWrapper;

    @VisibleForTesting
    public static synchronized void init(Context context) {
        if (instance == null) {
            Context context2;
            instance = new DatabaseManager();
            databaseWrapper = new SQLiteDatabaseWrapper(a.a(context2));
        }
    }

    @SuppressLint(value={"RESOURCE_LEAK"})
    public static synchronized DatabaseManager getInstance() throws IllegalStateException {
        if (instance == null) {
            if (Instabug.getApplicationContext() != null) {
                InstabugSDKLogger.v("IBG-Core", "Initializing database manager");
                DatabaseManager.init(Instabug.getApplicationContext());
            } else {
                throw new IllegalStateException(DatabaseManager.class.getSimpleName() + " is not initialized, call init(..) method first.");
            }
        }
        return instance;
    }

    @SuppressLint(value={"ERADICATE_FIELD_NOT_NULLABLE"})
    @VisibleForTesting
    public static synchronized void tearDown() {
        SQLiteDatabaseWrapper sQLiteDatabaseWrapper = databaseWrapper;
        if (sQLiteDatabaseWrapper != null) {
            sQLiteDatabaseWrapper.closeDB();
            databaseWrapper = null;
        }
        instance = null;
    }

    public static synchronized void clearAll() {
        SQLiteDatabaseWrapper sQLiteDatabaseWrapper = DatabaseManager.getInstance().openDatabase();
        sQLiteDatabaseWrapper.execSQL("DELETE FROM network_logs");
        sQLiteDatabaseWrapper.execSQL("DELETE FROM instabug_logs");
        sQLiteDatabaseWrapper.execSQL("DELETE FROM attachments");
        sQLiteDatabaseWrapper.execSQL("DELETE FROM crashes_table");
        sQLiteDatabaseWrapper.execSQL("DELETE FROM experiments_table");
    }

    public synchronized SQLiteDatabaseWrapper openDatabase() {
        databaseWrapper.open();
        return databaseWrapper;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized boolean deleteDatabase(Context context) {
        void var1_1;
        return databaseWrapper.deleteDatabase((Context)var1_1);
    }
}

