/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.encryption.iv;

import androidx.annotation.VisibleForTesting;
import com.instabug.library.util.InstabugSDKLogger;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

public final class StaticIVProvider {
    @NotNull
    public static final StaticIVProvider a = new StaticIVProvider();

    private StaticIVProvider() {
    }

    @JvmStatic
    @NotNull
    public static final byte[] a() {
        String string2;
        int n10 = 0;
        try {
            string2 = StaticIVProvider.getIVString();
        }
        catch (Exception exception) {
            InstabugSDKLogger.e("StaticIVProvider", "Error loading native initialization vector", exception);
            return new byte[n10];
        }
        n10 = string2.length();
        byte[] byArray = new byte[n10];
        byte[] byArray2 = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
        System.arraycopy(byArray2, 0, byArray, 0, n10);
        return byArray;
    }

    @JvmStatic
    @VisibleForTesting
    @NotNull
    public static final native String getIVString();

    static {
        try {
            System.loadLibrary("ibg-native");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            InstabugSDKLogger.e("StaticIVProvider", "Error loading native library", unsatisfiedLinkError);
        }
    }
}

