/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.annotation;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RectShape;
import android.graphics.drawable.shapes.Shape;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import com.instabug.library.R;
import com.instabug.library.annotation.AnnotationView;
import com.instabug.library.annotation.ColorPickerPopUpView;
import com.instabug.library.annotation.ShapeSuggestionsLayout;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.util.AccessibilityUtils;
import com.instabug.library.util.AttrResolver;
import com.instabug.library.util.BitmapUtils;
import com.instabug.library.util.BitmapWorkerTask;
import com.instabug.library.util.DrawableUtils;
import com.instabug.library.view.IconView;
import com.instabug.library.view.ViewUtils;
import java.io.Serializable;

public class AnnotationLayout
extends LinearLayout
implements View.OnClickListener {
    private static final String ANNOTATION_LAYOUT = "instabug_annotation_layout";
    private static final String DRAWING_MODE = "drawingMode";
    @Nullable
    private AnnotationView annotationView;
    @Nullable
    private ColorPickerPopUpView colorPicker;
    private int tintingColor;
    @Nullable
    private LinearLayout annotationActionsContainer;
    @Nullable
    private RelativeLayout iconBrushLayout;
    @Nullable
    private ImageView iconBrush;
    @Nullable
    private ImageView iconMagnify;
    @Nullable
    private ImageView iconBlur;
    @Nullable
    private ImageView iconUndo;
    @Nullable
    private View brushIndicator;
    @Nullable
    private View border;
    @Nullable
    private ShapeSuggestionsLayout shapeSuggestionsLayout;

    /*
     * WARNING - void declaration
     */
    public AnnotationLayout(Context context) {
        this((Context)var1_1, null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public AnnotationLayout(Context context, @Nullable AttributeSet attrs) {
        this((Context)var1_1, (AttributeSet)var2_2, 0);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public AnnotationLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        void var3_3;
        void var2_2;
        void var1_1;
        AnnotationLayout annotationLayout = this;
        super((Context)var1_1, (AttributeSet)var2_2, (int)var3_3);
        annotationLayout.initViews();
    }

    /*
     * WARNING - void declaration
     */
    @TargetApi(value=21)
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public AnnotationLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        AnnotationLayout annotationLayout = this;
        super((Context)var1_1, (AttributeSet)var2_2, (int)var3_3, (int)var4_4);
        annotationLayout.initViews();
    }

    private void initViews() {
        AnnotationLayout annotationLayout = this;
        LinearLayout.inflate((Context)annotationLayout.getContext(), (int)R.layout.instabug_annotation_view, (ViewGroup)this);
        annotationLayout.annotationActionsContainer = (LinearLayout)annotationLayout.findViewById(R.id.instabug_annotation_actions_container);
        Object object = (ShapeSuggestionsLayout)annotationLayout.findViewById(R.id.shapeSuggestionsLayout);
        this.shapeSuggestionsLayout = object;
        if (object != null) {
            ShapeSuggestionsLayout.e e10;
            ShapeSuggestionsLayout shapeSuggestionsLayout = object;
            object = e10;
            e10 = new ShapeSuggestionsLayout.e(){

                @Override
                public void a(int n10) {
                    if (n10 == 1 && AnnotationLayout.this.annotationView != null) {
                        AnnotationLayout.this.annotationView.e();
                    }
                }
            };
            shapeSuggestionsLayout.setOnShapeSelectedListener((ShapeSuggestionsLayout.e)object);
        }
        AnnotationLayout annotationLayout2 = this;
        annotationLayout2.iconBrushLayout = (RelativeLayout)annotationLayout2.findViewById(R.id.icon_brush_layout);
        annotationLayout2.iconBrush = (ImageView)annotationLayout2.findViewById(R.id.icon_brush);
        annotationLayout2.iconMagnify = (ImageView)annotationLayout2.findViewById(R.id.icon_magnify);
        annotationLayout2.iconBlur = (ImageView)annotationLayout2.findViewById(R.id.icon_blur);
        annotationLayout2.iconUndo = (ImageView)annotationLayout2.findViewById(R.id.icon_undo);
        object = annotationLayout2.iconBrush;
        if (object != null) {
            object.setEnabled(false);
            if (AccessibilityUtils.isAccessibilityServiceEnabled()) {
                ViewCompat.setAccessibilityDelegate((View)this.iconBrush, (AccessibilityDelegateCompat)new AccessibilityDelegateCompat(this){

                    public void onInitializeAccessibilityNodeInfo(View view, AccessibilityNodeInfoCompat accessibilityNodeInfoCompat) {
                        super.onInitializeAccessibilityNodeInfo(view, accessibilityNodeInfoCompat);
                        accessibilityNodeInfoCompat.setRoleDescription((CharSequence)"Button");
                    }
                });
            }
        }
        if ((object = this.iconMagnify) != null) {
            object.setEnabled(false);
        }
        if ((object = this.iconBlur) != null) {
            object.setEnabled(false);
        }
        if ((object = this.iconUndo) != null) {
            object.setEnabled(false);
        }
        AnnotationLayout annotationLayout3 = this;
        annotationLayout3.border = annotationLayout3.findViewById(R.id.instabug_annotation_image_border);
        annotationLayout3.annotationView = (AnnotationView)annotationLayout3.findViewById(R.id.instabug_annotation_image);
        annotationLayout3.colorPicker = (ColorPickerPopUpView)annotationLayout3.findViewById(R.id.instabug_color_picker);
        annotationLayout3.brushIndicator = annotationLayout3.findViewById(R.id.brush_indicator);
        object = annotationLayout3.annotationView;
        if (object != null) {
            ((AnnotationView)((Object)object)).setDrawingMode(AnnotationView.c.DRAW_PATH);
            Object object2 = this.iconBrush;
            if (object2 != null) {
                DrawableUtils.setDrawableTintColor((ImageView)object2, InstabugCore.getPrimaryColor());
            }
            if ((object2 = this.colorPicker) != null) {
                ((AnnotationView)((Object)object)).setDrawingColor(((ColorPickerPopUpView)((Object)object2)).getSelectedColor());
            }
            ((AnnotationView)((Object)object)).setOnActionDownListener(() -> {
                ColorPickerPopUpView colorPickerPopUpView = this.colorPicker;
                if (colorPickerPopUpView != null && colorPickerPopUpView.getVisibility() == 0) {
                    this.colorPicker.setVisibility(8);
                }
                if ((this = this.shapeSuggestionsLayout) != null) {
                    this.a();
                }
            });
            ((AnnotationView)((Object)object)).setOnPathRecognizedListener((xva$0, xva$1) -> {
                void var2_2;
                void var1_1;
                Path[] pathArray = new Path[2];
                Path[] pathArray2 = pathArray;
                pathArray[0] = var1_1;
                pathArray[1] = var2_2;
                this.showShapeSuggestions(pathArray2);
            });
            ((AnnotationView)((Object)object)).setOnNewMagnifierAddingA\u0650\u0650\u0650bilityChangedListener(ability -> {
                AnnotationLayout this_ = this_.iconMagnify;
                if (this_ != null) {
                    void var1_1;
                    this_.setEnabled((boolean)var1_1);
                }
            });
            object2 = this.colorPicker;
            if (object2 != null) {
                ((ColorPickerPopUpView)((Object)object2)).setOnColorSelectionListener((arg_0, arg_1) -> this.lambda$initViews$3((AnnotationView)((Object)object), arg_0, arg_1));
            }
        }
        if ((object = this.colorPicker) != null) {
            ((ColorPickerPopUpView)((Object)object)).setPopUpBackgroundColor(AttrResolver.resolveAttributeColor(this.getContext(), R.attr.ib_annotation_color_picker_bg_color));
        }
        if ((object = this.iconBrushLayout) != null) {
            object.setOnClickListener(this);
        }
        if ((object = this.iconMagnify) != null) {
            object.setOnClickListener(this);
        }
        if ((object = this.iconBlur) != null) {
            object.setOnClickListener(this);
        }
        if ((object = this.iconUndo) != null) {
            object.setOnClickListener(this);
        }
        AnnotationLayout annotationLayout4 = this;
        annotationLayout4.setViewSelector(annotationLayout4.iconMagnify);
        annotationLayout4.setViewSelector(annotationLayout4.iconUndo);
        annotationLayout4.tintingColor = ContextCompat.getColor((Context)annotationLayout4.getContext(), (int)R.color.ib_core_annotation_tinting_color);
    }

    /*
     * WARNING - void declaration
     */
    private void showShapeSuggestions(Path ... paths) {
        ShapeSuggestionsLayout shapeSuggestionsLayout = this.shapeSuggestionsLayout;
        if (shapeSuggestionsLayout != null) {
            void var1_1;
            shapeSuggestionsLayout.removeAllViews();
            for (int i10 = 0; i10 < ((void)var1_1).length; ++i10) {
                ShapeSuggestionsLayout shapeSuggestionsLayout2 = this.shapeSuggestionsLayout;
                int n10 = i10 == 0 ? R.string.ibg_bug_annotation_original_shape_content_description : R.string.ibg_bug_annotation_recognized_shape_content_description;
                shapeSuggestionsLayout2.a(n10, (Path)var1_1[i10]);
            }
            this.shapeSuggestionsLayout.b();
        }
    }

    private void setBorder() {
        ShapeDrawable shapeDrawable;
        AnnotationLayout annotationLayout = this;
        int n10 = ViewUtils.convertDpToPx(annotationLayout.getContext(), 4.0f);
        int n11 = ViewUtils.convertDpToPx(annotationLayout.getContext(), 2.0f);
        ShapeDrawable shapeDrawable2 = shapeDrawable;
        new ShapeDrawable().setShape((Shape)new RectShape());
        shapeDrawable2.getPaint().setColor(InstabugCore.getPrimaryColor());
        shapeDrawable2.getPaint().setStyle(Paint.Style.STROKE);
        shapeDrawable2.getPaint().setStrokeWidth((float)n10);
        View view = annotationLayout.border;
        if (view != null) {
            int n12 = n11;
            view.setPadding(n12, n12, n12, n12);
            if (Build.VERSION.SDK_INT >= 16) {
                this.border.setBackground((Drawable)shapeDrawable2);
            } else {
                this.border.setBackgroundDrawable((Drawable)shapeDrawable2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setViewSelector(@Nullable ImageView viewSelector) {
        if (viewSelector != null) {
            void var1_1;
            View.OnTouchListener onTouchListener;
            View.OnTouchListener onTouchListener2 = onTouchListener;
            onTouchListener = new View.OnTouchListener((ImageView)var1_1){
                final /* synthetic */ ImageView a;
                {
                    this.a = imageView;
                }

                public boolean onTouch(View view, MotionEvent motionEvent) {
                    if (motionEvent.getAction() == 0) {
                        DrawableUtils.setDrawableTintColor(this.a, InstabugCore.getPrimaryColor());
                    } else if (motionEvent.getAction() == 1) {
                        DrawableUtils.setDrawableTintColor(this.a, AnnotationLayout.this.tintingColor);
                    }
                    return false;
                }
            };
            var1_1.setOnTouchListener(onTouchListener2);
        }
    }

    private void switchColorPickerVisibility() {
        Object this_ = this_.colorPicker;
        if (this_ != null) {
            int n10 = this_.getVisibility() == 0 ? 8 : 0;
            this_.setVisibility(n10);
        }
    }

    private void hideColorPicker() {
        ColorPickerPopUpView colorPickerPopUpView = this.colorPicker;
        if (colorPickerPopUpView != null && colorPickerPopUpView.getVisibility() == 0) {
            this.colorPicker.setVisibility(8);
        }
    }

    private void resetColorSelection() {
        LinearLayout linearLayout = this.annotationActionsContainer;
        if (linearLayout != null) {
            int n10 = linearLayout.getChildCount();
            for (int i10 = 0; i10 < n10; ++i10) {
                if (!(this.annotationActionsContainer.getChildAt(i10) instanceof IconView)) continue;
                ((TextView)this.annotationActionsContainer.getChildAt(i10)).setTextColor(this.tintingColor);
            }
        }
        AnnotationLayout annotationLayout = this;
        DrawableUtils.setDrawableTintColor(annotationLayout.iconBrush, this.tintingColor);
        DrawableUtils.setDrawableTintColor(annotationLayout.iconBlur, this.tintingColor);
    }

    private void enableButtons() {
        ImageView imageView = this.iconBrush;
        if (imageView != null) {
            imageView.setEnabled(true);
        }
        if ((imageView = this.iconMagnify) != null) {
            imageView.setEnabled(true);
        }
        if ((imageView = this.iconBlur) != null) {
            imageView.setEnabled(true);
        }
        if ((this = this.iconUndo) != null) {
            this.setEnabled(true);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$initViews$3(AnnotationView currentAnnotationView, int color2, int index) {
        void var2_2;
        ColorPickerPopUpView colorPickerPopUpView;
        ((AnnotationView)((Object)colorPickerPopUpView)).setDrawingColor((int)var2_2);
        colorPickerPopUpView = this.colorPicker;
        if (colorPickerPopUpView != null) {
            colorPickerPopUpView.setVisibility(8);
        }
        if ((this = this.brushIndicator) != null) {
            this.setBackgroundColor((int)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void onClick(View v10) {
        void var1_1;
        int n10;
        ShapeSuggestionsLayout shapeSuggestionsLayout = this.shapeSuggestionsLayout;
        if (shapeSuggestionsLayout != null) {
            shapeSuggestionsLayout.a();
        }
        if ((n10 = var1_1.getId()) == R.id.icon_brush_layout) {
            AnnotationLayout annotationLayout = this;
            annotationLayout.switchColorPickerVisibility();
            AnnotationView annotationView = annotationLayout.annotationView;
            if (annotationView != null) {
                annotationView.setDrawingMode(AnnotationView.c.DRAW_PATH);
            }
            AnnotationLayout annotationLayout2 = this;
            annotationLayout2.resetColorSelection();
            DrawableUtils.setDrawableTintColor(annotationLayout2.iconBrush, InstabugCore.getPrimaryColor());
        } else if (n10 == R.id.icon_magnify) {
            AnnotationView annotationView = this.annotationView;
            if (annotationView != null) {
                annotationView.b();
            }
            this.hideColorPicker();
        } else if (n10 == R.id.icon_blur) {
            AnnotationView annotationView = this.annotationView;
            if (annotationView != null) {
                annotationView.setDrawingMode(AnnotationView.c.DRAW_BLUR);
            }
            AnnotationLayout annotationLayout = this;
            annotationLayout.resetColorSelection();
            DrawableUtils.setDrawableTintColor(annotationLayout.iconBlur, InstabugCore.getPrimaryColor());
            annotationLayout.hideColorPicker();
        } else if (n10 == R.id.icon_undo) {
            AnnotationView annotationView = this.annotationView;
            if (annotationView != null) {
                annotationView.h();
            }
            this.hideColorPicker();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setBaseImage(@NonNull Uri imageUri, @Nullable Runnable runnable) {
        if (imageUri.getPath() != null && this.annotationView != null) {
            void var2_2;
            void var1_1;
            BitmapUtils.loadBitmap(var1_1.getPath(), (ImageView)this.annotationView, new BitmapWorkerTask.OnImageLoadedListener((Runnable)var2_2){
                final /* synthetic */ Runnable a;
                {
                    this.a = runnable;
                }

                @Override
                public void onImageLoaded() {
                    d d10 = runnable;
                    d10.AnnotationLayout.this.enableButtons();
                    d10.AnnotationLayout.this.setBorder();
                    Runnable runnable = d10.a;
                    if (runnable != null) {
                        runnable.run();
                    }
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setBitmap(Bitmap bitmap) {
        AnnotationView annotationView = this.annotationView;
        if (annotationView != null) {
            void var1_1;
            annotationView.setImageBitmap((Bitmap)var1_1);
        }
        AnnotationLayout annotationLayout = this;
        annotationLayout.enableButtons();
        annotationLayout.setBorder();
    }

    @Nullable
    public Bitmap getAnnotatedBitmap() {
        Object this_ = this_.annotationView;
        if (this_ != null) {
            return ((AnnotationView)((Object)this_)).f();
        }
        return null;
    }

    @Nullable
    protected Parcelable onSaveInstanceState() {
        Bundle bundle;
        Bundle bundle2 = bundle;
        bundle2();
        bundle.putParcelable(ANNOTATION_LAYOUT, super.onSaveInstanceState());
        AnnotationView this_ = ((AnnotationLayout)((Object)this_)).annotationView;
        if (this_ != null) {
            bundle2.putSerializable(DRAWING_MODE, (Serializable)((Object)this_.getDrawingMode()));
        }
        return bundle2;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        ColorPickerPopUpView colorPickerPopUpView;
        AnnotationView annotationView = this.annotationView;
        if (annotationView != null && (colorPickerPopUpView = this.colorPicker) != null) {
            Bundle bundle;
            annotationView.setDrawingColor(colorPickerPopUpView.getSelectedColor());
            if (bundle instanceof Bundle) {
                bundle = bundle;
                AnnotationView.c c10 = (AnnotationView.c)((Object)bundle.getSerializable(DRAWING_MODE));
                this.resetColorSelection();
                if (c10 == AnnotationView.c.DRAW_BLUR) {
                    DrawableUtils.setDrawableTintColor(this.iconBlur, InstabugCore.getPrimaryColor());
                } else {
                    DrawableUtils.setDrawableTintColor(this.iconBrush, InstabugCore.getPrimaryColor());
                }
                bundle = bundle.getParcelable(ANNOTATION_LAYOUT);
            }
            if (bundle != null) {
                super.onRestoreInstanceState((Parcelable)bundle);
            }
        }
    }
}

