/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.logging;

import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.instabug.library.Feature;
import com.instabug.library.Instabug;
import com.instabug.library.core.eventbus.UserEventsEventBus;
import com.instabug.library.internal.storage.cache.user.UserCacheManager;
import com.instabug.library.logging.f;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.t;
import com.instabug.library.user.UserEvent;
import com.instabug.library.user.UserEventParam;
import com.instabug.library.user.g;
import com.instabug.library.util.InstabugDateFormatter;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.PoolProvider;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class InstabugUserEventLogger {
    private static volatile InstabugUserEventLogger instabugUserEventLogger;
    private static final int USER_EVENT_COUNT_LIMIT = 1000;
    private List<UserEvent> userEvents;
    private ConcurrentHashMap<String, Integer> userEventsCount;

    private InstabugUserEventLogger() {
        ConcurrentHashMap concurrentHashMap;
        CopyOnWriteArrayList copyOnWriteArrayList;
        Object this_ = copyOnWriteArrayList;
        copyOnWriteArrayList = new CopyOnWriteArrayList();
        v1.userEvents = this_;
        this_ = concurrentHashMap;
        concurrentHashMap = new ConcurrentHashMap();
        v1.userEventsCount = this_;
    }

    public static synchronized InstabugUserEventLogger getInstance() {
        if (instabugUserEventLogger == null) {
            instabugUserEventLogger = new InstabugUserEventLogger();
        }
        return instabugUserEventLogger;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    private void runInsertionHandlerAvailable(String uuid, boolean anonymous) {
        if (Instabug.getApplicationContext() == null) return;
        try {
            for (Map.Entry<String, Integer> entry : this.userEventsCount.entrySet()) {
                void var2_3;
                void var1_2;
                this.incrementEventLoggingCount(entry.getKey(), entry.getValue(), (String)var1_2, (boolean)var2_3);
            }
            this.userEventsCount.clear();
            return;
        }
        catch (Throwable throwable) {
            InstabugSDKLogger.e("IBG-Core", "Error: " + throwable.getMessage() + "while inserting user events");
        }
    }

    /*
     * WARNING - void declaration
     */
    private void incrementEventLoggingCount(@NonNull String eventIdentifier, int incrementBy, String uuid, boolean anonymous) {
        void var4_5;
        void var3_4;
        void var2_3;
        void var1_2;
        int n10 = f.b((String)var1_2, g.i()) + var2_3;
        if (com.instabug.library.internal.storage.cache.user.a.a(uuid) == null) {
            UserCacheManager.insertIfNotExists((String)var3_4, SettingsManager.getInstance().getSessionsCount());
        }
        f.a((String)var1_2, n10, (String)var3_4, (boolean)var4_5);
        UserEventsEventBus.getInstance().post(new UserEvent().setEventIdentifier((String)var1_2));
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$200(InstabugUserEventLogger x02, String x12, boolean x22) {
        void var2_2;
        void var1_1;
        x02.runInsertionHandlerAvailable((String)var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void logUserEvent(@NonNull String eventIdentifier, UserEventParam ... userEventParams) {
        void var2_2;
        void var1_1;
        PoolProvider.getUserActionsExecutor().execute(new Runnable((String)var1_1, (UserEventParam[])var2_2){
            final /* synthetic */ String a;
            final /* synthetic */ UserEventParam[] b;
            {
                this.a = string2;
                this.b = userEventParamArray;
            }

            @Override
            public void run() {
                if (t.c().b((Object)"USER_EVENTS") == Feature.State.ENABLED) {
                    Object object = new UserEvent().setEventIdentifier(this.a).setDate(InstabugDateFormatter.getCurrentUTCTimeStampInMiliSeconds());
                    UserEventParam[] userEventParamArray = this.b;
                    int n10 = this.b.length;
                    for (int i10 = 0; i10 < n10; ++i10) {
                        ((UserEvent)object).addParam(userEventParamArray[i10]);
                    }
                    if (InstabugUserEventLogger.this.userEvents.size() >= 1000) {
                        InstabugUserEventLogger.this.userEvents.remove(0);
                    }
                    a a10 = this;
                    a10.InstabugUserEventLogger.this.userEvents.add(object);
                    object = (Integer)a10.InstabugUserEventLogger.this.userEventsCount.get(this.a);
                    if (object != null) {
                        InstabugUserEventLogger.this.userEventsCount.put(this.a, (Integer)object + 1);
                    } else {
                        InstabugUserEventLogger.this.userEventsCount.put(this.a, 1);
                    }
                    InstabugUserEventLogger.access$200(InstabugUserEventLogger.this, g.j(), g.n() ^ true);
                }
            }
        });
    }

    @VisibleForTesting
    int getLoggingEventCount(@NonNull String userEventIdentifier) {
        return f.b(userEventIdentifier, g.i());
    }

    public List<UserEvent> getUserEvents() throws IllegalStateException {
        return this.userEvents;
    }

    /*
     * WARNING - void declaration
     */
    public List<UserEvent> getUserEvents(float percentage) throws IllegalStateException {
        void var1_2;
        int n10 = Math.round((float)(var1_2 * 1000.0f));
        if (this.userEvents.size() <= n10) {
            return this.userEvents;
        }
        InstabugUserEventLogger instabugUserEventLogger = this;
        int n11 = instabugUserEventLogger.userEvents.size() - n10;
        List<UserEvent> list = instabugUserEventLogger.userEvents;
        return list.subList(n11, list.size());
    }

    public void clearAll() throws IllegalStateException {
        this.userEvents.clear();
    }

    public void clearLoggingData() throws IllegalStateException {
        f.a(g.i());
    }
}

