/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library;

import android.annotation.SuppressLint;
import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.instabug.library.Feature;
import com.instabug.library.Instabug;
import com.instabug.library.InstabugState;
import com.instabug.library.InstabugStateProvider;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.eventbus.CurrentActivityLifeCycleEventBus;
import com.instabug.library.core.eventbus.SessionStateEventBus;
import com.instabug.library.core.eventbus.coreeventbus.IBGCoreEventPublisher;
import com.instabug.library.core.eventbus.coreeventbus.IBGSdkCoreEvent;
import com.instabug.library.core.eventbus.eventpublisher.IBGDisposable;
import com.instabug.library.d0;
import com.instabug.library.internal.orchestrator.ActionsOrchestrator;
import com.instabug.library.internal.orchestrator.l;
import com.instabug.library.internal.video.InternalAutoScreenRecorderHelper;
import com.instabug.library.internal.video.f;
import com.instabug.library.model.common.Session;
import com.instabug.library.model.session.NullSessionException;
import com.instabug.library.model.session.SessionLocalEntity;
import com.instabug.library.model.session.SessionMapper;
import com.instabug.library.model.session.SessionState;
import com.instabug.library.session.h;
import com.instabug.library.sessioncontroller.a;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.t;
import com.instabug.library.tracking.ActivityLifeCycleEvent;
import com.instabug.library.tracking.s0;
import com.instabug.library.user.g;
import com.instabug.library.util.DeviceStateProvider;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.PoolProvider;
import io.reactivexport.b;
import io.reactivexport.schedulers.Schedulers;
import io.reactivexport.u;
import io.reactivexport.v;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public class e0 {
    @Nullable
    private static e0 d;
    private final SettingsManager a;
    @Nullable
    @VisibleForTesting
    IBGDisposable b;
    @Nullable
    private com.instabug.library.model.common.a c;

    private e0(SettingsManager settingsManager) {
        e0 e02 = this;
        e02.a = settingsManager;
        e02.p();
    }

    public static synchronized e0 e() {
        e0 e02 = d;
        if (e02 == null) {
            e0 e03;
            e02 = e03;
            d = new e0(SettingsManager.getInstance());
        }
        return e02;
    }

    public static synchronized void a(SettingsManager settingsManager) {
        if (d == null) {
            d = new e0(settingsManager);
        }
    }

    private void i() {
        if (this.a.getSessionStartedAt() != 0L) {
            com.instabug.library.model.common.a a10 = this.c;
            if (a10 != null) {
                e0 e02 = this;
                e02.a(a10);
                e02.l();
                e02.m();
                e02.a(SessionState.FINISH);
            }
        } else {
            InstabugSDKLogger.d("IBG-Core", "Instabug is enabled after session started, Session ignored");
        }
        this.n();
    }

    private void n() {
        this.c(null);
    }

    private void m() {
        long l10 = System.currentTimeMillis();
        InstabugCore.setLastSeenTimestamp(l10);
        ActionsOrchestrator.obtainOrchestrator(PoolProvider.getSingleThreadExecutor("last-seen-record")).addWorkerThreadAction(new l(g.i(), l10)).orchestrate();
    }

    private void a(@NonNull com.instabug.library.model.common.a a10) {
        if (SettingsManager.getInstance().isSessionEnabled()) {
            this.b(a10).a((Object sessionLocalEntity) -> {
                if (sessionLocalEntity != null) {
                    return new h().a((SessionLocalEntity)sessionLocalEntity);
                }
                return io.reactivexport.b.a(new NullSessionException("sessionLocalEntity can't be null!"));
            }).a(Schedulers.io()).a(new d0(this));
        }
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    private u b(@NonNull com.instabug.library.model.common.a a10) {
        return u.a((v v10) -> {
            Context context = Instabug.getApplicationContext();
            boolean bl = InstabugCore.isUsersPageEnabled();
            if (context != null) {
                v10.onSuccess(new SessionLocalEntity.Factory().create(context, a10, bl));
            }
        });
    }

    private void q() {
        long l10 = System.currentTimeMillis() / 1000L;
        ((e0)((Object)string2)).a.setSessionStartedAt(l10);
        if (SettingsManager.getInstance().isFirstRun()) {
            ((e0)((Object)string2)).a.setIsFirstRun(false);
        }
        if (SettingsManager.getInstance().getFirstRunAt().getTime() == 0L) {
            ((e0)((Object)string2)).a.setFirstRunAt(System.currentTimeMillis());
        }
        ((e0)((Object)string2)).a.incrementSessionsCount();
        String string2 = g.i();
        ActionsOrchestrator.obtainOrchestrator().addWorkerThreadAction(new l(string2, l10 *= 1000L)).orchestrate();
    }

    private void l() {
        if (SettingsManager.getInstance().isFirstDismiss()) {
            SettingsManager.getInstance().setIsFirstDismiss(false);
        }
    }

    private void a(SessionState sessionState) {
        if (sessionState.equals((Object)SessionState.FINISH)) {
            SettingsManager.getInstance().setIsAppOnForeground(false);
            IBGCoreEventPublisher.post(IBGSdkCoreEvent.Session.SessionFinished.INSTANCE);
        } else {
            SettingsManager.getInstance().setIsAppOnForeground(true);
            IBGCoreEventPublisher.post(IBGSdkCoreEvent.Session.SessionStarted.INSTANCE);
        }
        SessionStateEventBus.getInstance().post(sessionState);
    }

    private void p() {
        this.b = CurrentActivityLifeCycleEventBus.INSTANCE.subscribe(activityLifeCycleEvent -> {
            if (activityLifeCycleEvent == ActivityLifeCycleEvent.STOPPED) {
                this.h();
            }
        });
    }

    private int f() {
        return s0.b().getCount();
    }

    private void b(boolean bl) {
        SettingsManager.getInstance().setIsFirstSession(bl);
    }

    @NonNull
    private com.instabug.library.model.common.a a() {
        Object object = this.c;
        if (object != null) {
            return object;
        }
        this.q();
        object = Instabug.getApplicationContext();
        String string2 = UUID.randomUUID().toString();
        String string3 = DeviceStateProvider.getOS();
        String string4 = g.i();
        object = object != null ? DeviceStateProvider.getAppVersion((Context)object) : null;
        long l10 = TimeUnit.MILLISECONDS.toMicros(System.currentTimeMillis());
        long l11 = System.nanoTime();
        boolean bl = this.k();
        return SessionMapper.toSession(string2, string3, string4, (String)object, l10, l11, bl);
    }

    private void c(@Nullable com.instabug.library.model.common.a a10) {
        this.c = a10;
    }

    private boolean k() {
        if (!t.c().h()) {
            return false;
        }
        long l10 = SettingsManager.getInstance().getSessionStitchingTimeoutInSeconds(1800);
        long l11 = this.g();
        if (l11 != -1L && l11 <= l10) {
            InstabugSDKLogger.v("IBG-Core", "session stitched");
            return false;
        }
        InstabugSDKLogger.v("IBG-Core", "started new billable session");
        return true;
    }

    private long g() {
        long l10 = SettingsManager.getInstance().geLastForegroundTime();
        if (l10 != -1L) {
            return (System.currentTimeMillis() - l10) / 1000L;
        }
        return l10;
    }

    static /* synthetic */ void a(e0 e02, boolean bl) {
        e02.b(bl);
    }

    public long d() {
        if (this.a.getSessionStartedAt() == 0L) {
            return 0L;
        }
        return System.currentTimeMillis() / 1000L - this.a.getSessionStartedAt();
    }

    public synchronized void b() {
        if (t.c().b((Object)"INSTABUG") == Feature.State.ENABLED) {
            SettingsManager.getInstance().setInBackground(true);
            if (t.c().h()) {
                SettingsManager.getInstance().setLastForegroundTime(System.currentTimeMillis());
            }
            this.i();
        }
    }

    public synchronized void o() {
        InstabugSDKLogger.d("IBG-Core", "Instabug is disabled during app session, ending current session");
        SettingsManager.getInstance().setInBackground(false);
        this.i();
    }

    public synchronized void j() {
        this.a(false);
    }

    public synchronized void a(boolean bl) {
        if (com.instabug.library.sessioncontroller.a.d() && !bl) {
            return;
        }
        if (!InstabugStateProvider.getInstance().getState().equals((Object)InstabugState.BUILDING)) {
            e0 e02 = this;
            e02.c(e02.a());
            e02.a(SessionState.START);
            if (SettingsManager.getInstance().autoScreenRecordingEnabled()) {
                InternalAutoScreenRecorderHelper.getInstance().start();
            }
        }
    }

    @VisibleForTesting
    void h() {
        Context context = Instabug.getApplicationContext();
        if (context != null) {
            t.c().g(context);
        } else {
            InstabugSDKLogger.e("IBG-Core", "unable to saveFeaturesToSharedPreferences due to null appContext");
        }
        if (this.f() == 0 && Instabug.getApplicationContext() != null && f.a(Instabug.getApplicationContext())) {
            PoolProvider.postIOTask(this::b);
        }
    }

    @Nullable
    public synchronized Session c() {
        return this.c;
    }
}

