/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.annotation;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RectShape;
import android.graphics.drawable.shapes.Shape;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import com.instabug.library.Instabug;
import com.instabug.library.R;
import com.instabug.library.annotation.AnnotationView;
import com.instabug.library.annotation.ColorPickerPopUpView;
import com.instabug.library.annotation.ShapeSuggestionsLayout;
import com.instabug.library.util.AccessibilityUtils;
import com.instabug.library.util.AttrResolver;
import com.instabug.library.util.BitmapUtils;
import com.instabug.library.util.BitmapWorkerTask;
import com.instabug.library.util.DrawableUtils;
import com.instabug.library.view.IconView;
import com.instabug.library.view.ViewUtils;
import java.io.Serializable;

public class AnnotationLayout
extends LinearLayout
implements View.OnClickListener {
    private static final String ANNOTATION_LAYOUT = "instabug_annotation_layout";
    private static final String DRAWING_MODE = "drawingMode";
    private AnnotationView annotationView;
    private ColorPickerPopUpView colorPicker;
    private int tintingColor;
    private LinearLayout annotationActionsContainer;
    private RelativeLayout iconBrushLayout;
    private ImageView iconBrush;
    private ImageView iconMagnify;
    private ImageView iconBlur;
    private ImageView iconUndo;
    private View brushIndicator;
    private View border;
    private ShapeSuggestionsLayout shapeSuggestionsLayout;

    /*
     * WARNING - void declaration
     */
    public AnnotationLayout(Context context) {
        this((Context)var1_1, null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public AnnotationLayout(Context context, @Nullable AttributeSet attrs) {
        this((Context)var1_1, (AttributeSet)var2_2, 0);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public AnnotationLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        void var3_3;
        void var2_2;
        void var1_1;
        AnnotationLayout annotationLayout = this;
        super((Context)var1_1, (AttributeSet)var2_2, (int)var3_3);
        annotationLayout.initViews();
    }

    /*
     * WARNING - void declaration
     */
    @TargetApi(value=21)
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public AnnotationLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        AnnotationLayout annotationLayout = this;
        super((Context)var1_1, (AttributeSet)var2_2, (int)var3_3, (int)var4_4);
        annotationLayout.initViews();
    }

    private void initViews() {
        AnnotationLayout annotationLayout = this;
        LinearLayout.inflate((Context)annotationLayout.getContext(), (int)R.layout.instabug_annotation_view, (ViewGroup)this);
        annotationLayout.annotationActionsContainer = (LinearLayout)annotationLayout.findViewById(R.id.instabug_annotation_actions_container);
        this.shapeSuggestionsLayout = (ShapeSuggestionsLayout)annotationLayout.findViewById(R.id.shapeSuggestionsLayout);
        this.shapeSuggestionsLayout.setOnShapeSelectedListener(new ShapeSuggestionsLayout.e(){

            @Override
            public void a(int n2) {
                if (n2 == 1) {
                    AnnotationLayout.this.annotationView.b();
                }
            }
        });
        annotationLayout.iconBrushLayout = (RelativeLayout)annotationLayout.findViewById(R.id.icon_brush_layout);
        annotationLayout.iconBrush = (ImageView)annotationLayout.findViewById(R.id.icon_brush);
        annotationLayout.iconMagnify = (ImageView)annotationLayout.findViewById(R.id.icon_magnify);
        annotationLayout.iconBlur = (ImageView)annotationLayout.findViewById(R.id.icon_blur);
        annotationLayout.iconUndo = (ImageView)annotationLayout.findViewById(R.id.icon_undo);
        annotationLayout.iconBrush.setEnabled(false);
        annotationLayout.iconMagnify.setEnabled(false);
        annotationLayout.iconBlur.setEnabled(false);
        annotationLayout.iconUndo.setEnabled(false);
        if (AccessibilityUtils.isAccessibilityServiceEnabled()) {
            ViewCompat.setAccessibilityDelegate((View)this.iconBrush, (AccessibilityDelegateCompat)new AccessibilityDelegateCompat(this){

                public void onInitializeAccessibilityNodeInfo(View view, AccessibilityNodeInfoCompat accessibilityNodeInfoCompat) {
                    super.onInitializeAccessibilityNodeInfo(view, accessibilityNodeInfoCompat);
                    accessibilityNodeInfoCompat.setRoleDescription((CharSequence)"Button");
                }
            });
        }
        AnnotationLayout annotationLayout2 = this;
        annotationLayout2.border = annotationLayout2.findViewById(R.id.instabug_annotation_image_border);
        annotationLayout2.annotationView = (AnnotationView)annotationLayout2.findViewById(R.id.instabug_annotation_image);
        annotationLayout2.colorPicker = (ColorPickerPopUpView)annotationLayout2.findViewById(R.id.instabug_color_picker);
        annotationLayout2.brushIndicator = annotationLayout2.findViewById(R.id.brush_indicator);
        annotationLayout2.annotationView.setDrawingMode(AnnotationView.c.DRAW_PATH);
        DrawableUtils.setDrawableTintColor(annotationLayout2.iconBrush, Instabug.getPrimaryColor());
        annotationLayout2.annotationView.setDrawingColor(this.colorPicker.getSelectedColor());
        annotationLayout2.annotationView.setOnActionDownListener(new AnnotationView.f(){

            @Override
            public void a() {
                if (AnnotationLayout.this.colorPicker.getVisibility() == 0) {
                    AnnotationLayout.this.colorPicker.setVisibility(8);
                }
                AnnotationLayout.this.shapeSuggestionsLayout.a();
            }
        });
        annotationLayout2.annotationView.setOnPathRecognizedListener(new AnnotationView.h(){

            @Override
            public void a(Path path, Path path2) {
                AnnotationLayout.access$300(AnnotationLayout.this, new Path[]{path, path2});
            }
        });
        annotationLayout2.annotationView.setOnNewMagnifierAddingA\u0650\u0650\u0650bilityChangedListener(new AnnotationView.g(){

            @Override
            public void a(boolean bl) {
                AnnotationLayout.this.iconMagnify.setEnabled(bl);
            }
        });
        annotationLayout2.colorPicker.setOnColorSelectionListener(new ColorPickerPopUpView.c(){

            @Override
            public void a(@ColorInt int n2, int n3) {
                f f2 = this;
                f2.AnnotationLayout.this.annotationView.setDrawingColor(n2);
                f2.AnnotationLayout.this.colorPicker.setVisibility(8);
                f2.AnnotationLayout.this.brushIndicator.setBackgroundColor(n2);
            }
        });
        annotationLayout2.colorPicker.setPopUpBackgroundColor(AttrResolver.resolveAttributeColor(this.getContext(), R.attr.ib_annotation_color_picker_bg_color));
        annotationLayout2.iconBrushLayout.setOnClickListener((View.OnClickListener)this);
        annotationLayout2.iconMagnify.setOnClickListener((View.OnClickListener)this);
        annotationLayout2.iconBlur.setOnClickListener((View.OnClickListener)this);
        annotationLayout2.iconUndo.setOnClickListener((View.OnClickListener)this);
        annotationLayout2.setViewSelector(annotationLayout2.iconMagnify);
        annotationLayout2.setViewSelector(annotationLayout2.iconUndo);
        annotationLayout2.tintingColor = ContextCompat.getColor((Context)annotationLayout2.getContext(), (int)R.color.ib_core_annotation_tinting_color);
    }

    /*
     * WARNING - void declaration
     */
    private void showShapeSuggestions(Path ... paths) {
        void var1_1;
        this.shapeSuggestionsLayout.removeAllViews();
        for (int i2 = 0; i2 < ((void)var1_1).length; ++i2) {
            ShapeSuggestionsLayout shapeSuggestionsLayout = this.shapeSuggestionsLayout;
            int n2 = i2 == 0 ? R.string.ibg_bug_annotation_original_shape_content_description : R.string.ibg_bug_annotation_recognized_shape_content_description;
            shapeSuggestionsLayout.a(n2, (Path)var1_1[i2]);
        }
        this.shapeSuggestionsLayout.b();
    }

    private void setBorder() {
        ShapeDrawable shapeDrawable;
        AnnotationLayout annotationLayout = this;
        int n2 = ViewUtils.convertDpToPx(annotationLayout.getContext(), 4.0f);
        int n3 = ViewUtils.convertDpToPx(annotationLayout.getContext(), 2.0f);
        ShapeDrawable shapeDrawable2 = shapeDrawable;
        new ShapeDrawable().setShape((Shape)new RectShape());
        shapeDrawable2.getPaint().setColor(Instabug.getPrimaryColor());
        shapeDrawable2.getPaint().setStyle(Paint.Style.STROKE);
        shapeDrawable2.getPaint().setStrokeWidth((float)n2);
        int n4 = n3;
        annotationLayout.border.setPadding(n4, n4, n4, n4);
        if (Build.VERSION.SDK_INT >= 16) {
            this.border.setBackground((Drawable)shapeDrawable2);
        } else {
            this.border.setBackgroundDrawable((Drawable)shapeDrawable2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setViewSelector(ImageView viewSelector) {
        void var1_1;
        View.OnTouchListener onTouchListener;
        View.OnTouchListener onTouchListener2 = onTouchListener;
        onTouchListener = new View.OnTouchListener((ImageView)var1_1){
            final /* synthetic */ ImageView a;
            {
                this.a = imageView;
            }

            public boolean onTouch(View view, MotionEvent motionEvent) {
                if (motionEvent.getAction() == 0) {
                    DrawableUtils.setDrawableTintColor(this.a, Instabug.getPrimaryColor());
                } else if (motionEvent.getAction() == 1) {
                    DrawableUtils.setDrawableTintColor(this.a, AnnotationLayout.this.tintingColor);
                }
                return false;
            }
        };
        viewSelector.setOnTouchListener(onTouchListener2);
    }

    private void switchColorPickerVisibility() {
        Object this_ = this_.colorPicker;
        int n2 = this_.getVisibility() == 0 ? 8 : 0;
        this_.setVisibility(n2);
    }

    private void hideColorPicker() {
        if (this.colorPicker.getVisibility() == 0) {
            this.colorPicker.setVisibility(8);
        }
    }

    private void resetColorSelection() {
        int n2 = this.annotationActionsContainer.getChildCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!(this.annotationActionsContainer.getChildAt(i2) instanceof IconView)) continue;
            ((TextView)this.annotationActionsContainer.getChildAt(i2)).setTextColor(this.tintingColor);
        }
        AnnotationLayout annotationLayout = this;
        DrawableUtils.setDrawableTintColor(annotationLayout.iconBrush, this.tintingColor);
        DrawableUtils.setDrawableTintColor(annotationLayout.iconBlur, this.tintingColor);
    }

    private void enableButtons() {
        AnnotationLayout annotationLayout = this;
        annotationLayout.iconBrush.setEnabled(true);
        annotationLayout.iconMagnify.setEnabled(true);
        annotationLayout.iconBlur.setEnabled(true);
        annotationLayout.iconUndo.setEnabled(true);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$300(AnnotationLayout x0, Path[] x1) {
        void var1_1;
        x0.showShapeSuggestions((Path[])var1_1);
    }

    public void onClick(View v2) {
        this.shapeSuggestionsLayout.a();
        int n2 = v2.getId();
        if (n2 == R.id.icon_brush_layout) {
            AnnotationLayout annotationLayout = this;
            annotationLayout.switchColorPickerVisibility();
            annotationLayout.annotationView.setDrawingMode(AnnotationView.c.DRAW_PATH);
            annotationLayout.resetColorSelection();
            DrawableUtils.setDrawableTintColor(annotationLayout.iconBrush, Instabug.getPrimaryColor());
        } else if (n2 == R.id.icon_magnify) {
            AnnotationLayout annotationLayout = this;
            annotationLayout.annotationView.a();
            annotationLayout.hideColorPicker();
        } else if (n2 == R.id.icon_blur) {
            AnnotationLayout annotationLayout = this;
            annotationLayout.annotationView.setDrawingMode(AnnotationView.c.DRAW_BLUR);
            annotationLayout.resetColorSelection();
            DrawableUtils.setDrawableTintColor(annotationLayout.iconBlur, Instabug.getPrimaryColor());
            annotationLayout.hideColorPicker();
        } else if (n2 == R.id.icon_undo) {
            AnnotationLayout annotationLayout = this;
            annotationLayout.annotationView.d();
            annotationLayout.hideColorPicker();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setBaseImage(@NonNull Uri imageUri, @Nullable Runnable runnable) {
        if (imageUri.getPath() != null) {
            void var2_2;
            void var1_1;
            BitmapUtils.loadBitmap(var1_1.getPath(), (ImageView)this.annotationView, new BitmapWorkerTask.OnImageLoadedListener((Runnable)var2_2){
                final /* synthetic */ Runnable a;
                {
                    this.a = runnable;
                }

                @Override
                public void onImageLoaded() {
                    h h2 = runnable;
                    h2.AnnotationLayout.this.enableButtons();
                    h2.AnnotationLayout.this.setBorder();
                    Runnable runnable = h2.a;
                    if (runnable != null) {
                        runnable.run();
                    }
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setBitmap(Bitmap bitmap) {
        void var1_1;
        AnnotationLayout annotationLayout = this;
        annotationLayout.annotationView.setImageBitmap((Bitmap)var1_1);
        annotationLayout.enableButtons();
        annotationLayout.setBorder();
    }

    @Nullable
    public Bitmap getAnnotatedBitmap() {
        return this.annotationView.c();
    }

    @Nullable
    protected Parcelable onSaveInstanceState() {
        Bundle bundle;
        Bundle bundle2 = bundle;
        bundle2();
        bundle2.putParcelable(ANNOTATION_LAYOUT, super.onSaveInstanceState());
        bundle.putSerializable(DRAWING_MODE, (Serializable)this.annotationView.getDrawingMode());
        return bundle;
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    protected void onRestoreInstanceState(Parcelable state) {
        Bundle bundle;
        this.annotationView.setDrawingColor(this.colorPicker.getSelectedColor());
        if (state instanceof Bundle) {
            bundle = bundle;
            AnnotationView.c c2 = (AnnotationView.c)bundle.getSerializable(DRAWING_MODE);
            this.resetColorSelection();
            if (c2 == AnnotationView.c.DRAW_BLUR) {
                DrawableUtils.setDrawableTintColor(this.iconBlur, Instabug.getPrimaryColor());
            } else {
                DrawableUtils.setDrawableTintColor(this.iconBrush, Instabug.getPrimaryColor());
            }
            bundle = bundle.getParcelable(ANNOTATION_LAYOUT);
        }
        super.onRestoreInstanceState((Parcelable)bundle);
    }
}

