/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.model.session;

import android.annotation.SuppressLint;
import android.content.ContentValues;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.library.internal.utils.stability.execution.ReturnableExecutable;
import com.instabug.library.internal.utils.stability.handler.exception.ExceptionHandler;
import com.instabug.library.model.session.CoreSession;
import com.instabug.library.model.session.SessionLocalEntity;
import com.instabug.library.model.session.SessionRemoteEntity;
import com.instabug.library.model.session.SessionsBatchDTO;
import com.instabug.library.network.NetworkManager;
import com.instabug.library.network.Request;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Keep
public class SessionMapper {
    private SessionMapper() {
    }

    @NonNull
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public static SessionRemoteEntity toRemoteEntity(@NonNull CoreSession session) {
        CoreSession coreSession;
        HashMap<String, Object> hashMap;
        HashMap<String, Object> hashMap2 = hashMap;
        hashMap2();
        hashMap2.put("os", coreSession.getOs());
        hashMap2.put("device", coreSession.getDevice());
        hashMap2.put("duration", coreSession.getDuration());
        hashMap2.put("started_at", coreSession.getStartTimestampMicros());
        hashMap2.put("name", coreSession.getUserName());
        hashMap2.put("email", coreSession.getUserEmail());
        hashMap2.put("sdk_version", coreSession.getSdkVersion());
        hashMap.put("app_version", coreSession.getAppVersion());
        String string2 = session.isUsersPageEnabled() ? "user_events" : "user_event_keys";
        hashMap2.put(string2, coreSession.getUserEvents());
        string2 = coreSession.isUsersPageEnabled() ? "custom_attributes" : "custom_attribute_keys";
        hashMap2.put(string2, coreSession.getCustomAttributes());
        hashMap2.put("crash_reporting_enabled", coreSession.isCrashReportingEnabled());
        hashMap2.put("uuid", coreSession.getUuid());
        hashMap2.put("application_token", coreSession.getAppToken());
        return SessionMapper.toRemoteEntity(coreSession.getId(), hashMap2);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static SessionRemoteEntity toRemoteEntity(String id2, @NonNull Map<String, Object> map) {
        void var1_1;
        String string2;
        return new SessionRemoteEntity(string2, (Map<String, Object>)var1_1);
    }

    @NonNull
    public static SessionsBatchDTO toDTO(@NonNull SessionRemoteEntity session) {
        SessionRemoteEntity sessionRemoteEntity;
        return SessionMapper.toDTO(Collections.emptyMap(), Collections.singletonList(sessionRemoteEntity));
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static SessionsBatchDTO toDTO(@NonNull Map<String, Object> commonKeys, @NonNull List<SessionRemoteEntity> sessions) {
        void var1_1;
        Map<String, Object> map;
        return new SessionsBatchDTO(map, (List<SessionRemoteEntity>)var1_1);
    }

    @NonNull
    public static CoreSession toModel(@NonNull SessionLocalEntity entity) {
        SessionLocalEntity sessionLocalEntity;
        SessionLocalEntity sessionLocalEntity2 = sessionLocalEntity;
        Object object = sessionLocalEntity2.getId();
        String string2 = sessionLocalEntity2.getUuid();
        String string3 = sessionLocalEntity2.getOs();
        object = new CoreSession.Builder((String)object, string2, string3).setDevice(sessionLocalEntity.getDevice()).setDuration(sessionLocalEntity.getDuration()).setStartTimestampMicros(sessionLocalEntity.getStartTimestampMicros()).setUserName(sessionLocalEntity.getUserName()).setUserEmail(sessionLocalEntity.getUserEmail()).setSdkVersion(sessionLocalEntity.getSdkVersion()).setAppVersion(sessionLocalEntity.getAppVersion());
        string2 = entity.isUsersPageEnabled() ? sessionLocalEntity.getUserEvents() : sessionLocalEntity.getUserEventsKeys();
        object = ((CoreSession.Builder)object).setUserEvents(string2);
        string2 = sessionLocalEntity.isUsersPageEnabled() ? sessionLocalEntity.getCustomAttributes() : sessionLocalEntity.getCustomAttributesKeys();
        return ((CoreSession.Builder)object).setCustomAttributes(string2).setCrashReportingEnabled(sessionLocalEntity.isCrashReportingEnabled()).setSyncStatus(sessionLocalEntity.getSyncStatus()).setAppToken(sessionLocalEntity.getAppToken()).setUsersPageEnabled(sessionLocalEntity.isUsersPageEnabled()).setProductionUsage(sessionLocalEntity.getProductionUsage()).build();
    }

    @NonNull
    public static List<CoreSession> toModels(@NonNull List<SessionLocalEntity> entities) {
        ArrayList<CoreSession> arrayList;
        ArrayList<CoreSession> arrayList2 = arrayList;
        arrayList = new ArrayList<CoreSession>();
        Iterator<SessionLocalEntity> iterator = entities.iterator();
        while (iterator.hasNext()) {
            arrayList2.add(SessionMapper.toModel(iterator.next()));
        }
        return arrayList2;
    }

    @NonNull
    public static ContentValues toContentValues(SessionLocalEntity entity) {
        String string2;
        ContentValues contentValues;
        ContentValues contentValues2;
        ContentValues contentValues3 = contentValues2 = contentValues;
        contentValues2();
        contentValues2.put("session_id", ((SessionLocalEntity)((Object)string2)).getId());
        contentValues2.put("started_at", Long.valueOf(((SessionLocalEntity)((Object)string2)).getStartTimestampMicros()));
        contentValues2.put("duration", Long.valueOf(((SessionLocalEntity)((Object)string2)).getDuration()));
        contentValues2.put("user_attributes", ((SessionLocalEntity)((Object)string2)).getUserEvents());
        contentValues2.put("user_events", ((SessionLocalEntity)((Object)string2)).getCustomAttributes());
        contentValues2.put("user_attributes_keys", ((SessionLocalEntity)((Object)string2)).getUserEventsKeys());
        contentValues2.put("user_events_keys", ((SessionLocalEntity)((Object)string2)).getCustomAttributesKeys());
        contentValues2.put("user_email", ((SessionLocalEntity)((Object)string2)).getUserEmail());
        contentValues2.put("user_name", ((SessionLocalEntity)((Object)string2)).getUserName());
        contentValues2.put("uuid", ((SessionLocalEntity)((Object)string2)).getUuid());
        contentValues2.put("app_token", ((SessionLocalEntity)((Object)string2)).getAppToken());
        contentValues2.put("os", ((SessionLocalEntity)((Object)string2)).getOs());
        contentValues2.put("device", ((SessionLocalEntity)((Object)string2)).getDevice());
        contentValues2.put("sdk_version", ((SessionLocalEntity)((Object)string2)).getSdkVersion());
        contentValues3.put("app_version", ((SessionLocalEntity)((Object)string2)).getAppVersion());
        contentValues3.put("crash_reporting_enabled", Integer.valueOf(((SessionLocalEntity)((Object)string2)).isCrashReportingEnabled() ? 1 : 0));
        contentValues3.put("users_page_enabled", Integer.valueOf(((SessionLocalEntity)((Object)string2)).isUsersPageEnabled() ? 1 : 0));
        contentValues.put("sync_status", Integer.valueOf(((SessionLocalEntity)((Object)string2)).getSyncStatus()));
        string2 = entity.getProductionUsage();
        if (string2 != null) {
            contentValues2.put("production_usage", string2);
        }
        return contentValues2;
    }

    @NonNull
    @SuppressLint(value={"ERADICATE_RETURN_NOT_NULLABLE"})
    public static JSONObject toJson(@NonNull SessionRemoteEntity entity) {
        JSONObject jSONObject;
        SessionRemoteEntity sessionRemoteEntity;
        ReturnableExecutable<JSONObject> returnableExecutable = new ReturnableExecutable<JSONObject>(){

            @Override
            public JSONObject execute() throws Exception {
                JSONObject jSONObject;
                a a2 = a3;
                a a3 = jSONObject;
                jSONObject = new JSONObject();
                for (Map.Entry<String, Object> entry : a2.sessionRemoteEntity.getMap().entrySet()) {
                    a3.put(entry.getKey(), SessionMapper.extractJsonValue(entry.getValue()));
                }
                return a3;
            }
        };
        sessionRemoteEntity = jSONObject;
        jSONObject = new JSONObject();
        return (JSONObject)new ExceptionHandler().withPenaltyLog().executeAndGet(returnableExecutable, sessionRemoteEntity);
    }

    @NonNull
    @SuppressLint(value={"ERADICATE_RETURN_NOT_NULLABLE"})
    public static JSONObject toJson(@NonNull SessionsBatchDTO batch) {
        JSONObject jSONObject;
        SessionsBatchDTO sessionsBatchDTO;
        ReturnableExecutable<JSONObject> returnableExecutable = new ReturnableExecutable<JSONObject>(){

            @Override
            public JSONObject execute() throws Exception {
                JSONArray jSONArray;
                b b3;
                JSONObject jSONObject;
                JSONObject jSONObject2 = jSONObject;
                jSONObject = new JSONObject();
                Object object = b3.sessionsBatchDTO.getProductionUsage();
                if (object != null) {
                    JSONObject jSONObject3;
                    JSONObject object2 = jSONObject3;
                    jSONObject3 = new JSONObject((String)object);
                    jSONObject2.put("production_usage", (Object)object2);
                }
                for (Map.Entry entry : b3.sessionsBatchDTO.getCommonKeys().entrySet()) {
                    jSONObject2.put((String)entry.getKey(), SessionMapper.extractJsonValue(entry.getValue()));
                }
                b b2 = b3;
                b3 = jSONArray;
                jSONArray = new JSONArray();
                object = b2.sessionsBatchDTO.getSessions().iterator();
                while (object.hasNext()) {
                    b3.put(SessionMapper.toJson(object.next()));
                }
                JSONObject jSONObject4 = jSONObject2;
                jSONObject4.put("sessions", (Object)b3);
                return jSONObject4;
            }
        };
        sessionsBatchDTO = jSONObject;
        jSONObject = new JSONObject();
        return (JSONObject)new ExceptionHandler().withPenaltyLog().executeAndGet(returnableExecutable, sessionsBatchDTO);
    }

    @NonNull
    @SuppressLint(value={"ERADICATE_RETURN_NOT_NULLABLE"})
    public static Request toRequest(@NonNull JSONObject batch) {
        JSONObject jSONObject;
        Request request;
        final Request request2 = request;
        new Request(Request.Endpoint.SEND_SESSION, NetworkManager.RequestType.NORMAL).setRequestMethod(Request.RequestMethod.Post);
        return new ExceptionHandler().withPenaltyLog().executeAndGet(new ReturnableExecutable<Request>(){

            @Override
            public Request execute() throws Exception {
                Iterator iterator = jSONObject.keys();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    request2.addRequestBodyParameter(string2, jSONObject.get(string2));
                }
                return request2;
            }
        }, request2);
    }

    @NonNull
    public static SessionLocalEntity toLocalEntity(ContentValues contentValues) {
        SessionLocalEntity sessionLocalEntity;
        Object object;
        ContentValues contentValues2 = contentValues;
        String string2 = contentValues2.getAsString("session_id");
        String string3 = contentValues2.getAsString("os");
        String string4 = contentValues2.getAsString("device");
        long l2 = contentValues2.getAsLong("duration");
        long l3 = contentValues2.getAsLong("started_at");
        String string5 = contentValues2.getAsString("user_name");
        String string6 = contentValues2.getAsString("user_email");
        String string7 = contentValues2.getAsString("sdk_version");
        String string8 = contentValues2.getAsString("app_version");
        String string9 = contentValues2.getAsString("user_attributes");
        String string10 = contentValues2.getAsString("user_events");
        String string11 = contentValues2.getAsString("user_attributes_keys");
        String string12 = contentValues2.getAsString("user_events_keys");
        boolean bl = contentValues2.getAsInteger("crash_reporting_enabled") == 1;
        ContentValues contentValues3 = object;
        int n2 = contentValues3.getAsInteger("sync_status");
        String string13 = contentValues3.getAsString("uuid");
        String string14 = contentValues3.getAsString("app_token");
        boolean bl2 = contentValues3.getAsInteger("users_page_enabled") == 1;
        SessionLocalEntity sessionLocalEntity2 = sessionLocalEntity;
        object = object.getAsString("production_usage");
        sessionLocalEntity2(string2, string3, string4, l2, l3, string5, string6, string7, string8, string9, string10, string11, string12, bl, n2, string13, string14, bl2, (String)object);
        return sessionLocalEntity2;
    }

    @NonNull
    public static List<String> toIDs(@NonNull SessionsBatchDTO batch) {
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        Iterator<SessionRemoteEntity> iterator = batch.getSessions().iterator();
        while (iterator.hasNext()) {
            arrayList2.add(iterator.next().getId());
        }
        return arrayList2;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static CoreSession toSession(@NonNull String id2, @NonNull String os, @NonNull String uuid, @Nullable String appVersion, long startTimestampMicros, long startNanoTime) {
        void var6_5;
        void var4_4;
        void var3_3;
        void var1_1;
        void var2_2;
        String string2;
        return new CoreSession.Builder(string2, (String)var2_2, (String)var1_1).setAppVersion((String)var3_3).setStartTimestampMicros((long)var4_4).setStartNanoTime((long)var6_5).build();
    }

    private static Object extractJsonValue(Object value) {
        Object object;
        if (value != null && (object.toString().contains("{") || object.toString().contains("["))) {
            try {
                return new JSONObject(object.toString());
            }
            catch (JSONException jSONException) {
                try {
                    return new JSONArray(object.toString());
                }
                catch (JSONException jSONException2) {}
            }
        }
        return object;
    }
}

