/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.storage;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Environment;
import android.util.Log;
import androidx.annotation.NonNull;
import com.instabug.library.Instabug;
import com.instabug.library.internal.storage.executor.DeleteOperationExecutor;
import com.instabug.library.internal.storage.executor.ReadOperationExecutor;
import com.instabug.library.internal.storage.executor.WriteOperationExecutor;
import com.instabug.library.internal.storage.operation.DiskOperation;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.PoolProvider;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;

@SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
public final class DiskUtils {
    public static final String TAG = "DiskUtils";
    private final Context context;

    /*
     * WARNING - void declaration
     */
    private DiskUtils(Context context) {
        void var1_1;
        this.context = var1_1;
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public static File getInstabugDirectory(Context context) {
        File file;
        Object object;
        if (context.getExternalFilesDir(null) != null && Environment.getExternalStorageState().equals("mounted")) {
            try {
                object = object.getExternalFilesDir(null).getAbsolutePath();
            }
            catch (NullPointerException nullPointerException) {
                object = DiskUtils.getInternalStoragePath(object);
                InstabugSDKLogger.w(TAG, "External storage not available, saving file to internal storage.");
            }
        } else {
            object = DiskUtils.getInternalStoragePath(object);
            InstabugSDKLogger.i(TAG, "External storage not available, saving file to internal storage.");
        }
        File file2 = file;
        if (!new File((String)object + "/instabug/").exists() && file2.mkdirs()) {
            try {
                new File(file2, ".nomedia").createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return file2;
    }

    public static synchronized File getInsatbugLogDirectory(String directoryLogName, Context context) {
        String string2;
        File file;
        String string3 = DiskUtils.getInstabugDirectory(context).getAbsolutePath().concat("/");
        File file2 = file;
        if (!new File(string3.concat(string2)).exists() && !file2.mkdir()) {
            Log.w((String)TAG, (String)"failed logs directory to create");
        }
        return file2;
    }

    private static String getInternalStoragePath(Context context) {
        return context.getFilesDir().getAbsolutePath();
    }

    /*
     * WARNING - void declaration
     */
    public static void saveBitmapOnDisk(Bitmap bitmap, File file) throws IOException {
        void var1_1;
        if (bitmap != null && var1_1 != null) {
            Bitmap bitmap2;
            FileOutputStream fileOutputStream;
            InstabugSDKLogger.addVerboseLog(DiskUtils.class, "starting save viewHierarchy image, path: " + var1_1.getAbsolutePath() + ", time in MS: " + System.currentTimeMillis());
            FileOutputStream fileOutputStream2 = fileOutputStream;
            fileOutputStream2((File)var1_1);
            bitmap2.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)fileOutputStream2);
            fileOutputStream.close();
            InstabugSDKLogger.addVerboseLog(DiskUtils.class, "viewHierarchy image saved, path: " + var1_1.getAbsolutePath() + ", time in MS: " + System.currentTimeMillis());
        }
    }

    public static void cleanDirectory(File directory) {
        File[] fileArray;
        if (directory.exists() && fileArray.isDirectory() && (fileArray = fileArray.listFiles()) != null) {
            for (File file : fileArray) {
                if (!file.delete()) continue;
                InstabugSDKLogger.v(DiskUtils.class, "file deleted successfully, path: " + file.getPath() + ", time in MS: " + System.currentTimeMillis());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @SuppressLint(value={"RESOURCE_LEAK"})
    public static void copyFromUriIntoFile(@NonNull Context context, Uri source, File target) throws IOException {
        int n2;
        void var2_2;
        BufferedOutputStream bufferedOutputStream;
        BufferedOutputStream bufferedOutputStream2;
        Object object;
        BufferedInputStream bufferedInputStream;
        BufferedInputStream bufferedInputStream2 = bufferedInputStream;
        bufferedInputStream = new BufferedInputStream(object.getContentResolver().openInputStream((Uri)bufferedOutputStream2));
        bufferedOutputStream2 = bufferedOutputStream;
        bufferedOutputStream = new BufferedOutputStream(object.getContentResolver().openOutputStream(Uri.fromFile((File)var2_2)));
        object = new byte[32768];
        while ((n2 = bufferedInputStream2.read((byte[])object)) > 0) {
            bufferedOutputStream2.write((byte[])object, 0, n2);
        }
        bufferedOutputStream2.close();
        bufferedInputStream2.close();
    }

    public static void deleteFile(String fileLocalPath) {
        String string2;
        PoolProvider.postIOTask(new Runnable(){

            @Override
            public void run() {
                new File(string2).delete();
            }
        });
    }

    public static DiskUtils with(Context context) {
        Context context2;
        return new DiskUtils(context2);
    }

    public static boolean isFileExist(String path) {
        String string2;
        return new File(string2).exists();
    }

    public static File createStateTextFile(Context context) {
        Context context2;
        return new File(context2.getFilesDir().getAbsolutePath() + File.pathSeparator + "crash_state" + File.pathSeparator + System.currentTimeMillis() + ".txt");
    }

    public static void deleteStateFiles() {
        Object object = Instabug.getApplicationContext();
        if (object != null) {
            FilenameFilter filenameFilter;
            object = object.getFilesDir().getParentFile();
            FilenameFilter filenameFilter2 = filenameFilter;
            filenameFilter = new FilenameFilter(){

                @Override
                public boolean accept(File file, String string2) {
                    return string2.startsWith("files:crash_state:") && string2.endsWith(".txt");
                }
            };
            if (object != null && (object = ((File)object).listFiles(filenameFilter2)) != null) {
                int n2 = ((Object)object).length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    ((File)object[i2]).delete();
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public ReadOperationExecutor readOperation(@NonNull DiskOperation<String, Void> operation) {
        void var1_1;
        return new ReadOperationExecutor((DiskOperation<String, Void>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public WriteOperationExecutor writeOperation(@NonNull DiskOperation<Uri, Context> operation) {
        void var1_1;
        return new WriteOperationExecutor(this.context, (DiskOperation<Uri, Context>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public DeleteOperationExecutor deleteOperation(@NonNull DiskOperation<Boolean, Void> operation) {
        void var1_1;
        return new DeleteOperationExecutor((DiskOperation<Boolean, Void>)var1_1);
    }
}

