/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util;

import android.content.Intent;
import android.net.Uri;
import android.webkit.URLUtil;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public final class FileUtils {
    private static final int NOT_FOUND = -1;
    private static final char EXTENSION_SEPARATOR = '.';
    private static final char UNIX_SEPARATOR = '/';
    public static final String FLAG_ENCRYPTED = "_e";

    public static int getFileType(@NonNull File file) {
        Object object;
        if (file.isDirectory()) {
            return 2;
        }
        return FileUtils.getIndexOfExtension((String)(object = ((File)object).getAbsolutePath())) == -1 ? -1 : FileUtils.getTypeFromExtension((String)object);
    }

    public static Intent getFileViewerIntent(@NonNull String pathOrUrl) {
        String string2;
        if (URLUtil.isNetworkUrl((String)pathOrUrl)) {
            return new Intent("android.intent.action.VIEW", Uri.parse((String)string2));
        }
        return FileUtils.appropriateIntent(Uri.fromFile((File)new File(string2)), FileUtils.getExtension(string2));
    }

    public static String getExtension(@NonNull File file) {
        return FileUtils.getExtension(file.getAbsolutePath());
    }

    public static String getExtension(@NonNull String absolutePath) {
        String string2;
        int n2 = FileUtils.getIndexOfExtension(absolutePath);
        return n2 == -1 ? "" : string2.substring(n2 + 1);
    }

    public static boolean isVideoFile(@NonNull File file) {
        File file2;
        if (!file.isFile()) {
            return false;
        }
        return FileUtils.isVideoExtension(FileUtils.getExtension(file2));
    }

    public static boolean isImageFile(@NonNull File file) {
        File file2;
        if (!file.isFile()) {
            return false;
        }
        return FileUtils.isImageExtension(FileUtils.getExtension(file2));
    }

    public static boolean isTextFile(@NonNull File file) {
        File file2;
        if (!file.isFile()) {
            return false;
        }
        return FileUtils.isTextExtension(FileUtils.getExtension(file2.getAbsolutePath()));
    }

    public static boolean isCacheFile(@NonNull File file) {
        File file2;
        if (!file.isFile()) {
            return false;
        }
        return FileUtils.isCacheExtension(FileUtils.getExtension(file2.getAbsolutePath()));
    }

    public static boolean isVideoExtension(@NonNull String extension) {
        String string2;
        return extension.equalsIgnoreCase("mp4") || string2.equalsIgnoreCase("avi") || string2.equalsIgnoreCase("mpg") || string2.equalsIgnoreCase("3gp") || string2.equalsIgnoreCase("3gpp") || string2.equalsIgnoreCase("ts") || string2.equalsIgnoreCase("AAC") || string2.equalsIgnoreCase("webm") || string2.equalsIgnoreCase("mkv");
    }

    public static boolean isImageExtension(@NonNull String extension) {
        String string2;
        return extension.equalsIgnoreCase("jpeg") || string2.equalsIgnoreCase("gif") || string2.equalsIgnoreCase("png") || string2.equalsIgnoreCase("bmp") || string2.equalsIgnoreCase("jpg") || string2.equalsIgnoreCase("webp");
    }

    private static boolean isTextExtension(@NonNull String extension) {
        return extension.equalsIgnoreCase("txt");
    }

    private static boolean isCacheExtension(@NonNull String extension) {
        return extension.equalsIgnoreCase("cache");
    }

    public static void sortByLastModifiedAsc(@NonNull List<File> files) {
        Comparator<File> comparator;
        Comparator<File> comparator2 = comparator;
        comparator = new Comparator<File>(){

            public int a(File file, File file2) {
                return Double.compare(file.lastModified(), file2.lastModified());
            }
        };
        Collections.sort(files, comparator2);
    }

    public static long getSize(@NonNull File file) {
        File[] fileArray;
        if (!file.exists()) {
            return 0L;
        }
        long l2 = fileArray.length();
        if (fileArray.isDirectory()) {
            int n2;
            fileArray = fileArray.listFiles();
            for (int i2 = 0; i2 < (n2 = fileArray == null ? 0 : fileArray.length); ++i2) {
                l2 += FileUtils.getSize(fileArray[i2]);
            }
        }
        return l2;
    }

    private static int getTypeFromExtension(String absolutePath) {
        String string2 = FileUtils.getExtension(absolutePath);
        if (FileUtils.isVideoExtension(string2)) {
            return 0;
        }
        if (FileUtils.isImageExtension(string2)) {
            return 1;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    private static Intent appropriateIntent(Uri uri, String extension) {
        Uri uri2;
        void var1_1;
        Intent intent;
        Intent intent2 = intent;
        intent = new Intent("android.intent.action.VIEW");
        if (!extension.equalsIgnoreCase("doc") && !var1_1.equalsIgnoreCase("docx")) {
            if (var1_1.equalsIgnoreCase("pdf")) {
                intent2.setDataAndType(uri2, "application/pdf");
            } else if (!var1_1.equalsIgnoreCase("ppt") && !var1_1.equalsIgnoreCase("pptx")) {
                if (!var1_1.equalsIgnoreCase("xls") && !var1_1.equalsIgnoreCase("xlsx")) {
                    if (!var1_1.equalsIgnoreCase("zip") && !var1_1.equalsIgnoreCase("rar")) {
                        if (var1_1.equalsIgnoreCase("rtf")) {
                            intent2.setDataAndType(uri2, "application/rtf");
                        } else if (!var1_1.equalsIgnoreCase("wav") && !var1_1.equalsIgnoreCase("mp3")) {
                            if (var1_1.equalsIgnoreCase("gif")) {
                                intent2.setDataAndType(uri2, "image/gif");
                            } else if (!(var1_1.equalsIgnoreCase("jpg") || var1_1.equalsIgnoreCase("jpeg") || var1_1.equalsIgnoreCase("png"))) {
                                if (var1_1.equalsIgnoreCase("txt")) {
                                    intent2.setDataAndType(uri2, "text/plain");
                                } else if (!(var1_1.equalsIgnoreCase("3gp") || var1_1.equalsIgnoreCase("mpg") || var1_1.equalsIgnoreCase("mpeg") || var1_1.equalsIgnoreCase("mpe") || var1_1.equalsIgnoreCase("mp4") || var1_1.equalsIgnoreCase("avi"))) {
                                    intent2.setDataAndType(uri2, "*/*");
                                } else {
                                    intent2.setDataAndType(uri2, "video/*");
                                }
                            } else {
                                intent2.setDataAndType(uri2, "image/jpeg");
                            }
                        } else {
                            intent2.setDataAndType(uri2, "audio/x-wav");
                        }
                    } else {
                        intent2.setDataAndType(uri2, "application/x-wav");
                    }
                } else {
                    intent2.setDataAndType(uri2, "application/vnd.ms-excel");
                }
            } else {
                intent2.setDataAndType(uri2, "application/vnd.ms-powerpoint");
            }
        } else {
            intent2.setDataAndType(uri2, "application/msword");
        }
        Intent intent3 = intent2;
        intent3.addFlags(0x10000000);
        return intent3;
    }

    @Nullable
    public static File getFile(String path) {
        String string2;
        File file;
        File file2 = file;
        if (new File(string2).exists()) {
            return file2;
        }
        return null;
    }

    public static boolean isFileRelatedToBugOrCrashReport(String filePath) {
        String string2;
        return filePath.contains("vusf") || string2.contains("view-hierarchy-images") || string2.contains("bug_") && string2.endsWith("_.jpg") || string2.contains("view_hierarchy_attachment_") && string2.endsWith(".zip") || string2.contains("usersteps_") && string2.endsWith(".zip");
    }

    public static int getIndexOfExtension(String filename) {
        String string2 = filename;
        int n2 = string2.lastIndexOf(46);
        if (string2.lastIndexOf(47) > n2) {
            n2 = -1;
        }
        return n2;
    }

    public static boolean isEncryptedFile(String filePath) {
        String string2 = filePath;
        return string2.substring(0, FileUtils.getIndexOfExtension(string2)).endsWith(FLAG_ENCRYPTED);
    }

    public static String getPathWithEncryptedFlag(String path) {
        int n2 = FileUtils.getIndexOfExtension(path);
        if (n2 != -1) {
            String string2;
            String string3 = string2;
            string2 = string2.substring(0, n2);
            String string4 = string3.substring(n2);
            Object[] objectArray = new Object[3];
            Object[] objectArray2 = objectArray;
            objectArray[0] = string2;
            objectArray[1] = FLAG_ENCRYPTED;
            objectArray[2] = string4;
            return String.format("%s%s%s", objectArray2);
        }
        return "";
    }

    public static String getPathWithDecryptedFlag(String path) {
        return path.replace(FLAG_ENCRYPTED, "");
    }

    public static boolean isReproStepFile(String filePath) {
        String string2;
        return (filePath.contains("step") || string2.contains("icon")) && string2.endsWith(".png") && !string2.contains("usersteps_") && !string2.endsWith(".zip");
    }
}

