/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.screenshot;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.core.content.ContextCompat;
import androidx.core.view.ViewCompat;
import com.instabug.library.PresentationManager;
import com.instabug.library.R;
import com.instabug.library.core.eventbus.CurrentActivityLifeCycleEventBus;
import com.instabug.library.invocation.InvocationManager;
import com.instabug.library.screenshot.ScreenshotProvider;
import com.instabug.library.screenshot.b;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.tracking.ActivityLifeCycleEvent;
import com.instabug.library.tracking.InstabugInternalTrackingDelegate;
import com.instabug.library.util.BitmapUtils;
import com.instabug.library.util.Colorizer;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.ScreenUtility;
import com.instabug.library.view.ViewUtils;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;

public class ExtraScreenshotHelper {
    public static final String TAG = "ExtraScreenshotHelper";
    @Nullable
    private ImageButton captureButton;
    private boolean isCaptureButtonShown = false;
    @Nullable
    private Disposable currentActivityLifeCycleDisposable;
    @Nullable
    private OnCaptureListener onCaptureListener;

    /*
     * WARNING - void declaration
     */
    private void show(@NonNull Activity hostActivity) {
        if (!this.isCaptureButtonShown && !SettingsManager.getInstance().isProcessingForeground()) {
            void var1_1;
            Object object;
            this.captureButton = object = this.createCaptureButton((Activity)var1_1);
            ViewCompat.setElevation((View)object, (float)ViewUtils.convertDpToPx(var1_1.getApplicationContext(), 5.0f));
            object = this.captureButton;
            ((ViewGroup)var1_1.getWindow().getDecorView()).addView((View)object, (ViewGroup.LayoutParams)this.createCaptureButtonContainer((Activity)var1_1));
            this.isCaptureButtonShown = true;
            object = this.captureButton;
            if (object != null) {
                View.OnClickListener onClickListener;
                ImageButton imageButton = object;
                object = onClickListener;
                onClickListener = new View.OnClickListener((Activity)var1_1){
                    final /* synthetic */ Activity a;
                    {
                        this.a = activity;
                    }

                    public void onClick(View view) {
                        a a2 = a3;
                        a2.ExtraScreenshotHelper.this.hide();
                        ExtraScreenshotHelper extraScreenshotHelper = a2.ExtraScreenshotHelper.this;
                        a a3 = a3.a;
                        ExtraScreenshotHelper.access$200(extraScreenshotHelper, (Activity)a3, extraScreenshotHelper.onCaptureListener);
                    }
                };
                imageButton.setOnClickListener((View.OnClickListener)object);
            }
            return;
        }
    }

    private ImageButton createCaptureButton(Activity hostActivity) {
        Drawable drawable2;
        ImageButton imageButton;
        ExtraScreenshotHelper extraScreenshotHelper = imageButton;
        new ImageButton((Context)drawable2).setId(R.id.instabug_extra_screenshot_button);
        extraScreenshotHelper.setScaleType(ImageView.ScaleType.CENTER);
        extraScreenshotHelper.setContentDescription(extraScreenshotHelper.getContext().getString(R.string.ibg_extra_screenshot_button_content_description));
        Drawable drawable3 = ContextCompat.getDrawable((Context)hostActivity, (int)R.drawable.ibg_core_bg_white_oval);
        drawable2 = AppCompatResources.getDrawable((Context)drawable2, (int)R.drawable.ibg_core_ic_screenshot);
        if (drawable3 != null) {
            extraScreenshotHelper.setBackgroundDrawable(Colorizer.getPrimaryColorTintedDrawable(drawable3));
        }
        if (drawable2 != null) {
            extraScreenshotHelper.setImageDrawable(drawable2);
        }
        return extraScreenshotHelper;
    }

    /*
     * WARNING - void declaration
     */
    private FrameLayout.LayoutParams createCaptureButtonContainer(Activity hostActivity) {
        void var1_1;
        FrameLayout.LayoutParams layoutParams;
        ExtraScreenshotHelper extraScreenshotHelper = layoutParams;
        new FrameLayout.LayoutParams(-2, -2, 81).setMargins(0, 0, 0, 20);
        Resources resources = hostActivity.getResources();
        if (Build.VERSION.SDK_INT >= 21 && ScreenUtility.hasNavBar((Context)var1_1) && !ScreenUtility.isLandscape((Activity)var1_1)) {
            ((FrameLayout.LayoutParams)extraScreenshotHelper).bottomMargin += ScreenUtility.getNavigationBarHeight(resources);
        }
        return extraScreenshotHelper;
    }

    /*
     * WARNING - void declaration
     */
    private void captureExtraScreenshot(Activity hostActivity, @Nullable OnCaptureListener onCaptureListener) {
        void var2_2;
        void var1_1;
        if (this.isUsingMediaProjection()) {
            b.c.a(new ScreenshotProvider.ScreenshotCapturingListener((Activity)var1_1, (OnCaptureListener)var2_2){
                final /* synthetic */ Activity a;
                final /* synthetic */ OnCaptureListener b;
                {
                    this.a = activity;
                    this.b = onCaptureListener;
                }

                @Override
                public void onScreenshotCapturedSuccessfully(Bitmap bitmap) {
                    Object object = InstabugInternalTrackingDelegate.getInstance().getCurrentActivity();
                    if (object != null) {
                        BitmapUtils.OnSaveBitmapCallback onSaveBitmapCallback;
                        Bitmap bitmap2 = bitmap;
                        BitmapUtils.maskBitmap(object, bitmap, SettingsManager.getInstance(), null);
                        bitmap = this.a;
                        object = onSaveBitmapCallback;
                        onSaveBitmapCallback = new BitmapUtils.OnSaveBitmapCallback(){

                            @Override
                            public void onSuccess(Uri uri) {
                                OnCaptureListener onCaptureListener = b;
                                if (onCaptureListener != null) {
                                    onCaptureListener.onExtraScreenshotCaptured(uri);
                                }
                            }

                            @Override
                            public void onError(Throwable throwable) {
                                InstabugSDKLogger.e(ExtraScreenshotHelper.class, throwable.getMessage(), throwable);
                            }
                        };
                        BitmapUtils.saveBitmap(bitmap2, (Context)bitmap, (BitmapUtils.OnSaveBitmapCallback)object);
                    }
                }

                @Override
                public void onScreenshotCapturingFailed(Throwable throwable) {
                    OnCaptureListener onCaptureListener = this.b;
                    if (onCaptureListener != null) {
                        onCaptureListener.onExtraScreenshotError(throwable);
                    }
                    ExtraScreenshotHelper.this.reset();
                    InstabugSDKLogger.e(ExtraScreenshotHelper.TAG, throwable.getMessage(), throwable);
                }
            });
        } else {
            ScreenshotProvider.ScreenshotCapturingListener screenshotCapturingListener;
            ScreenshotProvider.ScreenshotCapturingListener screenshotCapturingListener2 = screenshotCapturingListener;
            screenshotCapturingListener = new ScreenshotProvider.ScreenshotCapturingListener(this, (Activity)var1_1, (OnCaptureListener)var2_2){
                final /* synthetic */ Activity a;
                final /* synthetic */ OnCaptureListener b;
                {
                    this.a = activity;
                    this.b = onCaptureListener;
                }

                @Override
                public void onScreenshotCapturedSuccessfully(Bitmap bitmap) {
                    BitmapUtils.OnSaveBitmapCallback onSaveBitmapCallback;
                    Bitmap bitmap2 = bitmap;
                    bitmap = this.a;
                    BitmapUtils.OnSaveBitmapCallback onSaveBitmapCallback2 = onSaveBitmapCallback;
                    onSaveBitmapCallback = new BitmapUtils.OnSaveBitmapCallback(){

                        @Override
                        public void onSuccess(Uri uri) {
                            OnCaptureListener onCaptureListener = b;
                            if (onCaptureListener != null) {
                                onCaptureListener.onExtraScreenshotCaptured(uri);
                            }
                        }

                        @Override
                        public void onError(Throwable throwable) {
                            InstabugSDKLogger.e(ExtraScreenshotHelper.TAG, throwable.getMessage(), throwable);
                        }
                    };
                    BitmapUtils.saveBitmap(bitmap2, (Context)bitmap, onSaveBitmapCallback2);
                }

                @Override
                public void onScreenshotCapturingFailed(Throwable throwable) {
                    InstabugSDKLogger.e(ExtraScreenshotHelper.TAG, throwable.getMessage(), throwable);
                }
            };
            ScreenshotProvider.a((Activity)var1_1, screenshotCapturingListener2);
        }
    }

    private void reset() {
        this.hide();
        Activity activity = InstabugInternalTrackingDelegate.getInstance().getCurrentActivity();
        if (activity != null) {
            this.show(activity);
        }
    }

    private boolean isUsingMediaProjection() {
        return SettingsManager.getInstance().isScreenshotByMediaProjectionEnabled();
    }

    private void hide() {
        ImageButton imageButton;
        if (this.isCaptureButtonShown && (imageButton = this.captureButton) != null && imageButton.getParent() != null && this.captureButton.getParent() instanceof ViewGroup) {
            ((ViewGroup)this.captureButton.getParent()).removeView((View)this.captureButton);
            this.isCaptureButtonShown = false;
        }
    }

    private void subscribeToCurranActivityLifeCycle() {
        if (this.currentActivityLifeCycleDisposable == null) {
            this.currentActivityLifeCycleDisposable = CurrentActivityLifeCycleEventBus.getInstance().subscribe(new Consumer<ActivityLifeCycleEvent>(){

                public void a(ActivityLifeCycleEvent activityLifeCycleEvent) {
                    int n2 = e.a[activityLifeCycleEvent.ordinal()];
                    if (n2 != 1) {
                        if (n2 == 2) {
                            ExtraScreenshotHelper.this.handleCurrentActivityPauseEvent();
                        }
                    } else {
                        ExtraScreenshotHelper.this.handleCurrentActivityResumeEvent();
                    }
                }
            });
        }
    }

    private void handleCurrentActivityResumeEvent() {
        Activity activity = InstabugInternalTrackingDelegate.getInstance().getCurrentActivity();
        if (activity != null) {
            this.show(activity);
        } else {
            InstabugSDKLogger.v(TAG, "current activity equal null");
        }
    }

    private void handleCurrentActivityPauseEvent() {
        this.hide();
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$200(ExtraScreenshotHelper x02, Activity x1, OnCaptureListener x2) {
        void var2_2;
        void var1_1;
        x02.captureExtraScreenshot((Activity)var1_1, (OnCaptureListener)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @SuppressLint(value={"NULL_DEREFERENCE"})
    public void init(OnCaptureListener onCaptureListener) {
        void var1_1;
        this.onCaptureListener = var1_1;
        this.subscribeToCurranActivityLifeCycle();
        InvocationManager.getInstance().switchOffInvocation();
        PresentationManager.getInstance().setInInstabugContext(true);
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public void release() {
        ImageButton imageButton = this.captureButton;
        if (imageButton != null) {
            imageButton.setOnClickListener(null);
        }
        this.captureButton = null;
        this.onCaptureListener = null;
        imageButton = this.currentActivityLifeCycleDisposable;
        if (imageButton != null && !imageButton.isDisposed()) {
            this.currentActivityLifeCycleDisposable.dispose();
        }
        this.currentActivityLifeCycleDisposable = null;
        PresentationManager.getInstance().setInInstabugContext(false);
        InvocationManager.getInstance().switchOnInvocation();
    }

    public void cancel() {
        ExtraScreenshotHelper extraScreenshotHelper = this;
        extraScreenshotHelper.hide();
        extraScreenshotHelper.release();
    }

    public static interface OnCaptureListener {
        public void onExtraScreenshotCaptured(Uri var1);

        public void onExtraScreenshotError(Throwable var1);
    }
}

