/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.model;

import android.annotation.SuppressLint;
import android.webkit.MimeTypeMap;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.library.internal.storage.cache.Cacheable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Attachment
implements Cacheable,
Serializable {
    static final String KEY_NAME = "name";
    static final String KEY_LOCALE_PATH = "local_path";
    static final String KEY_URL = "url";
    static final String KEY_TYPE = "type";
    static final String KEY_ATTACHMENT_STATE = "attachment_state";
    static final String KEY_VIDEO_ENCODED = "video_encoded";
    static final String KEY_DURATION = "duration";
    private static final String KEY_ENCRYPTED = "isEncrypted";
    private long id;
    @Nullable
    private String name;
    @Nullable
    private String localPath;
    @Nullable
    private String url;
    @Nullable
    private Type type;
    @Nullable
    private AttachmentState attachmentState;
    private boolean isVideoEncoded;
    @Nullable
    private String duration;
    private boolean isEncrypted;
    private boolean shouldAnimate;

    public Attachment() {
        Attachment attachment = this;
        attachment.id = -1L;
        attachment.isVideoEncoded = false;
        attachment.isEncrypted = false;
        attachment.shouldAnimate = true;
        attachment.setType(Type.NOT_AVAILABLE);
        attachment.setAttachmentState(AttachmentState.NOT_AVAILABLE);
    }

    public static JSONArray toJson(List<Attachment> attachments) throws JSONException {
        List<Attachment> list;
        JSONArray jSONArray;
        JSONArray jSONArray2 = jSONArray;
        jSONArray = new JSONArray();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            jSONArray2.put((Object)new JSONObject(list.get(i2).toJson()));
        }
        return jSONArray2;
    }

    public static List<Attachment> fromJson(JSONArray attachmentsJsonArray) throws JSONException {
        JSONArray jSONArray;
        ArrayList<Attachment> arrayList;
        ArrayList<Attachment> arrayList2 = arrayList;
        arrayList = new ArrayList<Attachment>();
        for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
            Attachment attachment;
            Attachment attachment2 = attachment;
            attachment2();
            attachment.fromJson(jSONArray.getJSONObject(i2).toString());
            arrayList2.add(attachment);
        }
        return arrayList2;
    }

    public long getId() {
        return this.id;
    }

    /*
     * WARNING - void declaration
     */
    public void setId(long id2) {
        void var1_1;
        this.id = var1_1;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - void declaration
     */
    public Attachment setName(@Nullable String name) {
        void var1_1;
        this.name = var1_1;
        return this;
    }

    @Nullable
    public String getLocalPath() {
        return this.localPath;
    }

    /*
     * WARNING - void declaration
     */
    public Attachment setLocalPath(@Nullable String localPath) {
        void var1_1;
        this.localPath = var1_1;
        return this;
    }

    @Nullable
    public String getUrl() {
        return this.url;
    }

    /*
     * WARNING - void declaration
     */
    public Attachment setUrl(String url) {
        void var1_1;
        this.url = var1_1;
        return this;
    }

    @Nullable
    public Type getType() {
        return this.type;
    }

    /*
     * WARNING - void declaration
     */
    public Attachment setType(Type type) {
        void var1_1;
        this.type = var1_1;
        return this;
    }

    public boolean shouldAnimate() {
        return this.shouldAnimate;
    }

    /*
     * WARNING - void declaration
     */
    public void setShouldAnimate(boolean shouldAnimate) {
        void var1_1;
        this.shouldAnimate = var1_1;
    }

    public boolean isVideoEncoded() {
        return this.isVideoEncoded;
    }

    /*
     * WARNING - void declaration
     */
    public Attachment setVideoEncoded(boolean videoEncoded) {
        void var1_1;
        this.isVideoEncoded = var1_1;
        return this;
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public String getFileType() {
        Attachment attachment = this_;
        Object object = MimeTypeMap.getFileExtensionFromUrl((String)attachment.getName());
        String this_ = attachment.getType() == null ? "" : ((Attachment)((Object)this_)).getType().toString();
        if (object != null && !((String)object).equals("")) {
            object = MimeTypeMap.getSingleton().getMimeTypeFromExtension((String)object);
            if (object == null || ((String)object).equals("")) {
                object = this_;
            }
            return object;
        }
        return this_;
    }

    @Nullable
    public AttachmentState getAttachmentState() {
        return this.attachmentState;
    }

    /*
     * WARNING - void declaration
     */
    public Attachment setAttachmentState(AttachmentState attachmentState) {
        void var1_1;
        this.attachmentState = var1_1;
        return this;
    }

    public boolean isEncrypted() {
        return this.isEncrypted;
    }

    /*
     * WARNING - void declaration
     */
    public void setEncrypted(boolean encrypted) {
        void var1_1;
        this.isEncrypted = var1_1;
    }

    @Nullable
    public String getDuration() {
        return this.duration;
    }

    /*
     * WARNING - void declaration
     */
    public void setDuration(@Nullable String duration) {
        void var1_1;
        this.duration = var1_1;
    }

    @Override
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public String toJson() throws JSONException {
        JSONObject jSONObject;
        JSONObject jSONObject2 = jSONObject;
        jSONObject2();
        jSONObject.put(KEY_NAME, (Object)this.getName()).put(KEY_LOCALE_PATH, (Object)this.getLocalPath()).put(KEY_URL, (Object)this.getUrl()).put(KEY_VIDEO_ENCODED, this.isVideoEncoded()).put(KEY_ENCRYPTED, this.isEncrypted()).put(KEY_DURATION, (Object)this.getDuration());
        if (this.getType() != null) {
            jSONObject2.put(KEY_TYPE, (Object)this.getType().toString());
        }
        if (this.getAttachmentState() != null) {
            jSONObject2.put(KEY_ATTACHMENT_STATE, (Object)this.getAttachmentState().toString());
        }
        return jSONObject2.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fromJson(String attachmentAsJson) throws JSONException {
        void var1_1;
        JSONObject jSONObject;
        JSONObject jSONObject2 = jSONObject;
        if (new JSONObject((String)var1_1).has(KEY_NAME)) {
            this.setName(jSONObject2.getString(KEY_NAME));
        }
        if (jSONObject2.has(KEY_LOCALE_PATH)) {
            this.setLocalPath(jSONObject2.getString(KEY_LOCALE_PATH));
        }
        if (jSONObject2.has(KEY_URL)) {
            this.setUrl(jSONObject2.getString(KEY_URL));
        }
        if (jSONObject2.has(KEY_TYPE)) {
            this.setType(Type.get(jSONObject2.getString(KEY_TYPE)));
        }
        if (jSONObject2.has(KEY_ATTACHMENT_STATE)) {
            this.setAttachmentState(AttachmentState.valueOf(jSONObject2.getString(KEY_ATTACHMENT_STATE)));
        }
        if (jSONObject2.has(KEY_VIDEO_ENCODED)) {
            this.setVideoEncoded(jSONObject2.getBoolean(KEY_VIDEO_ENCODED));
        }
        if (jSONObject2.has(KEY_DURATION)) {
            this.setDuration(jSONObject2.getString(KEY_DURATION));
        }
        if (jSONObject2.has(KEY_ENCRYPTED)) {
            this.setEncrypted(jSONObject2.getBoolean(KEY_ENCRYPTED));
        }
    }

    @NonNull
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public String toString() {
        return "Name: " + this.getName() + ", Local Path: " + this.getLocalPath() + ", Type: " + (Object)((Object)this.getType()) + ", Duration: " + this.getDuration() + ", Url: " + this.getUrl() + ", Attachment State: " + (Object)((Object)this.getAttachmentState());
    }

    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public boolean equals(Object attachment) {
        if (attachment instanceof Attachment) {
            Attachment attachment2;
            return String.valueOf((attachment2 = (Attachment)attachment2).getName()).equals(String.valueOf(this.getName())) && String.valueOf(attachment2.getLocalPath()).equals(String.valueOf(this.getLocalPath())) && String.valueOf(attachment2.getUrl()).equals(String.valueOf(this.getUrl())) && attachment2.getType() == this.getType() && attachment2.getAttachmentState() == this.getAttachmentState() && attachment2.isVideoEncoded() == this.isVideoEncoded() && String.valueOf(attachment2.getDuration()).equals(String.valueOf(this.getDuration()));
        }
        return false;
    }

    public int hashCode() {
        if (this.getName() != null) {
            return this.getName().hashCode();
        }
        return -1;
    }

    public static final class AttachmentState
    extends Enum<AttachmentState> {
        public static final /* enum */ AttachmentState OFFLINE;
        public static final /* enum */ AttachmentState SYNCED;
        public static final /* enum */ AttachmentState NOT_AVAILABLE;
        private static final /* synthetic */ AttachmentState[] $VALUES;

        public static AttachmentState[] values() {
            return (AttachmentState[])$VALUES.clone();
        }

        public static AttachmentState valueOf(String name) {
            String string2;
            return Enum.valueOf(AttachmentState.class, string2);
        }

        static {
            AttachmentState attachmentState;
            OFFLINE = new AttachmentState();
            SYNCED = new AttachmentState();
            AttachmentState attachmentState2 = attachmentState;
            NOT_AVAILABLE = new AttachmentState();
            $VALUES = new AttachmentState[]{OFFLINE, SYNCED, attachmentState2};
        }
    }

    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type MAIN_SCREENSHOT;
        public static final /* enum */ Type AUDIO;
        public static final /* enum */ Type EXTRA_IMAGE;
        public static final /* enum */ Type EXTRA_VIDEO;
        public static final /* enum */ Type GALLERY_IMAGE;
        public static final /* enum */ Type GALLERY_VIDEO;
        public static final /* enum */ Type ATTACHMENT_FILE;
        public static final /* enum */ Type VIEW_HIERARCHY;
        public static final /* enum */ Type NOT_AVAILABLE;
        public static final /* enum */ Type VISUAL_USER_STEPS;
        public static final /* enum */ Type AUTO_SCREEN_RECORDING_VIDEO;
        private static final Map<String, Type> lookup;
        private static final /* synthetic */ Type[] $VALUES;
        private final String name;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String name) {
            String string2;
            return Enum.valueOf(Type.class, string2);
        }

        /*
         * WARNING - void declaration
         */
        private Type(String name) {
            void var3_3;
            this.name = var3_3;
        }

        public static Type get(String name) {
            Object object;
            if ((object = lookup.get(object)) == null) {
                object = NOT_AVAILABLE;
            }
            return object;
        }

        static {
            Type[] typeArray;
            MAIN_SCREENSHOT = new Type("main-screenshot");
            AUDIO = new Type("audio");
            EXTRA_IMAGE = new Type("extra_image");
            EXTRA_VIDEO = new Type("extra_video");
            GALLERY_IMAGE = new Type("image_gallery");
            GALLERY_VIDEO = new Type("video_gallery");
            ATTACHMENT_FILE = new Type("attachment-file");
            VIEW_HIERARCHY = new Type("view-hierarchy-v2");
            NOT_AVAILABLE = new Type("not-available");
            VISUAL_USER_STEPS = new Type("user-repro-steps-v2");
            Type[] typeArray2 = typeArray;
            AUTO_SCREEN_RECORDING_VIDEO = new Type("auto-screen-recording-v2");
            $VALUES = new Type[]{MAIN_SCREENSHOT, AUDIO, EXTRA_IMAGE, EXTRA_VIDEO, GALLERY_IMAGE, GALLERY_VIDEO, ATTACHMENT_FILE, VIEW_HIERARCHY, NOT_AVAILABLE, VISUAL_USER_STEPS, typeArray2};
            lookup = new HashMap<String, Type>();
            for (Type type : Type.values()) {
                lookup.put(type.name, type);
            }
        }

        @NonNull
        public String toString() {
            return this.name;
        }
    }
}

