/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.media;

import android.media.MediaPlayer;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.library.util.InstabugSDKLogger;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

public class AudioPlayer {
    public static final String TAG = "AudioPlayer";
    @NonNull
    private final Map<String, OnStopListener> onStopListeners;
    @Nullable
    private String filePath;
    @Nullable
    private MediaPlayer mediaPlayer;
    @Nullable
    private e onGetDurationListener;
    @Nullable
    private MediaPlayer.OnCompletionListener onCompletionListener;

    public AudioPlayer() {
        HashMap hashMap;
        HashMap this_ = hashMap;
        hashMap = new HashMap();
        v1.onStopListeners = this_;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void prepare(d actionOnPrepared) {
        MediaPlayer mediaPlayer;
        AudioPlayer audioPlayer;
        try {
            AudioPlayer audioPlayer2 = this;
            AudioPlayer audioPlayer3 = audioPlayer2;
            audioPlayer = audioPlayer2;
        }
        catch (IOException iOException) {
            InstabugSDKLogger.e(TAG, "Playing audio file failed", iOException);
            return;
        }
        MediaPlayer mediaPlayer2 = mediaPlayer;
        {
            void var1_2;
            audioPlayer3.mediaPlayer = new MediaPlayer();
            if (audioPlayer.filePath != null) {
                mediaPlayer2.setDataSource(this.filePath);
            }
            AudioPlayer audioPlayer4 = this;
            audioPlayer4.mediaPlayer.setOnPreparedListener(new MediaPlayer.OnPreparedListener((d)var1_2){
                final /* synthetic */ d a;
                {
                    this.a = d2;
                }

                public void onPrepared(MediaPlayer mediaPlayer) {
                    AudioPlayer.access$000(AudioPlayer.this, this.a);
                }
            });
            audioPlayer4.mediaPlayer.prepareAsync();
            if (audioPlayer4.onCompletionListener == null) return;
            this.mediaPlayer.setOnCompletionListener(this.onCompletionListener);
            return;
        }
    }

    private void notifyOnStopListeners() {
        Iterator<OnStopListener> this_ = ((AudioPlayer)((Object)this_)).onStopListeners.values().iterator();
        while (this_.hasNext()) {
            ((OnStopListener)this_.next()).onStop();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void stream(String filePath, d actionOnPrepared) {
        void var2_2;
        void var1_1;
        if (filePath == null) {
            InstabugSDKLogger.e(TAG, "Audio file path can not be null");
            return;
        }
        if (var1_1.equals(this.filePath)) {
            this.doAction((d)var2_2);
        } else {
            this.filePath = var1_1;
            this.prepare((d)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void doAction(d action) {
        void var1_1;
        int n2 = c.a[var1_1.ordinal()];
        if (n2 != 1) {
            if (n2 != 2) {
                e e2;
                if (n2 == 3 && (e2 = this.onGetDurationListener) != null && (this = this.mediaPlayer) != null) {
                    e2.a(this.getDuration());
                }
            } else {
                MediaPlayer mediaPlayer = this.mediaPlayer;
                if (mediaPlayer != null && mediaPlayer.isPlaying()) {
                    this.mediaPlayer.pause();
                }
            }
        } else {
            MediaPlayer mediaPlayer = this.mediaPlayer;
            if (mediaPlayer != null && !mediaPlayer.isPlaying()) {
                this.mediaPlayer.start();
            }
        }
    }

    public static String getFormattedDurationText(long durationInMillis) {
        long l2;
        int n2 = (int)(durationInMillis / 3600000L);
        long l3 = l2;
        int n3 = (int)(l3 % 3600000L / 60000L);
        int n4 = (int)(l3 % 60000L / 1000L);
        if (n2 > 0) {
            Object[] objectArray = new Object[3];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = n2;
            objectArray2[1] = n3;
            objectArray[2] = n4;
            return String.format(Locale.getDefault(), "%02d:%02d:%02d", objectArray2);
        }
        Object[] objectArray = new Object[2];
        Object[] objectArray3 = objectArray;
        objectArray3[0] = n3;
        objectArray[1] = n4;
        return String.format(Locale.getDefault(), "%02d:%02d", objectArray3);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$000(AudioPlayer x02, d x1) {
        void var1_1;
        x02.doAction((d)var1_1);
    }

    public void addOnStopListener(OnStopListener onStopListener) {
        MediaPlayer.OnCompletionListener onCompletionListener;
        AudioPlayer audioPlayer = this_;
        audioPlayer.onStopListeners.put(onCompletionListener.getFilePath(), (OnStopListener)onCompletionListener);
        if (audioPlayer.onCompletionListener == null) {
            MediaPlayer.OnCompletionListener onCompletionListener2;
            onCompletionListener = onCompletionListener2;
            onCompletionListener2 = new MediaPlayer.OnCompletionListener(){

                public void onCompletion(MediaPlayer mediaPlayer) {
                    AudioPlayer.this.notifyOnStopListeners();
                }
            };
            this_.onCompletionListener = onCompletionListener;
            AudioPlayer this_ = this_.mediaPlayer;
            if (this_ != null) {
                this_.setOnCompletionListener(onCompletionListener);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void getDurationAsync(String filePath, e onGetDurationListener) {
        void var2_2;
        void var1_1;
        this.stream((String)var1_1, d.GET_DURATION);
        this.onGetDurationListener = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public void start(String filePath) {
        void var1_1;
        AudioPlayer audioPlayer = this;
        audioPlayer.pause();
        audioPlayer.stream((String)var1_1, d.START);
    }

    public void pause() {
        AudioPlayer audioPlayer = this;
        audioPlayer.notifyOnStopListeners();
        audioPlayer.doAction(d.PAUSE);
    }

    public void release() {
        this.filePath = null;
        MediaPlayer mediaPlayer = this.mediaPlayer;
        if (mediaPlayer != null) {
            if (mediaPlayer.isPlaying()) {
                this.mediaPlayer.stop();
            }
            this.mediaPlayer.release();
            this.mediaPlayer = null;
        }
    }

    public static abstract class OnStopListener {
        private String filePath;

        /*
         * WARNING - void declaration
         */
        public OnStopListener(String filePath) {
            void var1_1;
            this.filePath = var1_1;
        }

        public String getFilePath() {
            return this.filePath;
        }

        public abstract void onStop();
    }

    public static interface e {
        public void a(int var1);
    }

    static final class d
    extends Enum<d> {
        public static final /* enum */ d START;
        public static final /* enum */ d PAUSE;
        public static final /* enum */ d GET_DURATION;
        private static final /* synthetic */ d[] $VALUES;

        public static d[] values() {
            return (d[])$VALUES.clone();
        }

        public static d valueOf(String name) {
            String string2;
            return Enum.valueOf(d.class, string2);
        }

        static {
            d d2;
            START = new d();
            PAUSE = new d();
            d d3 = d2;
            GET_DURATION = new d();
            $VALUES = new d[]{START, PAUSE, d3};
        }
    }
}

