/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.device;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.media.AudioManager;
import android.os.Build;
import androidx.annotation.NonNull;
import com.instabug.library.Instabug;
import com.instabug.library.internal.utils.stability.execution.ReturnableExecutable;
import com.instabug.library.internal.utils.stability.handler.exception.ExceptionHandler;
import com.instabug.library.util.InstabugSDKLogger;

public class InstabugDeviceProperties {
    public static final String TAG = "InstabugDeviceProperties";

    public static String getAppVersion(@NonNull Context context) {
        Object[] objectArray;
        PackageInfo packageInfo;
        PackageInfo packageInfo2 = packageInfo;
        packageInfo = new PackageInfo();
        try {
            packageInfo2 = context.getPackageManager().getPackageInfo(objectArray.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            InstabugSDKLogger.e(TAG, "failed to get app version", nameNotFoundException);
        }
        Object[] objectArray2 = new Object[2];
        objectArray = objectArray2;
        objectArray[0] = packageInfo2.versionName;
        objectArray2[1] = packageInfo2.versionCode;
        return String.format("%s (%s)", objectArray);
    }

    public static String getAppVersionName(@NonNull Context context) {
        PackageInfo packageInfo;
        PackageInfo packageInfo2 = packageInfo;
        packageInfo = new PackageInfo();
        try {
            Context context2;
            packageInfo2 = context.getPackageManager().getPackageInfo(context2.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            InstabugSDKLogger.e(TAG, "failed to get app version", nameNotFoundException);
        }
        return packageInfo2.versionName;
    }

    public static String getPackageName(@NonNull Context context) {
        String string2;
        try {
            Object object = context.getApplicationInfo().packageName;
            string2 = object;
        }
        catch (Exception exception) {
            string2 = "Could not get information";
            InstabugSDKLogger.e(TAG, "failed to get package name", exception);
        }
        return string2;
    }

    public static String getDeviceType() {
        return Build.MANUFACTURER + " " + Build.MODEL;
    }

    public static int getCurrentOSLevel() {
        return Build.VERSION.SDK_INT;
    }

    public static boolean isTablet(@NonNull Context context) {
        return (context.getResources().getConfiguration().screenLayout & 0xF) >= 3;
    }

    public static boolean checkRingerIsOn(Context context) {
        Context context2 = (AudioManager)context.getSystemService("audio");
        if (context2 != null) {
            return context2.getRingerMode() == 2;
        }
        return true;
    }

    public static boolean isFirstInstall(Context context) {
        try {
            Context context2;
            return context.getPackageManager().getPackageInfo((String)InstabugDeviceProperties.getPackageName((Context)context2), (int)0).firstInstallTime == context2.getPackageManager().getPackageInfo((String)InstabugDeviceProperties.getPackageName((Context)context2), (int)0).lastUpdateTime;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
            return true;
        }
    }

    @SuppressLint(value={"ERADICATE_RETURN_NOT_NULLABLE"})
    public static Integer getVersionCode() {
        return new ExceptionHandler().withPenaltyLog(TAG).executeAndGet(new ReturnableExecutable<Integer>(){

            @Override
            public Integer execute() throws Exception {
                a a2 = Instabug.getApplicationContext();
                if (a2 != null) {
                    return a2.getPackageManager().getPackageInfo((String)a2.getPackageName(), (int)0).versionCode;
                }
                return -1;
            }
        }, -1);
    }
}

