/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util.threading;

import android.content.Context;
import android.os.Looper;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.instabug.library.Instabug;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.memory.MemoryUtils;
import com.instabug.library.util.threading.a;
import com.instabug.library.util.threading.b;
import com.instabug.library.util.threading.c;
import com.instabug.library.util.threading.d;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class PoolProvider {
    public static final int NUMBER_OF_CORES = Runtime.getRuntime().availableProcessors();
    private static final String TAG = "PoolProvider";
    private static PoolProvider INSTANCE;
    private static Map<String, c> singleThreadPoolExecutorhMap;
    private final ThreadPoolExecutor forBitmapTasks;
    private final ThreadPoolExecutor forIOTasks;
    private final ThreadPoolExecutor forComputationTasks;
    private final ScheduledThreadPoolExecutor forScheduledTasks;
    private final Executor mainThreadExecutor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized PoolProvider getInstance() {
        if (INSTANCE == null) {
            Class<PoolProvider> clazz = PoolProvider.class;
            synchronized (PoolProvider.class) {
                INSTANCE = new PoolProvider();
            }
        }
        return INSTANCE;
    }

    @Nullable
    public static Context getContext() {
        try {
            return Instabug.getApplicationContext();
        }
        catch (IllegalStateException illegalStateException) {
            IllegalStateException illegalStateException2 = illegalStateException;
            InstabugSDKLogger.e(TAG, illegalStateException.getMessage(), illegalStateException2);
            return null;
        }
    }

    private PoolProvider() {
        LinkedBlockingQueue<Runnable> linkedBlockingQueue;
        LinkedBlockingQueue<Runnable> linkedBlockingQueue2;
        LinkedBlockingQueue<Runnable> linkedBlockingQueue3;
        b b2;
        b this_ = b2;
        b2 = new b(10);
        int n2 = NUMBER_OF_CORES;
        int n3 = n2 * 2;
        int n4 = n2 * 2 + 2;
        TimeUnit timeUnit = TimeUnit.SECONDS;
        LinkedBlockingQueue<Runnable> linkedBlockingQueue4 = linkedBlockingQueue3;
        linkedBlockingQueue3 = new LinkedBlockingQueue<Runnable>();
        v3.forBitmapTasks = new ThreadPoolExecutor(n3, n4, 10L, timeUnit, linkedBlockingQueue4, this_);
        int n5 = NUMBER_OF_CORES;
        int n6 = n5 * 2;
        n4 = n5 * 2 + 2;
        TimeUnit timeUnit2 = TimeUnit.SECONDS;
        linkedBlockingQueue4 = linkedBlockingQueue2;
        linkedBlockingQueue2 = new LinkedBlockingQueue<Runnable>();
        v3.forIOTasks = new ThreadPoolExecutor(n6, n4, 10L, timeUnit2, linkedBlockingQueue4, this_);
        int n7 = NUMBER_OF_CORES;
        int n8 = n7 * 2;
        n4 = n7 * 2 + 2;
        TimeUnit timeUnit3 = TimeUnit.SECONDS;
        linkedBlockingQueue4 = linkedBlockingQueue;
        linkedBlockingQueue = new LinkedBlockingQueue<Runnable>();
        v3.forComputationTasks = new ThreadPoolExecutor(n8, n4, 10L, timeUnit3, linkedBlockingQueue4, this_);
        v3.forScheduledTasks = new ScheduledThreadPoolExecutor(NUMBER_OF_CORES * 2, this_);
        v3.mainThreadExecutor = new a();
    }

    public static void postBitmapTask(Runnable runnable) {
        Runnable runnable2;
        InstabugSDKLogger.v(TAG, "postBitmapTask");
        PoolProvider.getInstance().forBitmapTasks.execute(new Runnable(){

            @Override
            public void run() {
                if (!MemoryUtils.isLowMemory(PoolProvider.getContext())) {
                    try {
                        runnable2.run();
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        InstabugSDKLogger.e(PoolProvider.TAG, "low memory, can't perform bitmap task", outOfMemoryError);
                    }
                } else {
                    InstabugSDKLogger.e(PoolProvider.TAG, "low memory, can't perform bitmap task");
                }
            }
        });
    }

    public static void postIOTask(Runnable runnable) {
        Runnable runnable2;
        InstabugSDKLogger.v(TAG, "postIOTask");
        PoolProvider.getInstance().forIOTasks.execute(new Runnable(){

            @Override
            public void run() {
                if (!MemoryUtils.isLowMemory(PoolProvider.getContext())) {
                    try {
                        runnable2.run();
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        InstabugSDKLogger.e(PoolProvider.TAG, "low memory, can't run i/o task", outOfMemoryError);
                    }
                } else {
                    InstabugSDKLogger.e(PoolProvider.TAG, "low memory, can't run i/o task");
                }
            }
        });
    }

    public static void postIOTaskWithCheck(Runnable runnable) {
        Runnable runnable2;
        InstabugSDKLogger.v(TAG, "postIOTaskWithCheck");
        if (Looper.myLooper() == Looper.getMainLooper()) {
            PoolProvider.postIOTask(runnable2);
        } else {
            runnable2.run();
        }
    }

    public static void postComputationTask(Runnable runnable) {
        Runnable runnable2;
        InstabugSDKLogger.v(TAG, "postComputationTask");
        PoolProvider.getInstance().forComputationTasks.execute(new Runnable(){

            @Override
            public void run() {
                if (!MemoryUtils.isLowMemory(PoolProvider.getContext())) {
                    try {
                        PoolProvider.getInstance().forComputationTasks.execute(runnable2);
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        InstabugSDKLogger.e(PoolProvider.TAG, "low memory, can't run computation task", outOfMemoryError);
                    }
                } else {
                    InstabugSDKLogger.e(PoolProvider.TAG, "low memory, can't run computation task");
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public static void postDelayedTask(Runnable runnable, long delayMillis) {
        void var1_1;
        Object object;
        Runnable runnable2 = new Runnable((Runnable)object){
            final /* synthetic */ Runnable a;
            {
                this.a = runnable;
            }

            @Override
            public void run() {
                if (!MemoryUtils.isLowMemory(PoolProvider.getContext())) {
                    try {
                        this.a.run();
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        InstabugSDKLogger.e(PoolProvider.TAG, "low memory, can't run delayed task", outOfMemoryError);
                    }
                } else {
                    InstabugSDKLogger.e(PoolProvider.TAG, "low memory, can't run delayed task");
                }
            }
        };
        object = TimeUnit.MILLISECONDS;
        PoolProvider.getInstance().forScheduledTasks.schedule(runnable2, (long)var1_1, (TimeUnit)((Object)object));
    }

    public static void postMainThreadTask(Runnable runnable) {
        Runnable runnable2;
        InstabugSDKLogger.v(TAG, "postMainThreadTask");
        PoolProvider.getInstance().mainThreadExecutor.execute(new Runnable(){

            @Override
            public void run() {
                if (!MemoryUtils.isLowMemory(PoolProvider.getContext())) {
                    try {
                        runnable2.run();
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        InstabugSDKLogger.e(PoolProvider.TAG, "low memory, can't run main thread task", outOfMemoryError);
                    }
                } else {
                    InstabugSDKLogger.e(PoolProvider.TAG, "low memory, can't run main thread task");
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public static void postTask(Executor executor, Runnable runnable) {
        void var1_1;
        Runnable runnable2;
        InstabugSDKLogger.v(TAG, "postTask");
        Runnable runnable3 = runnable2;
        runnable2 = new Runnable((Runnable)var1_1){
            final /* synthetic */ Runnable a;
            {
                this.a = runnable;
            }

            @Override
            public void run() {
                if (!MemoryUtils.isLowMemory(PoolProvider.getContext())) {
                    try {
                        this.a.run();
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        InstabugSDKLogger.e(PoolProvider.TAG, "low memory, can't run task", outOfMemoryError);
                    }
                } else {
                    InstabugSDKLogger.e(PoolProvider.TAG, "low memory, can't run task");
                }
            }
        };
        executor.execute(runnable3);
    }

    public static Executor newBackgroundExecutor() {
        b b2;
        LinkedBlockingQueue<Runnable> linkedBlockingQueue;
        int n2 = NUMBER_OF_CORES;
        int n3 = n2 * 2;
        int n4 = n2 * 2 + 1;
        TimeUnit timeUnit = TimeUnit.SECONDS;
        LinkedBlockingQueue<Runnable> linkedBlockingQueue2 = linkedBlockingQueue;
        linkedBlockingQueue = new LinkedBlockingQueue<Runnable>();
        b b3 = b2;
        b2 = new b(10);
        return new ThreadPoolExecutor(n3, n4, 60L, timeUnit, linkedBlockingQueue2, b3);
    }

    public static Executor getSingleThreadExecutor(String identifier) {
        c c2;
        String string;
        if (singleThreadPoolExecutorhMap.containsKey(string)) {
            return singleThreadPoolExecutorhMap.get(string);
        }
        c c3 = c2;
        c3();
        c2.a(string).a(new d(){

            @Override
            public void a(@Nullable String string) {
                if (string != null) {
                    singleThreadPoolExecutorhMap.remove(string);
                }
            }
        });
        singleThreadPoolExecutorhMap.put(string, c3);
        return c2;
    }

    public static Executor getUserActionsExecutor() {
        return PoolProvider.getSingleThreadExecutor("user-actions-executor");
    }

    public static synchronized Executor getApiExecutor() {
        return PoolProvider.getSingleThreadExecutor("IBG-Executor");
    }

    public static synchronized Executor getSyncExecutor() {
        return PoolProvider.getSingleThreadExecutor("IBG-sync-Executor");
    }

    static {
        singleThreadPoolExecutorhMap = new HashMap<String, c>();
    }

    public ThreadPoolExecutor getBackgroundExecutor() {
        return this.forIOTasks;
    }

    public ThreadPoolExecutor getIOExecutor() {
        return this.forIOTasks;
    }
}

