/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.apichecker;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.library.Instabug;
import com.instabug.library.apichecker.ReturnableRunnable;
import com.instabug.library.apichecker.VoidRunnable;
import com.instabug.library.apichecker.a;
import com.instabug.library.apichecker.b;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.PoolProvider;

public class APIChecker {
    private static final String TAG = "API Checker";
    public static final String NOT_BUILT_ERROR_MESSAGE = "Instabug API {%s} was called before the SDK is built. To build it, please call Instabug.Builder().build().";
    public static final String NOT_ENABLED_ERROR_MESSAGE = "Instabug API {%s} was called while the SDK is disabled. To enable it, please call Instabug.enable().";
    public static final String NOT_EXECUTED_ERROR_MESSAGE = "Instabug failed to execute {%s}";

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static <T> T checkAndGet(@NonNull String apiName, @NonNull ReturnableRunnable<T> runnable, @Nullable T fallbackValue) {
        void var2_3;
        String string2;
        try {
            APIChecker.checkBuilt();
            APIChecker.checkEnabled();
            return runnable.run();
        }
        catch (Exception exception) {
            APIChecker.logExecutionException(string2, exception);
        }
        catch (b b2) {
            APIChecker.logSdkNotEnabled(string2);
        }
        catch (a a2) {
            APIChecker.logSdkNotBuilt(string2);
        }
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    public static void checkAndRun(@NonNull String apiName, @NonNull VoidRunnable runnable) {
        String string2;
        void var1_1;
        PoolProvider.getApiExecutor().execute(new Runnable((VoidRunnable)var1_1, string2){
            final /* synthetic */ VoidRunnable a;
            final /* synthetic */ String b;
            {
                this.a = voidRunnable;
                this.b = string2;
            }

            @Override
            public void run() {
                try {
                    APIChecker.checkBuilt();
                    APIChecker.checkEnabled();
                    this.a.run();
                }
                catch (Exception exception) {
                    APIChecker.access$400(this.b, exception);
                }
                catch (b b2) {
                    APIChecker.logSdkNotEnabled(this.b);
                }
                catch (a a2) {
                    APIChecker.logSdkNotBuilt(this.b);
                }
            }
        });
    }

    public static void checkBuilt(@NonNull String apiName, @NonNull VoidRunnable runnable) {
        String string2;
        try {
            APIChecker.checkBuilt();
            runnable.run();
        }
        catch (Exception exception) {
            APIChecker.logExecutionException(string2, exception);
        }
        catch (a a2) {
            APIChecker.logSdkNotBuilt(string2);
        }
    }

    public static void checkEnable(@NonNull String apiName, @NonNull VoidRunnable runnable) {
        String string2;
        try {
            APIChecker.checkEnabled();
            runnable.run();
        }
        catch (Exception exception) {
            APIChecker.logExecutionException(string2, exception);
        }
        catch (b b2) {
            APIChecker.logSdkNotEnabled(string2);
        }
    }

    private static void checkBuilt() throws a {
        if (Instabug.isBuilt()) {
            return;
        }
        throw new a("Instabug API called before Instabug.Builder().build() was called");
    }

    private static void checkEnabled() throws b {
        if (Instabug.isEnabled()) {
            return;
        }
        throw new b("Instabug API called while Instabug SDK was disabled");
    }

    private static void logSdkNotEnabled(String apiName) {
        String string2;
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = string2;
        Log.e((String)TAG, (String)String.format(NOT_ENABLED_ERROR_MESSAGE, objectArray2));
    }

    private static void logSdkNotBuilt(String apiName) {
        String string2;
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = string2;
        Log.e((String)TAG, (String)String.format(NOT_BUILT_ERROR_MESSAGE, objectArray2));
    }

    /*
     * WARNING - void declaration
     */
    private static void logExecutionException(String apiName, Exception e2) {
        void var1_1;
        String string2;
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = string2;
        InstabugSDKLogger.e(TAG, String.format(NOT_EXECUTED_ERROR_MESSAGE, objectArray2) + " due to" + var1_1.getMessage());
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$400(String x0, Exception x1) {
        void var1_1;
        APIChecker.logExecutionException(x0, (Exception)var1_1);
    }
}

