/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.Nullable;
import androidx.core.content.res.ResourcesCompat;
import com.instabug.library.R;
import com.instabug.library.view.ViewUtils;
import com.instabug.library.view.a;

public class IconView
extends TextView {
    public static final int ANDROID_ACTIONBAR_ICON_SIZE_DP = 24;
    public static final int ANDROID_ACTIONBAR_ICON_SIZE_PADDING_DP = 1;
    @ColorInt
    int backgroundColor;
    float strokeWidth;
    @ColorInt
    int strokeColor;
    @Nullable
    Paint paint;

    /*
     * WARNING - void declaration
     */
    public IconView(Context context) {
        this((Context)var1_1, null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public IconView(Context context, @Nullable AttributeSet attrs) {
        this((Context)var1_1, (AttributeSet)var2_2, 0);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @SuppressLint(value={"ERADICATE_PARAMETER_NOT_NULLABLE"})
    public IconView(Context context, @Nullable AttributeSet attrs, int defStyle) {
        Paint paint;
        int n2;
        void var3_4;
        void var2_2;
        TypedArray typedArray;
        IconView iconView = this_;
        super((Context)typedArray, (AttributeSet)var2_2, (int)var3_4);
        iconView.backgroundColor = 0;
        iconView.strokeWidth = 0.0f;
        iconView.strokeColor = 0;
        if (iconView.isInEditMode()) {
            return;
        }
        this_.setTypeface(ResourcesCompat.getFont((Context)typedArray, (int)R.font.ibg_font_icons));
        typedArray = typedArray.obtainStyledAttributes((AttributeSet)var2_2, R.styleable.IconView);
        if (!typedArray.hasValue(R.styleable.IconView_android_textSize)) {
            this_.setActionBarSize();
        }
        if (!typedArray.hasValue(R.styleable.IconView_android_padding)) {
            this_.setActionBarPadding();
        }
        if (!typedArray.hasValue(R.styleable.IconView_android_textColor)) {
            this_.setTextColor(com.instabug.library.settings.a.G().m());
        }
        if ((n2 = typedArray.getInt(R.styleable.IconView_instabug_icon, -1)) != -1) {
            this_.setText(a.a(n2));
        }
        IconView iconView2 = this_;
        typedArray.recycle();
        IconView this_ = paint;
        paint = new Paint(1);
        iconView2.paint = this_;
    }

    private void setActionBarSize() {
        this.setTextSize(1, 24.0f);
    }

    private void setActionBarPadding() {
        IconView iconView = this;
        iconView.setPadding(ViewUtils.convertDpToPx(iconView.getContext(), 1.0f));
    }

    /*
     * WARNING - void declaration
     */
    public void setPadding(int padding) {
        void var1_1;
        void v02 = var1_1;
        this.setPadding((int)v02, (int)v02, (int)v02, (int)v02);
    }

    /*
     * WARNING - void declaration
     */
    public void setBackgroundColor(@ColorInt int color2) {
        void var1_1;
        this.backgroundColor = var1_1;
        this.invalidate();
    }

    /*
     * WARNING - void declaration
     */
    public void setStrokeWidth(float strokeWidth) {
        void var1_1;
        this.strokeWidth = var1_1;
        this.invalidate();
    }

    /*
     * WARNING - void declaration
     */
    public void setStrokeColor(@ColorInt int strokeColor) {
        void var1_1;
        this.strokeColor = var1_1;
        this.invalidate();
    }

    /*
     * WARNING - void declaration
     */
    protected void onDraw(Canvas canvas) {
        void var1_1;
        Paint paint = this.paint;
        if (paint != null) {
            IconView iconView = this;
            IconView iconView2 = this;
            paint.setColor(this.backgroundColor);
            iconView2.paint.setStyle(Paint.Style.FILL);
            float f2 = (float)iconView2.getWidth() / 2.0f;
            float f3 = (float)iconView2.getHeight() / 2.0f;
            float f4 = Math.min((float)iconView2.getWidth() / 2.0f, (float)this.getHeight() / 2.0f) - this.strokeWidth / 2.0f;
            Paint paint2 = iconView2.paint;
            var1_1.drawCircle(f2, f3, f4, paint2);
            iconView.paint.setStrokeWidth(this.strokeWidth);
            iconView.paint.setColor(this.strokeColor);
            iconView.paint.setStyle(Paint.Style.STROKE);
            f2 = (float)iconView.getWidth() / 2.0f;
            f3 = (float)iconView.getHeight() / 2.0f;
            f4 = Math.min((float)iconView.getWidth() / 2.0f, (float)this.getHeight() / 2.0f) - this.strokeWidth / 2.0f;
            paint2 = iconView.paint;
            var1_1.drawCircle(f2, f3, f4, paint2);
        }
        super.onDraw((Canvas)var1_1);
    }
}

